/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFilter;
import org.jboss.forge.shell.util.PathspecParser;

public class ResourceUtil {
    public static File getContextFile(Resource<?> r) {
        do {
            Object o;
            if (!((o = r.getUnderlyingResourceObject()) instanceof File)) continue;
            return (File)r.getUnderlyingResourceObject();
        } while ((r = r.getParent()) != null);
        return null;
    }

    public static DirectoryResource getContextDirectory(Resource<?> r) {
        Resource<?> temp = r;
        do {
            if (!(temp instanceof DirectoryResource)) continue;
            return (DirectoryResource)temp;
        } while (temp != null && (temp = temp.getParent()) != null);
        return null;
    }

    public static List<Resource<?>> parsePathspec(ResourceFactory factory, Resource<?> resource, String pathspec) {
        return new PathspecParser(factory, resource, pathspec).resolve();
    }

    public static boolean isChildOf(Resource<?> parent, Resource<?> isChild) {
        Resource<?> r = isChild;
        while ((r = r.getParent()) != null) {
            if (!r.equals(parent)) continue;
            return true;
        }
        return false;
    }

    public static <E extends Resource<?>, R extends Collection<E>> R filter(ResourceFilter filter, Collection<E> list) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        for (Resource resource : list) {
            if (!filter.accept(resource)) continue;
            result.add(resource);
        }
        return (R)result;
    }

    public static <E extends Resource<?>, R extends Collection<E>, I extends Collection<Resource<?>>> R filterByType(final Class<E> type, I list) {
        ResourceFilter filter = new ResourceFilter(){

            @Override
            public boolean accept(Resource<?> resource) {
                return type.isAssignableFrom(resource.getClass());
            }
        };
        return ResourceUtil.filter(filter, list);
    }
}

