/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.sasl;

import java.nio.ByteBuffer;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class SaslClientWrapper
extends SaslWrapper {
    private final SaslClient saslClient;

    SaslClientWrapper(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    @Override
    public byte[] wrap(byte[] bytes, int off, int len) throws SaslException {
        return this.saslClient.wrap(bytes, off, len);
    }

    @Override
    public byte[] unwrap(byte[] bytes, int off, int len) throws SaslException {
        return this.saslClient.unwrap(bytes, off, len);
    }

    @Override
    public void wrap(ByteBuffer destination, ByteBuffer source) throws SaslException {
        SaslUtils.wrap(this.saslClient, destination, source);
    }

    @Override
    public void unwrap(ByteBuffer destination, ByteBuffer source) throws SaslException {
        SaslUtils.unwrap(this.saslClient, destination, source);
    }
}

