/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.ext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ext.HibernateExtension;
import org.hibernate.eclipse.console.ext.ConsoleExtension;
import org.hibernate.eclipse.console.ext.ConsoleExtensionDefinition;

public class ConsoleExtensionManager {
    public static final String CONSOLEEXTENSION_EXTENSION_ID = "org.hibernate.eclipse.console.consoleextension";
    private static Map<String, ConsoleExtensionDefinition> consoleExtensionDefinitions;
    private static Map<HibernateExtension, ConsoleExtension> consoleExtensions;

    static {
        consoleExtensions = new HashMap<HibernateExtension, ConsoleExtension>();
    }

    private static IExtension[] findExtensions(String extensionId) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionId);
        return extensionPoint.getExtensions();
    }

    private static ConsoleExtensionDefinition[] findConsoleExtensionDefinitions() {
        ArrayList<ConsoleExtensionDefinition> exporters = new ArrayList<ConsoleExtensionDefinition>();
        IExtension[] extensions = ConsoleExtensionManager.findExtensions(CONSOLEEXTENSION_EXTENSION_ID);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                ConsoleExtensionDefinition extensiodDefinition = new ConsoleExtensionDefinition(elements[j]);
                exporters.add(extensiodDefinition);
                ++j;
            }
            ++i;
        }
        return exporters.toArray(new ConsoleExtensionDefinition[exporters.size()]);
    }

    private static synchronized Map<String, ConsoleExtensionDefinition> getConsoleExtensionDefinitionsAsMap() {
        if (consoleExtensionDefinitions == null) {
            consoleExtensionDefinitions = new TreeMap<String, ConsoleExtensionDefinition>();
            ConsoleExtensionDefinition[] findExporterDefinitions = ConsoleExtensionManager.findConsoleExtensionDefinitions();
            int i = 0;
            while (i < findExporterDefinitions.length) {
                ConsoleExtensionDefinition exporterDefinition = findExporterDefinitions[i];
                consoleExtensionDefinitions.put(exporterDefinition.getHibernateVersion(), exporterDefinition);
                ++i;
            }
        }
        return consoleExtensionDefinitions;
    }

    private static ConsoleExtensionDefinition findConsoleExtensionDefinition(String hibernateVersion) {
        return ConsoleExtensionManager.getConsoleExtensionDefinitionsAsMap().get(hibernateVersion);
    }

    public static ConsoleExtension getConsoleExtension(HibernateExtension hibernateExtension) {
        if (hibernateExtension != null) {
            ConsoleExtensionDefinition definition;
            if (!consoleExtensions.containsKey(hibernateExtension) && (definition = ConsoleExtensionManager.findConsoleExtensionDefinition(hibernateExtension.getHibernateVersion())) != null) {
                consoleExtensions.put(hibernateExtension, definition.createConsoleExtensionInstance(hibernateExtension));
            }
            return consoleExtensions.get(hibernateExtension);
        }
        return null;
    }

    public static ConsoleExtension getConsoleExtension(ConsoleConfiguration consoleConfiguration) {
        if (consoleConfiguration != null) {
            return ConsoleExtensionManager.getConsoleExtension(consoleConfiguration.getHibernateExtension());
        }
        return null;
    }
}

