/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.properties;

import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jpt.jpa.core.JpaFacet;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.dialogs.PropertyPage;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.EditConsoleConfiguration;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.utils.ProjectUtils;
import org.osgi.service.prefs.BackingStoreException;

public class HibernatePropertyPage
extends PropertyPage {
    Control[] settings;
    private Button enableHibernate;
    private String initConsoleConfiguration;
    private Combo selectedConfiguration;
    private Link details;
    private Button enableNamingStrategy;
    private Label nsSeparator;
    private boolean initNamingStrategy;
    private boolean initEnableHibernate;
    private static final String NONE = "<None>";

    private void addLogoSection(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(0x1000008, 0x1000008, true, true);
        composite.setLayoutData((Object)data);
        this.createLogoButtons(composite);
    }

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent, 2);
        this.enableHibernate = new Button(composite, 32);
        this.enableHibernate.setText(HibernateConsoleMessages.HibernatePropertyPage_enable_hibernate3_support);
        this.enableHibernate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean selection = HibernatePropertyPage.this.enableHibernate.getSelection();
                HibernatePropertyPage.this.enableSettings(selection);
            }
        });
    }

    private void createLogoButtons(Composite composite) {
        Button hibernateLogoButton = new Button(composite, 0);
        hibernateLogoButton.setImage(EclipseImages.getImage("images/hibernate.gif"));
        hibernateLogoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernatePropertyPage.this.openBrowser("http://tools.hibernate.org");
            }
        });
        Button jbossLogoButton = new Button(composite, 0);
        jbossLogoButton.setImage(EclipseImages.getImage("images/jboss.gif"));
        jbossLogoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernatePropertyPage.this.openBrowser("http://www.jboss.com/products/devstudio");
            }
        });
    }

    protected void openBrowser(String href) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            IWebBrowser browser = support.getExternalBrowser();
            browser.openURL(new URL(this.urlEncode(href.toCharArray())));
        }
        catch (MalformedURLException e) {
            this.openWebBrowserError(href, e);
        }
        catch (PartInitException e) {
            this.openWebBrowserError(href, e);
        }
    }

    private void openWebBrowserError(final String href, final Throwable t) {
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                String title = HibernateConsoleMessages.HibernatePropertyPage_open_url;
                String msg = String.valueOf(HibernateConsoleMessages.HibernatePropertyPage_unable_open_webbrowser_for_url) + href;
                IStatus status = HibernateConsolePlugin.throwableToStatus(t);
                ErrorDialog.openError((Shell)HibernatePropertyPage.this.getShell(), (String)title, (String)msg, (IStatus)status);
            }
        });
    }

    private String urlEncode(char[] input) {
        StringBuffer retu = new StringBuffer(input.length);
        int i = 0;
        while (i < input.length) {
            if (input[i] == ' ') {
                retu.append("%20");
            } else {
                retu.append(input[i]);
            }
            ++i;
        }
        return retu.toString();
    }

    private Label addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
        return separator;
    }

    private void addSecondSection(Composite parent) {
        Label ownerLabel = new Label(parent, 0);
        ownerLabel.setText(HibernateConsoleMessages.HibernatePropertyPage_default_hibernate_console_config);
        Composite settingsPart = this.createDefaultComposite(parent, 2);
        this.selectedConfiguration = new Combo(settingsPart, 12);
        GridData gd = new GridData();
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.selectedConfiguration.setLayoutData((Object)gd);
        this.selectedConfiguration.add(NONE);
        ConsoleConfiguration[] configurations = LaunchHelper.findFilteredSortedConsoleConfigs();
        int i = 0;
        while (i < configurations.length) {
            ConsoleConfiguration configuration = configurations[i];
            this.selectedConfiguration.add(configuration.getName());
            ++i;
        }
        this.details = new Link(settingsPart, 0);
        this.details.setText(HibernateConsoleMessages.HibernatePropertyPage_details);
        this.details.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsoleConfiguration config = KnownConfigurations.getInstance().find(HibernatePropertyPage.this.selectedConfiguration.getText());
                if (config != null) {
                    new EditConsoleConfiguration(config).run();
                }
            }
        });
        this.selectedConfiguration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HibernatePropertyPage.this.details.setEnabled(HibernatePropertyPage.this.selectedConfiguration.getSelectionIndex() != 0);
            }
        });
        Composite settingsPart2 = this.createDefaultComposite(parent, 2);
        this.enableNamingStrategy = new Button(settingsPart2, 32);
        this.enableNamingStrategy.setText(HibernateConsoleMessages.HibernatePropertyPage_use_naming_strategy);
        this.enableNamingStrategy.setSelection(this.initNamingStrategy);
        this.settings = new Control[]{ownerLabel, this.selectedConfiguration, this.details, this.enableNamingStrategy};
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addFirstSection(composite);
        this.addSeparator(composite);
        this.addSecondSection(composite);
        this.addSeparator(composite);
        this.nsSeparator = this.addSeparator(composite);
        this.addLogoSection(composite);
        this.loadValues();
        this.enableSettings(this.enableHibernate.getSelection());
        return composite;
    }

    private Composite createDefaultComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    protected void performDefaults() {
        this.enableHibernate.setSelection(this.initEnableHibernate);
        this.enableNamingStrategy.setSelection(this.initNamingStrategy);
        this.selectedConfiguration.setText(this.initConsoleConfiguration);
    }

    private boolean isHibernateJpaProject() {
        IProject project = this.getProject();
        if (!JpaFacet.isInstalled((IProject)project)) {
            return false;
        }
        String jpaPlatformId = JptJpaCorePlugin.getJpaPlatformId((IProject)project);
        return "hibernate".equals(jpaPlatformId) || "hibernate2_0".equals(jpaPlatformId);
    }

    private IProject getProject() {
        IJavaElement elem;
        IAdaptable adaptable = this.getElement();
        if (adaptable != null && (elem = (IJavaElement)adaptable.getAdapter(IJavaElement.class)) instanceof IJavaProject) {
            return ((IJavaProject)elem).getProject();
        }
        return null;
    }

    public void setVisible(boolean visible) {
        this.nsSeparator.setVisible(this.isHibernateJpaProject());
        this.enableNamingStrategy.setVisible(this.isHibernateJpaProject());
        super.setVisible(visible);
    }

    public void loadValues() {
        IProject project = this.getProject();
        ProjectScope scope = new ProjectScope(project);
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            this.initEnableHibernate = node.getBoolean("hibernate3.enabled", false);
            this.enableHibernate.setSelection(this.initEnableHibernate);
            String cfg = node.get("default.configuration", project.getName());
            ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(cfg);
            if (configuration == null) {
                this.selectedConfiguration.select(0);
                this.details.setEnabled(false);
            } else {
                this.initConsoleConfiguration = cfg;
                this.selectedConfiguration.setText(cfg);
            }
            this.initNamingStrategy = node.getBoolean("namingStrategy.enabled", true);
            this.enableNamingStrategy.setSelection(this.initNamingStrategy);
        }
    }

    protected void rebildProjectIfJpa() {
        if (this.isHibernateJpaProject()) {
            final JpaProject.Reference reference = (JpaProject.Reference)this.getProject().getAdapter(JpaProject.Reference.class);
            final IWorkspaceRunnable wr = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    try {
                        reference.rebuild();
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(8, "org.hibernate.eclipse.console", null, (Throwable)e));
                    }
                    HibernatePropertyPage.this.getProject().build(6, monitor);
                }
            };
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        IWorkspace ws = ResourcesPlugin.getWorkspace();
                        ws.run(wr, (ISchedulingRule)ws.getRoot(), 1, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, false, op);
            }
            catch (InvocationTargetException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.HibernatePropertyPage_Error_updating_JpaProject, e);
            }
            catch (InterruptedException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.HibernatePropertyPage_Error_updating_JpaProject, e);
            }
        }
    }

    protected boolean saveNamigStrategyChanges() {
        if (this.initNamingStrategy == this.enableNamingStrategy.getSelection()) {
            return true;
        }
        ProjectScope scope = new ProjectScope(this.getProject());
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            node.putBoolean("namingStrategy.enabled", this.enableNamingStrategy.getSelection());
            try {
                node.flush();
                return true;
            }
            catch (BackingStoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.ProjectUtils_could_not_save_changes_to_preferences, e);
            }
        }
        return false;
    }

    public boolean performOk() {
        ProjectUtils.toggleHibernateOnProject(this.getProject(), this.enableHibernate.getSelection(), this.selectedConfiguration.getSelectionIndex() != 0 ? this.selectedConfiguration.getText() : "");
        this.saveNamigStrategyChanges();
        if (this.enableHibernate.getSelection() != this.initEnableHibernate || this.initNamingStrategy != this.enableNamingStrategy.getSelection() || this.isConsoleConfigurationChanged()) {
            this.rebildProjectIfJpa();
        }
        return true;
    }

    private void enableSettings(boolean selection) {
        int i = 0;
        while (i < this.settings.length) {
            Control comp = this.settings[i];
            comp.setEnabled(selection);
            ++i;
        }
        if (selection) {
            this.details.setEnabled(this.selectedConfiguration.getSelectionIndex() != 0);
        }
    }

    protected boolean isConsoleConfigurationChanged() {
        if (this.initConsoleConfiguration == null) {
            return this.selectedConfiguration.getSelectionIndex() == 0;
        }
        return !this.initConsoleConfiguration.equals(this.selectedConfiguration.getText());
    }
}

