/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.views.QueryPageTabViewActionGroup;
import org.hibernate.eclipse.console.views.QueryPageViewer;
import org.hibernate.eclipse.console.views.properties.HibernatePropertySourceProvider;

public class QueryPageTabView
extends ViewPart
implements ISelectionProvider {
    public static final String ID = "org.hibernate.eclipse.console.views.QueryPageTabView";
    protected CTabFolder tabs = null;
    private Set<ISelectionChangedListener> listeners = Collections.synchronizedSet(new HashSet());
    protected List<QueryPageViewer> pageViewers = Collections.synchronizedList(new ArrayList());
    ListDataListener dataListener = new ListDataListener(){

        @Override
        public void contentsChanged(ListDataEvent e) {
            QueryPageTabView.this.rebuild();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            try {
                QueryPageTabView.this.getSite().getPage().showView(QueryPageTabView.ID);
            }
            catch (PartInitException partInitException) {}
            this.contentsChanged(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.contentsChanged(e);
        }
    };
    private QueryPageTabViewActionGroup actionGroup;

    public QueryPageTabView() {
        KnownConfigurations.getInstance().getQueryPageModel().addListDataListener(this.dataListener);
    }

    protected void rebuild() {
        QueryPage selection = this.getSelectedQueryPage();
        for (QueryPage results : this.getAddedResultSets()) {
            this.pageViewers.add(new QueryPageViewer(this, results));
        }
        for (QueryPage results : this.getRemovedResultSets()) {
            QueryPageViewer viewer = this.findViewerFor(results);
            this.pageViewers.remove(viewer);
            viewer.dispose();
        }
        QueryPage newSelection = this.getSelectedQueryPage();
        if (selection != null && newSelection == null) {
            this.fireSelectionChangedEvent();
        } else if (selection == null && newSelection != null) {
            this.fireSelectionChangedEvent();
        } else if (selection != null && !selection.equals(newSelection)) {
            this.fireSelectionChangedEvent();
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        KnownConfigurations.getInstance().getQueryPageModel().removeListDataListener(this.dataListener);
        int i = 0;
        while (i < this.pageViewers.size()) {
            this.pageViewers.get(i).dispose();
            ++i;
        }
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.tabs = new CTabFolder(parent, 1088);
        this.tabs.setSimple(false);
        this.tabs.setUnselectedCloseVisible(false);
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                QueryPageTabView.this.fireSelectionChangedEvent();
            }
        });
        this.tabs.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                QueryPage qp = (QueryPage)event.item.getData();
                KnownConfigurations.getInstance().getQueryPageModel().remove(qp);
            }
        });
        this.rebuild();
        this.initActions();
        this.provideSelection();
    }

    private void provideSelection() {
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    public void initActions() {
        this.actionGroup = new QueryPageTabViewActionGroup((IViewPart)this, this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.actionGroup.fillActionBars(actionBars);
    }

    public void fireSelectionChangedEvent(ISelection selection) {
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    protected void fireSelectionChangedEvent() {
        ISelection selection = this.getSelection();
        this.fireSelectionChangedEvent(selection);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            PropertySheetPage page = new PropertySheetPage();
            page.setPropertySourceProvider((IPropertySourceProvider)new HibernatePropertySourceProvider(this));
            return page;
        }
        return super.getAdapter(adapter);
    }

    public ISelection getSelection() {
        QueryPage selection = this.getSelectedQueryPage();
        return selection == null ? new StructuredSelection() : new StructuredSelection((Object)selection);
    }

    public QueryPage getSelectedQueryPage() {
        QueryPageViewer viewer = this.getSelectedQueryPageViewer();
        return viewer == null ? null : viewer.getQueryPage();
    }

    protected QueryPageViewer getSelectedQueryPageViewer() {
        QueryPageViewer selection = null;
        if (this.tabs.isDisposed()) {
            return selection;
        }
        int index = this.tabs.getSelectionIndex();
        if (index >= 0) {
            CTabItem item = this.tabs.getItem(index);
            Iterator<QueryPageViewer> i = this.pageViewers.iterator();
            while (selection == null && i.hasNext()) {
                QueryPageViewer viewer = i.next();
                if (item != viewer.getTabItem()) continue;
                selection = viewer;
            }
        }
        return selection;
    }

    private Collection<QueryPage> getRemovedResultSets() {
        List collection = KnownConfigurations.getInstance().getQueryPageModel().getPagesAsList();
        Collection<QueryPage> visible = this.getQueryPages();
        visible.removeAll(collection);
        return visible;
    }

    private Collection<QueryPage> getAddedResultSets() {
        List collection = KnownConfigurations.getInstance().getQueryPageModel().getPagesAsList();
        collection.removeAll(this.getQueryPages());
        return collection;
    }

    private Collection<QueryPage> getQueryPages() {
        ArrayList<QueryPage> list = new ArrayList<QueryPage>();
        for (QueryPageViewer viewer : this.pageViewers) {
            list.add(viewer.getQueryPage());
        }
        return list;
    }

    private QueryPageViewer findViewerFor(QueryPage results) {
        QueryPageViewer viewer = null;
        for (QueryPageViewer temp : this.pageViewers) {
            if (results == null || !results.equals(temp.getQueryPage())) continue;
            viewer = temp;
        }
        return viewer;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }
}

