/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.actions.AddConfigurationAction;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.wizards.ConsoleConfigurationWizardPage;
import org.hibernate.eclipse.console.wizards.NewConfigurationWizardPage;
import org.hibernate.tool.hbm2x.HibernateConfigurationExporter;

public class NewConfigurationWizard
extends Wizard
implements INewWizard {
    private NewConfigurationWizardPage connectionInfoPage;
    private ISelection selection;
    private WizardNewFileCreationPage cPage;
    private ConsoleConfigurationWizardPage confPage;

    public NewConfigurationWizard() {
        this.setDefaultPageImageDescriptor(EclipseImages.getImageDescriptor("NEW_WIZARD"));
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.cPage = new ExtendedWizardNewFileCreationPage("Ccfgxml", (IStructuredSelection)this.selection){

            protected InputStream getInitialContents() {
                Properties props = new Properties();
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.session_factory_name", NewConfigurationWizard.this.connectionInfoPage.getSessionFactoryName());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.dialect", NewConfigurationWizard.this.connectionInfoPage.getDialect());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.connection.driver_class", NewConfigurationWizard.this.connectionInfoPage.getDriver());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.connection.url", NewConfigurationWizard.this.connectionInfoPage.getConnectionURL());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.connection.username", NewConfigurationWizard.this.connectionInfoPage.getUsername());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.connection.password", NewConfigurationWizard.this.connectionInfoPage.getPassword());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.default_catalog", NewConfigurationWizard.this.connectionInfoPage.getDefaultCatalog());
                NewConfigurationWizard.this.putIfNotNull(props, "hibernate.default_schema", NewConfigurationWizard.this.connectionInfoPage.getDefaultSchema());
                return NewConfigurationWizard.this.openContentStream(props);
            }
        };
        this.cPage.setTitle(HibernateConsoleMessages.NewConfigurationWizard_create_hibernate_cfg_file);
        this.cPage.setDescription(HibernateConsoleMessages.NewConfigurationWizard_create_new_hibernate_cfg_xml);
        this.cPage.setFileName("hibernate.cfg.xml");
        this.cPage.setFileExtension("cfg.xml");
        this.addPage((IWizardPage)this.cPage);
        this.connectionInfoPage = new NewConfigurationWizardPage(this.selection, this.cPage);
        this.addPage((IWizardPage)this.connectionInfoPage);
        this.confPage = new ConsoleConfigurationWizardPage(this.selection);
        this.addPage((IWizardPage)this.confPage);
    }

    public boolean performFinish() {
        final Properties props = new Properties();
        this.putIfNotNull(props, "hibernate.session_factory_name", this.connectionInfoPage.getSessionFactoryName());
        this.putIfNotNull(props, "hibernate.dialect", this.connectionInfoPage.getDialect());
        this.putIfNotNull(props, "hibernate.default_catalog", this.connectionInfoPage.getDefaultCatalog());
        this.putIfNotNull(props, "hibernate.default_schema", this.connectionInfoPage.getDefaultSchema());
        this.putIfNotNull(props, "hibernate.connection.driver_class", this.connectionInfoPage.getDriver());
        this.putIfNotNull(props, "hibernate.connection.url", this.connectionInfoPage.getConnectionURL());
        this.putIfNotNull(props, "hibernate.connection.username", this.connectionInfoPage.getUsername());
        this.putIfNotNull(props, "hibernate.connection.password", this.connectionInfoPage.getPassword());
        final IFile file = this.cPage.createNewFile();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        NewConfigurationWizard.this.createHibernateCfgXml(file, props, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.NewConfigurationWizard_error, realException);
            return false;
        }
        try {
            if (this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
                this.confPage.performFinish();
            } else {
                AddConfigurationAction.deleteTemporaryLaunchConfigurations();
            }
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
        }
        return true;
    }

    public boolean performCancel() {
        try {
            this.confPage.performCancel();
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().showError(this.getShell(), HibernateConsoleMessages.AddConfigurationAction_problem_add_console_config, ce);
        }
        return true;
    }

    private void putIfNotNull(Properties props, String key, String value) {
        if (value != null) {
            props.put(key, value);
        }
    }

    private void createHibernateCfgXml(final IFile file, Properties props, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(HibernateConsoleMessages.NewConfigurationWizard_creating) + file.getName(), 2);
        InputStream stream = this.openContentStream(props);
        if (file.exists()) {
            file.setContents(stream, true, true, monitor);
        } else {
            file.create(stream, true, monitor);
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(HibernateConsoleMessages.NewConfigurationWizard_open_file_for_editing);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private InputStream openContentStream(Properties props) {
        StringWriter stringWriter = new StringWriter();
        HibernateConfigurationExporter hce = new HibernateConfigurationExporter();
        hce.setCustomProperties(props);
        hce.setOutput((Writer)stringWriter);
        hce.start();
        try {
            return new ByteArrayInputStream(stringWriter.toString().getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException uec) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.NewConfigurationWizard_problems_converting_to_utf8, uec);
            return new ByteArrayInputStream(stringWriter.toString().getBytes());
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        if (!selection.isEmpty()) {
            IJavaProject jproj = null;
            if (selection.getFirstElement() instanceof IJavaProject) {
                jproj = (IJavaProject)selection.getFirstElement();
            }
            if (selection.getFirstElement() instanceof IProject) {
                try {
                    if (((IProject)selection.getFirstElement()).getNature("org.eclipse.jdt.core.javanature") != null) {
                        jproj = (IJavaProject)((IProject)selection.getFirstElement()).getNature("org.eclipse.jdt.core.javanature");
                    }
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
            }
            if (jproj != null) {
                try {
                    IPackageFragmentRoot[] roots = jproj.getAllPackageFragmentRoots();
                    if (roots.length > 0) {
                        this.selection = new StructuredSelection((Object)roots[0]);
                    }
                }
                catch (JavaModelException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
            }
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.connectionInfoPage) {
            if (!this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
                return null;
            }
            this.confPage.setConfigurationFilePath(this.cPage.getContainerFullPath().append(this.cPage.getFileName()));
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (!this.connectionInfoPage.isCreateConsoleConfigurationEnabled()) {
            return this.connectionInfoPage.isPageComplete();
        }
        return super.canFinish();
    }

    static class ExtendedWizardNewFileCreationPage
    extends WizardNewFileCreationPage {
        boolean firstTime = true;

        public ExtendedWizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
            super(pageName, selection);
            this.setAllowExistingResources(false);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (this.firstTime) {
                this.validatePage();
                this.firstTime = false;
            }
        }

        protected boolean validatePage() {
            if (super.validatePage()) {
                String fileName = this.getFileName();
                if (!fileName.endsWith(".cfg.xml")) {
                    this.setMessage(HibernateConsoleMessages.NewConfigurationWizardPage_file_extension_should_be_cfgxml, 2);
                } else if (!fileName.equals(HibernateConsoleMessages.NewConfigurationWizardPage_filefile_name)) {
                    this.setMessage(NLS.bind((String)HibernateConsoleMessages.NewConfigurationWizardPage_fileshould_pass_configuration, (Object)fileName), 2);
                }
                IPath path = this.getContainerFullPath().append(this.getFileName());
                IFolder container = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
                try {
                    if (container != null && container.getProject().hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject proj = JavaCore.create((IProject)container.getProject());
                        IPath projRelPath = container.getProjectRelativePath();
                        IPackageFragmentRoot[] roots = proj.getAllPackageFragmentRoots();
                        boolean found = false;
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        int n = roots.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                            if (!root.isArchive() && root.getResource() != null && root.getResource().getProjectRelativePath().isPrefixOf(projRelPath)) {
                                if (!root.getResource().getProjectRelativePath().equals((Object)projRelPath)) {
                                    this.setMessage(NLS.bind((String)HibernateConsoleMessages.NewConfigurationWizardPage_fileshould_pass_configuration, (Object)fileName), 2);
                                }
                                found = true;
                                break;
                            }
                            ++n2;
                        }
                        if (!found) {
                            this.setMessage(HibernateConsoleMessages.NewConfigurationWizardPage_fileoutside_classpath, 2);
                        }
                    }
                }
                catch (CoreException e) {
                    HibernateConsolePlugin.getDefault().log(e);
                }
                return true;
            }
            return false;
        }
    }
}

