/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.Map;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.hibernate.eclipse.console.utils.EclipseImages;

public class OverlayImageIcon
extends CompositeImageDescriptor {
    public static final int TOP_LEFT = 0;
    public static final int TOP_RIGHT = 1;
    public static final int BOTTOM_LEFT = 2;
    public static final int BOTTOM_RIGHT = 3;
    private Image baseImage;
    private Point sizeOfImage;
    private Map<String, Integer> imageMap;

    public OverlayImageIcon(Image baseImage, Map<String, Integer> imageMap) {
        this.baseImage = baseImage;
        this.imageMap = imageMap;
        this.sizeOfImage = new Point(baseImage.getBounds().width, baseImage.getBounds().height);
    }

    protected void drawCompositeImage(int arg0, int arg1) {
        this.drawImage(this.baseImage.getImageData(), 0, 0);
        for (Map.Entry<String, Integer> entry : this.imageMap.entrySet()) {
            ImageData imageData = EclipseImages.getImageDescriptor(entry.getKey()).getImageData();
            switch (entry.getValue()) {
                case 0: {
                    this.drawImage(imageData, 0, 0);
                    break;
                }
                case 1: {
                    this.drawImage(imageData, this.sizeOfImage.x - imageData.width, 0);
                    break;
                }
                case 2: {
                    this.drawImage(imageData, 0, this.sizeOfImage.y - imageData.height);
                    break;
                }
                case 3: {
                    this.drawImage(imageData, this.sizeOfImage.x - imageData.width, this.sizeOfImage.y - imageData.height);
                }
            }
        }
    }

    protected Point getSize() {
        return this.sizeOfImage;
    }

    public Image getImage() {
        return this.createImage();
    }
}

