/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.hibernate.console.ConfigurationXMLFactory;
import org.hibernate.console.ConnectionProfileUtil;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.console.preferences.PreferencesClassPathUtils;
import org.hibernate.eclipse.console.model.impl.ExporterFactory;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.ExportersXMLAttributeDescription;
import org.hibernate.eclipse.launch.PathHelper;
import org.hibernate.util.xpl.StringHelper;

public class CodeGenXMLFactory {
    public static final String varBuildDir = "build.dir";
    public static final String varCurrentDir = "current.dir";
    public static final String varWorkspaceDir = "workspace.dir";
    public static final String NL = System.getProperty("line.separator");
    public static final long versionUID4PropFile = 1841714864553304000L;
    public static final long place2GenerateUID = 3855319363698081943L;
    public static final long workspacePathUID = 2720818065195124531L;
    public static final String propFileNameSuffix = "hibernate.properties";
    protected String propFileContentPreSave = "";
    protected ILaunchConfiguration lc = null;
    protected boolean externalPropFile = true;
    protected String externalPropFileName = "hibernate.properties";
    protected String place2Generate = "";
    protected String workspacePath = "";

    public CodeGenXMLFactory(ILaunchConfiguration lc) {
        this.lc = lc;
    }

    protected Element createRoot() {
        String tmStrategy;
        Element el;
        ExporterAttributes attributes = null;
        try {
            attributes = new ExporterAttributes(this.lc);
        }
        catch (CoreException coreException) {}
        if (attributes == null) {
            return null;
        }
        Properties props = new Properties();
        if (attributes.isReverseEngineer()) {
            props.setProperty("isRevEng", Boolean.toString(attributes.isReverseEngineer()));
            props.setProperty("packageName", attributes.getPackageName());
            props.setProperty("preferBasicCompositeIds", Boolean.toString(attributes.isPreferBasicCompositeIds()));
            props.setProperty("detectManyToMany", Boolean.toString(attributes.detectManyToMany()));
            props.setProperty("detectOneToOne", Boolean.toString(attributes.detectOneToOne()));
            props.setProperty("detectOptimisticLock", Boolean.toString(attributes.detectOptimisticLock()));
            props.setProperty("reverseStrategy", attributes.getRevengStrategy());
            String revEngFile = this.getResLocation(attributes.getRevengSettings());
            props.setProperty("revEngFile", revEngFile);
        }
        Path pathPlace2Generate = CodeGenXMLFactory.isEmpty(this.place2Generate) ? null : new Path(this.getResLocation(this.place2Generate));
        Path pathWorkspacePath = CodeGenXMLFactory.isEmpty(this.workspacePath) ? null : new Path(this.getResLocation(this.workspacePath));
        String consoleConfigName = attributes.getConsoleConfigurationName();
        ConsoleConfigurationPreferences consoleConfigPrefs = this.getConsoleConfigPreferences(consoleConfigName);
        ConfigurationXMLFactory configurationXMLFactory = new ConfigurationXMLFactory(consoleConfigPrefs, props);
        configurationXMLFactory.setPlace2Generate((IPath)pathPlace2Generate);
        configurationXMLFactory.setWorkspacePath((IPath)pathWorkspacePath);
        Element rootConsoleConfig = configurationXMLFactory.createRoot();
        String defaultTargetName = "hibernateAntCodeGeneration";
        Element root = DocumentFactory.getInstance().createElement("project");
        root.addAttribute("name", "CodeGen");
        root.addAttribute("default", defaultTargetName);
        if (!CodeGenXMLFactory.isEmpty(this.place2Generate)) {
            el = root.addElement("property");
            el.addAttribute("name", varCurrentDir);
            el.addAttribute("location", CodeGenXMLFactory.getPlace2GenerateUID());
        }
        if (!CodeGenXMLFactory.isEmpty(this.workspacePath)) {
            el = root.addElement("property");
            el.addAttribute("name", varWorkspaceDir);
            el.addAttribute("location", CodeGenXMLFactory.getWorkspacePathUID());
        }
        String location = this.getResLocation(attributes.getOutputPath());
        location = ConfigurationXMLFactory.makePathRelative((String)location, (IPath)pathPlace2Generate, (IPath)pathWorkspacePath);
        el = root.addElement("property");
        el.addAttribute("name", varBuildDir);
        el.addAttribute("location", location);
        String hibernatePropFile = null;
        String generateHibernatePropeties = null;
        String connProfileName = consoleConfigPrefs == null ? null : consoleConfigPrefs.getConnectionProfileName();
        IConnectionProfile profile = this.getConnectionProfile(connProfileName);
        boolean bPropFile = profile != null;
        Properties propsTmp = null;
        if (consoleConfigPrefs != null && consoleConfigPrefs.getPropertyFile() != null && (tmStrategy = (propsTmp = consoleConfigPrefs.getProperties()).getProperty("hibernate.transaction.manager_lookup_class")) != null && StringHelper.isEmpty((String)tmStrategy)) {
            propsTmp.setProperty("hibernate.transaction.manager_lookup_class", "org.hibernate.console.FakeTransactionManagerLookup");
            bPropFile = true;
        }
        if (bPropFile) {
            Object obj;
            int user2;
            int pass2;
            Object dialectName;
            TreeSet<String> specialProps = new TreeSet<String>();
            specialProps.add("hibernate.connection.driver_class");
            specialProps.add("hibernate.connection.url");
            specialProps.add("hibernate.connection.username");
            specialProps.add("hibernate.connection.password");
            specialProps.add("hibernate.dialect");
            if (propsTmp == null) {
                propsTmp = new Properties();
            }
            StringBuilder propFileContent = new StringBuilder();
            String driverClass = this.getDriverClass(connProfileName);
            if (profile != null) {
                Properties cpProperties = profile.getProperties(profile.getProviderId());
                String url = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.URL");
                String user2 = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.username");
                String pass2 = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.password");
                dialectName = consoleConfigPrefs.getDialectName();
                propsTmp.setProperty("hibernate.connection.driver_class", driverClass);
                propsTmp.setProperty("hibernate.connection.url", url);
                propsTmp.setProperty("hibernate.connection.username", user2);
                propsTmp.setProperty("hibernate.connection.password", pass2);
                if (StringHelper.isNotEmpty((String)dialectName)) {
                    propsTmp.setProperty("hibernate.dialect", (String)dialectName);
                }
            }
            Object[] keys = propsTmp.keySet().toArray();
            Arrays.sort(keys);
            if (this.externalPropFile) {
                dialectName = keys;
                pass2 = keys.length;
                user2 = 0;
                while (user2 < pass2) {
                    obj = dialectName[user2];
                    this.addIntoPropFileContent(propFileContent, obj.toString(), propsTmp.getProperty(obj.toString()));
                    ++user2;
                }
            } else {
                dialectName = keys;
                pass2 = keys.length;
                user2 = 0;
                while (user2 < pass2) {
                    obj = dialectName[user2];
                    if (specialProps.contains(obj)) {
                        el = root.addElement("property");
                        el.addAttribute("name", obj.toString());
                        el.addAttribute("value", propsTmp.getProperty(obj.toString()));
                        this.addIntoPropFileContent(propFileContent, obj.toString());
                    } else {
                        this.addIntoPropFileContent(propFileContent, obj.toString(), propsTmp.getProperty(obj.toString()));
                    }
                    ++user2;
                }
            }
            if (this.externalPropFile) {
                hibernatePropFile = this.externalPropFileName;
            } else {
                hibernatePropFile = "hibernatePropFile";
                el = root.addElement("property");
                el.addAttribute("name", hibernatePropFile);
                el.addAttribute("value", "${java.io.tmpdir}${ant.project.name}-hibernate.properties");
                generateHibernatePropeties = "generateHibernatePropeties";
                Element target = root.addElement("target");
                target.addAttribute("name", generateHibernatePropeties);
                hibernatePropFile = this.getVar(hibernatePropFile);
                Element echo = target.addElement("echo");
                echo.addAttribute("file", hibernatePropFile);
                echo.addText(CodeGenXMLFactory.getPropFileContentStubUID());
            }
            this.propFileContentPreSave = propFileContent.toString().trim();
        }
        String toolslibID = "toolslib";
        Element toolslib = root.addElement("path");
        toolslib.addAttribute("id", toolslibID);
        URL[] customClassPathURLs = PreferencesClassPathUtils.getCustomClassPathURLs((ConsoleConfigurationPreferences)consoleConfigPrefs);
        int i = 0;
        while (i < customClassPathURLs.length) {
            if (customClassPathURLs[i] != null) {
                Element pathItem = toolslib.addElement("path");
                String strPathItem = customClassPathURLs[i].getPath();
                try {
                    strPathItem = new File(customClassPathURLs[i].toURI()).getPath();
                }
                catch (URISyntaxException uRISyntaxException) {}
                strPathItem = new Path(strPathItem).toString();
                strPathItem = ConfigurationXMLFactory.makePathRelative((String)strPathItem, (IPath)pathPlace2Generate, (IPath)pathWorkspacePath);
                pathItem.addAttribute("location", strPathItem);
            }
            ++i;
        }
        Element target = root.addElement("target");
        target.addAttribute("name", defaultTargetName);
        if (!CodeGenXMLFactory.isEmpty(generateHibernatePropeties)) {
            target.addAttribute("depends", generateHibernatePropeties);
        }
        Element taskdef = target.addElement("taskdef");
        taskdef.addAttribute("name", "hibernatetool");
        taskdef.addAttribute("classname", "org.hibernate.tool.ant.HibernateToolTask");
        taskdef.addAttribute("classpathref", toolslibID);
        Element hibernatetool = target.addElement("hibernatetool");
        hibernatetool.addAttribute("destdir", this.getVar(varBuildDir));
        if (attributes.isUseOwnTemplates()) {
            String templatePath = this.getResLocation(attributes.getTemplatePath());
            hibernatetool.addAttribute("templatepath", templatePath);
        }
        if (rootConsoleConfig != null) {
            if (StringHelper.isNotEmpty((String)hibernatePropFile)) {
                rootConsoleConfig.addAttribute("propertyFile", hibernatePropFile);
            }
            hibernatetool.content().add(rootConsoleConfig);
        }
        Element classpath = hibernatetool.addElement("classpath");
        Element path = classpath.addElement("path");
        path.addAttribute("location", this.getVar(varBuildDir));
        Map<String, Map<String, ExportersXMLAttributeDescription.AttributeDescription>> exportersDescr = ExportersXMLAttributeDescription.getExportersDescription();
        Map<String, Set<String>> exportersSetSubTags = ExportersXMLAttributeDescription.getExportersSetSubTags();
        Properties globalProps = new Properties();
        globalProps.put("ejb3", "" + attributes.isEJB3Enabled());
        globalProps.put("jdk5", "" + attributes.isJDK5Enabled());
        List<ExporterFactory> exporterFactories = attributes.getExporterFactories();
        for (ExporterFactory ef : exporterFactories) {
            Object val;
            Object key;
            Set<String> setSubTags;
            if (!ef.isEnabled(this.lc)) continue;
            String expDefId = ef.getExporterDefinitionId();
            String expName = ef.getExporterTag();
            Map<String, ExportersXMLAttributeDescription.AttributeDescription> attributesDescrGui = exportersDescr.get(expName);
            if (attributesDescrGui == null) {
                attributesDescrGui = new TreeMap<String, ExportersXMLAttributeDescription.AttributeDescription>();
            }
            if ((setSubTags = exportersSetSubTags.get(expName)) == null) {
                setSubTags = new TreeSet<String>();
            }
            TreeMap<String, ExportersXMLAttributeDescription.AttributeDescription> attributesDescrAnt = new TreeMap<String, ExportersXMLAttributeDescription.AttributeDescription>();
            for (ExportersXMLAttributeDescription.AttributeDescription ad : attributesDescrGui.values()) {
                attributesDescrAnt.put(ad.name, ad);
            }
            Element exporter = hibernatetool.addElement(expName);
            Properties expProps = new Properties();
            expProps.putAll((Map<?, ?>)globalProps);
            expProps.putAll(ef.getProperties());
            Properties extractGUISpecial = new Properties();
            try {
                ExporterFactory.extractExporterProperties(expDefId, expProps, extractGUISpecial);
            }
            catch (CoreException coreException) {}
            for (Map.Entry<Object, Object> propEntry : extractGUISpecial.entrySet()) {
                Iterator<Map.Entry<Object, Object>> key2 = propEntry.getKey();
                Object val2 = propEntry.getValue();
                ExportersXMLAttributeDescription.AttributeDescription ad = attributesDescrGui.get(key2);
                if (ad == null) {
                    expProps.put(key2, val2);
                    continue;
                }
                expProps.put(ad.name, val2);
            }
            TreeMap<String, Object> expPropsSorted = new TreeMap<String, Object>();
            for (Map.Entry<Object, Object> propEntry : expProps.entrySet()) {
                Object key3 = propEntry.getKey();
                Object val3 = propEntry.getValue();
                expPropsSorted.put(key3.toString(), val3);
            }
            ArrayList list2Remove = new ArrayList();
            for (Map.Entry propEntry : expPropsSorted.entrySet()) {
                key = propEntry.getKey();
                val = propEntry.getValue();
                ExportersXMLAttributeDescription.AttributeDescription ad = (ExportersXMLAttributeDescription.AttributeDescription)attributesDescrAnt.get(key);
                if (ad == null) continue;
                list2Remove.add(key);
                if (val == null || val.toString().compareTo(ad.defaultValue) == 0) continue;
                String processedVal = this.processPropertyValue(val);
                if (setSubTags.contains(ad.guiName)) {
                    Element subTag = exporter.addElement(ad.name);
                    subTag.addText(processedVal);
                    continue;
                }
                exporter.addAttribute(ad.name, processedVal);
            }
            for (Map.Entry obj : list2Remove) {
                expProps.remove(obj);
                expPropsSorted.remove(obj);
            }
            for (Map.Entry propEntry : expPropsSorted.entrySet()) {
                key = propEntry.getKey();
                val = propEntry.getValue();
                String processedVal = this.processPropertyValue(val);
                Element property = exporter.addElement("property");
                property.addAttribute("key", key.toString());
                property.addAttribute("value", processedVal);
            }
        }
        return root;
    }

    public IConnectionProfile getConnectionProfile(String connProfileName) {
        IConnectionProfile profile = null;
        if (!CodeGenXMLFactory.isEmpty(connProfileName)) {
            profile = ProfileManager.getInstance().getProfileByName(connProfileName);
        }
        return profile;
    }

    public String getDriverClass(String connProfileName) {
        return ConnectionProfileUtil.getDriverClass((String)connProfileName);
    }

    public String getVar(String str) {
        return "${" + str + "}";
    }

    public void addIntoPropFileContent(StringBuilder pfc, String str) {
        pfc.append(String.valueOf(NL) + str + "=" + this.getVar(str));
    }

    public void addIntoPropFileContent(StringBuilder pfc, String name, String value) {
        pfc.append(String.valueOf(NL) + name + "=" + value);
    }

    public ConsoleConfigurationPreferences getConsoleConfigPreferences(String consoleConfigName) {
        ConsoleConfiguration consoleConfig = KnownConfigurations.getInstance().find(consoleConfigName);
        if (consoleConfig == null) {
            return null;
        }
        return consoleConfig.getPreferences();
    }

    public String processPropertyValue(Object val) {
        if (val == null) {
            return "";
        }
        String res = val.toString();
        String processedVal = this.getResLocation(res);
        if (new File(processedVal).exists()) {
            res = processedVal;
        }
        return res;
    }

    public IResource findResource(String path) {
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        IResource res = PathHelper.findMember(wsRoot, path);
        return res;
    }

    public String getResLocation(String path) {
        IResource outputPathRes = this.findResource(path);
        String location = path == null ? "" : path;
        location = outputPathRes != null ? outputPathRes.getLocation().toString() : new Path(location).toString();
        return location;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String getPropFileContentStubUID() {
        return Long.toHexString(1841714864553304000L);
    }

    public static String getPlace2GenerateUID() {
        return Long.toHexString(3855319363698081943L);
    }

    public static String getWorkspacePathUID() {
        return Long.toHexString(2720818065195124531L);
    }

    public String getPropFileContentPreSave() {
        return this.propFileContentPreSave == null ? "" : this.propFileContentPreSave;
    }

    public String createCodeGenXML() {
        String location;
        Element rootBuildXml = this.createRoot();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ConfigurationXMLFactory.dump((OutputStream)baos, (Element)rootBuildXml);
        String res = baos.toString().trim();
        if (!CodeGenXMLFactory.isEmpty(this.place2Generate)) {
            location = this.getResLocation(this.place2Generate);
            res = res.replace(location, this.getVar(varCurrentDir));
            res = res.replace(CodeGenXMLFactory.getPlace2GenerateUID(), location);
        }
        if (!CodeGenXMLFactory.isEmpty(this.workspacePath)) {
            location = this.getResLocation(this.workspacePath);
            res = res.replace(CodeGenXMLFactory.getWorkspacePathUID(), location);
        }
        res = res.replace(CodeGenXMLFactory.getPropFileContentStubUID(), this.getPropFileContentPreSave());
        return res;
    }

    public void setExternalPropFile(boolean externalPropFile) {
        this.externalPropFile = externalPropFile;
    }

    public void setExternalPropFileName(String externalPropFileName) {
        this.externalPropFileName = externalPropFileName;
    }

    public String getExternalPropFileName() {
        return this.externalPropFileName;
    }

    public void setPlace2Generate(String place2Generate) {
        this.place2Generate = place2Generate;
    }

    public String getPlace2Generate() {
        return this.place2Generate;
    }

    public void setWorkspacePath(String workspacePath) {
        this.workspacePath = workspacePath;
    }

    public String getWorkspacePath() {
        return this.workspacePath;
    }

    public static String getExternalPropFileNameStandard(String fileName) {
        String externalPropFileName = propFileNameSuffix;
        externalPropFileName = String.valueOf(fileName) + "." + externalPropFileName;
        return externalPropFileName;
    }
}

