/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.forge.parser.xml.query.CreateQuery;
import org.jboss.forge.parser.xml.query.GetOrCreateQuery;
import org.jboss.forge.parser.xml.query.GetQuery;
import org.jboss.forge.parser.xml.query.GetSingleQuery;
import org.jboss.forge.parser.xml.query.Pattern;
import org.jboss.forge.parser.xml.util.Patterns;

public class Node {
    private static final String SPACE = " ";
    private static final Pattern[] PATTERN_CAST = new Pattern[0];
    private final Node parent;
    private final List<Node> children = new ArrayList<Node>();
    private final String name;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String text;
    private boolean comment;

    public Node(String name) throws IllegalArgumentException {
        this(name, null);
    }

    public Node(String name, Node parent) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("name must be specified");
        }
        if (name.contains(SPACE)) {
            throw new IllegalArgumentException("name may not contain any spaces");
        }
        this.name = name;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.children.add(this);
        }
    }

    public Node attribute(String name, Object value) {
        return this.attribute(name, String.valueOf(value));
    }

    public Node attribute(String name, String value) {
        this.attributes.put(name, value);
        return this;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String removeAttribute(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must be specified");
        }
        String remove = this.attributes.remove(name);
        return remove;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public boolean isComment() {
        return this.comment;
    }

    public void setComment(boolean comment) throws IllegalArgumentException {
        if (this.children.size() > 0) {
            throw new IllegalArgumentException("Cannot mark a " + Node.class.getSimpleName() + " with children as a comment");
        }
        this.comment = comment;
    }

    public Node getRoot() {
        return this.getRoot(this);
    }

    private Node getRoot(Node start) {
        assert (start != null) : "node must be specified";
        Node parent = start.getParent();
        if (parent == null) {
            return start;
        }
        return this.getRoot(parent);
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public Node createChild(String name) throws IllegalArgumentException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name must be specified");
        }
        return this.createChild(Patterns.from(name));
    }

    public Node createChild(Pattern ... patterns) {
        return CreateQuery.INSTANCE.execute(this, patterns);
    }

    public Node getOrCreate(String name) {
        return this.getOrCreate(Patterns.from(name));
    }

    public Node getOrCreate(Pattern ... patterns) {
        return GetOrCreateQuery.INSTANCE.execute(this, patterns);
    }

    public Node getSingle(String name) {
        return this.getSingle(Patterns.from(name));
    }

    public Node getSingle(Pattern ... patterns) {
        return GetSingleQuery.INSTANCE.execute(this, patterns);
    }

    public List<Node> get(String name) {
        return this.get(Patterns.from(name));
    }

    public List<Node> get(Pattern ... patterns) {
        return GetQuery.INSTANCE.execute(this, patterns);
    }

    public List<Node> removeChildren(String name) throws IllegalArgumentException {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("Path must not be null or empty");
        }
        List<Node> found = this.get(name);
        for (Node child : found) {
            this.children.remove(child);
        }
        return found;
    }

    public List<Node> removeChildren(Pattern pattern, Pattern ... patterns) {
        Pattern[] merged = this.validateAndMergePatternInput(pattern, patterns);
        List<Node> found = this.get(merged);
        if (found == null) {
            return Collections.emptyList();
        }
        for (Node child : found) {
            this.children.remove(child);
        }
        return found;
    }

    public boolean removeChild(Node child) {
        return this.children.remove(child);
    }

    public Node removeChild(String name) {
        Node node = this.getSingle(name);
        if (node != null) {
            this.removeChild(node);
        }
        return node;
    }

    public Node text(Object text) {
        return this.text(String.valueOf(text));
    }

    public Node text(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public String getTextValueForPatternName(String name) {
        Node n = this.getSingle(name);
        String text = n == null ? null : n.getText();
        return text;
    }

    public List<String> getTextValuesForPatternName(String name) {
        ArrayList<String> result = new ArrayList<String>();
        List<Node> jars = this.get(name);
        for (Node node : jars) {
            String text = node.getText();
            if (text == null) continue;
            result.add(text);
        }
        return Collections.unmodifiableList(result);
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public List<Node> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.name + "] " + "children[" + (this.children != null ? this.children.size() : 0) + "] " + (this.attributes != null ? "attributes[" + this.attributes + "] " : "") + (this.text != null ? "text[" + this.text + "] " : "");
    }

    public String toString(boolean verbose) {
        if (!verbose) {
            return this.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Listing of ");
        sb.append(Node.class.getSimpleName());
        sb.append(" starting at: ");
        sb.append(this.getName());
        sb.append('\n');
        this.appendNodeInfo(sb, 0, this);
        return sb.toString();
    }

    private void appendNodeInfo(StringBuilder builder, int level, Node node) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            indent.append('-');
        }
        builder.append((CharSequence)indent);
        builder.append('+');
        builder.append(SPACE);
        builder.append(node.getName());
        builder.append('(');
        builder.append(node.attributes);
        builder.append(')');
        String nodeText = node.getText();
        if (nodeText != null) {
            builder.append(SPACE);
            builder.append(node.getText());
        }
        builder.append('\n');
        for (Node child : node.children) {
            this.appendNodeInfo(builder, level + 1, child);
        }
    }

    private Pattern[] validateAndMergePatternInput(Pattern pattern, Pattern ... patterns) {
        if (pattern == null) {
            throw new IllegalArgumentException("At least one pattern must not be specified");
        }
        ArrayList<Pattern> merged = new ArrayList<Pattern>();
        merged.add(pattern);
        for (Pattern p : patterns) {
            merged.add(p);
        }
        return merged.toArray(PATTERN_CAST);
    }
}

