/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.git.gitignore;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.git.gitignore.GitIgnoreEntry;
import org.jboss.forge.git.gitignore.GitIgnorePatternResource;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.resources.ResourceHandles;
import org.jboss.forge.shell.util.Streams;

@ResourceHandles(value={".gitignore"})
public class GitIgnoreResource
extends FileResource<GitIgnoreResource> {
    public static final String RESOURCE_NAME = ".gitignore";

    @Inject
    public GitIgnoreResource(ResourceFactory factory) {
        this(factory, null);
    }

    protected GitIgnoreResource(ResourceFactory factory, File file) {
        super(factory, file);
        this.setFlag(ResourceFlag.File);
    }

    public Resource<File> createFrom(File file) {
        return new GitIgnoreResource(this.getResourceFactory(), file);
    }

    protected List<Resource<?>> doListResources() {
        ArrayList patterns = new ArrayList();
        for (GitIgnoreEntry entry : this.getEntries()) {
            if (!entry.isPattern()) continue;
            patterns.add((Resource<?>)new GitIgnorePatternResource((Resource<?>)this, entry.getContent()));
        }
        return patterns;
    }

    public void addPattern(String pattern) {
        GitIgnoreEntry entry;
        List<GitIgnoreEntry> entries = this.getEntries();
        if (!entries.contains(entry = new GitIgnoreEntry(pattern))) {
            entries.add(entry);
            this.storeEntries(entries);
        }
    }

    public void addPatterns(String[] newPatterns) {
        List<GitIgnoreEntry> entries = this.getEntries();
        boolean modified = false;
        for (String pattern : newPatterns) {
            GitIgnoreEntry entry = new GitIgnoreEntry(pattern);
            if (!entries.contains(entry)) continue;
            entries.add(entry);
            modified = true;
        }
        if (modified) {
            this.storeEntries(entries);
        }
    }

    public void removePattern(String pattern) {
        GitIgnoreEntry entry;
        List<GitIgnoreEntry> entries = this.getEntries();
        if (entries.contains(entry = new GitIgnoreEntry(pattern))) {
            entries.remove(entry);
            this.storeEntries(entries);
        }
    }

    public List<String> getPatterns() {
        ArrayList<String> patterns = new ArrayList<String>();
        for (GitIgnoreEntry entry : this.getEntries()) {
            if (!entry.isPattern()) continue;
            patterns.add(entry.toString());
        }
        return patterns;
    }

    public List<GitIgnoreEntry> getEntries() {
        ArrayList<GitIgnoreEntry> arrayList;
        ArrayList<GitIgnoreEntry> lines = new ArrayList<GitIgnoreEntry>();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(this.getResourceInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                lines.add(new GitIgnoreEntry(line));
            }
            arrayList = lines;
        }
        catch (IOException e) {
            try {
                throw new RuntimeException("Error while reading .gitignore patterns", e);
            }
            catch (Throwable throwable) {
                Streams.closeQuietly(reader);
                throw throwable;
            }
        }
        Streams.closeQuietly((Closeable)reader);
        return arrayList;
    }

    protected void storeEntries(List<GitIgnoreEntry> entries) {
        StringBuilder contents = new StringBuilder();
        for (GitIgnoreEntry entry : entries) {
            contents.append(entry.toString()).append("\n");
        }
        this.setContents(contents.toString());
    }
}

