/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.openshift.client.ApplicationScale;
import com.openshift.client.HttpMethod;
import com.openshift.client.IApplication;
import com.openshift.client.IApplicationGear;
import com.openshift.client.IApplicationGearComponent;
import com.openshift.client.IApplicationPortForwarding;
import com.openshift.client.ICartridge;
import com.openshift.client.IDomain;
import com.openshift.client.IEmbeddableCartridge;
import com.openshift.client.IEmbeddedCartridge;
import com.openshift.client.IGearProfile;
import com.openshift.client.IOpenShiftConnection;
import com.openshift.client.OpenShiftEndpointException;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftSSHOperationException;
import com.openshift.client.utils.HostUtils;
import com.openshift.client.utils.RFC822DateUtils;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationGearComponentResource;
import com.openshift.internal.client.ApplicationGearResource;
import com.openshift.internal.client.DomainResource;
import com.openshift.internal.client.EmbeddedCartridgeResource;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.GearComponentDTO;
import com.openshift.internal.client.response.GearResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.Message;
import com.openshift.internal.client.ssh.ApplicationPortForwarding;
import com.openshift.internal.client.utils.Assert;
import com.openshift.internal.client.utils.CollectionUtils;
import com.openshift.internal.client.utils.IOpenShiftJsonConstants;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationResource
extends AbstractOpenShiftResource
implements IApplication {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationResource.class);
    private static final long APPLICATION_WAIT_RETRY_DELAY = 2048L;
    private static final String LINK_GET_APPLICATION = "GET";
    private static final String LINK_DELETE_APPLICATION = "DELETE";
    private static final String LINK_START_APPLICATION = "START";
    private static final String LINK_STOP_APPLICATION = "STOP";
    private static final String LINK_STATUS_APPLICATION = "STATUS";
    private static final String LINK_FORCE_STOP_APPLICATION = "FORCE_STOP";
    private static final String LINK_RESTART_APPLICATION = "RESTART";
    private static final String LINK_SCALE_UP = "SCALE_UP";
    private static final String LINK_SCALE_DOWN = "SCALE_DOWN";
    private static final String LINK_SHOW_PORT = "SHOW_PORT";
    private static final String LINK_EXPOSE_PORT = "EXPOSE_PORT";
    private static final String LINK_CONCEAL_PORT = "CONCEAL_PORT";
    private static final String LINK_ADD_ALIAS = "ADD_ALIAS";
    private static final String LINK_REMOVE_ALIAS = "REMOVE_ALIAS";
    private static final String LINK_ADD_CARTRIDGE = "ADD_CARTRIDGE";
    private static final String LINK_LIST_CARTRIDGES = "LIST_CARTRIDGES";
    private static final String LINK_LIST_GEARS = "GET_GEARS";
    private final String uuid;
    private final String name;
    private final Date creationTime;
    private final ICartridge cartridge;
    private final ApplicationScale scale;
    private final IGearProfile gearProfile;
    private final DomainResource domain;
    private final String applicationUrl;
    private final String healthCheckUrl;
    private final String gitUrl;
    private final List<String> aliases;
    private List<IEmbeddedCartridge> embeddedCartridges = null;
    private List<IApplicationGear> gears = null;
    private List<IApplicationPortForwarding> ports = null;
    private Session session;
    private Map<String, String> embeddedCartridgesInfos;

    protected ApplicationResource(ApplicationResourceDTO dto, ICartridge cartridge, DomainResource domain) {
        this(dto.getName(), dto.getUuid(), dto.getCreationTime(), dto.getCreationLog(), dto.getApplicationUrl(), dto.getGitUrl(), dto.getHealthCheckPath(), dto.getGearProfile(), dto.getApplicationScale(), cartridge, dto.getAliases(), dto.getEmbeddedCartridgeInfos(), dto.getLinks(), domain);
    }

    protected ApplicationResource(String name, String uuid, String creationTime, List<Message> creationLog, String applicationUrl, String gitUrl, String healthCheckPath, IGearProfile gearProfile, ApplicationScale scale, ICartridge cartridge, List<String> aliases, Map<String, String> embeddedCartridgesInfos, Map<String, Link> links, DomainResource domain) {
        super(domain.getService(), links, creationLog);
        this.name = name;
        this.uuid = uuid;
        this.creationTime = RFC822DateUtils.safeGetDate(creationTime);
        this.scale = scale;
        this.gearProfile = gearProfile;
        this.cartridge = cartridge;
        this.applicationUrl = applicationUrl;
        this.gitUrl = gitUrl;
        this.healthCheckUrl = applicationUrl + healthCheckPath;
        this.domain = domain;
        this.aliases = aliases;
        this.embeddedCartridgesInfos = embeddedCartridgesInfos;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ApplicationScale getApplicationScale() {
        return this.scale;
    }

    @Override
    public IGearProfile getGearProfile() {
        return this.gearProfile;
    }

    @Override
    public String getUUID() {
        return this.uuid;
    }

    @Override
    public ICartridge getCartridge() {
        return this.cartridge;
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public IDomain getDomain() {
        return this.domain;
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteApplicationRequest().execute(new ServiceParameter[0]);
        this.domain.removeApplication(this);
    }

    @Override
    public void start() throws OpenShiftException {
        new StartApplicationRequest().execute();
    }

    @Override
    public void restart() throws OpenShiftException {
        new RestartApplicationRequest().execute();
    }

    @Override
    public void stop() throws OpenShiftException {
        this.stop(false);
    }

    @Override
    public void stop(boolean force) throws OpenShiftException {
        if (force) {
            new ForceStopApplicationRequest().execute();
        } else {
            new StopApplicationRequest().execute();
        }
    }

    @Override
    public void exposePort() throws OpenShiftException {
        new ExposePortRequest().execute();
    }

    @Override
    public void concealPort() throws OpenShiftException {
        new ConcealPortRequest().execute();
    }

    @Override
    public void showPort() throws OpenShiftException {
        new ShowPortRequest().execute();
    }

    public void getDescriptor() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void scaleDown() throws OpenShiftException {
        new ScaleDownRequest().execute();
    }

    @Override
    public void scaleUp() throws OpenShiftException {
        new ScaleUpRequest().execute();
    }

    @Override
    public void addAlias(String alias) throws OpenShiftException {
        Assert.notNull(alias);
        ApplicationResourceDTO applicationDTO = (ApplicationResourceDTO)new AddAliasRequest().execute(alias);
        this.updateAliases(applicationDTO);
    }

    private void updateAliases(ApplicationResourceDTO applicationDTO) {
        Assert.notNull(applicationDTO);
        this.aliases.clear();
        this.aliases.addAll(applicationDTO.getAliases());
    }

    @Override
    public List<String> getAliases() {
        return Collections.unmodifiableList(this.aliases);
    }

    @Override
    public boolean hasAlias(String name) {
        Assert.notNull(name);
        return this.aliases.contains(name);
    }

    @Override
    public void removeAlias(String alias) throws OpenShiftException {
        Assert.notNull(alias);
        ApplicationResourceDTO applicationDTO = (ApplicationResourceDTO)new RemoveAliasRequest().execute(alias);
        this.updateAliases(applicationDTO);
    }

    @Override
    public String getGitUrl() {
        return this.gitUrl;
    }

    @Override
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    @Override
    public String getHealthCheckUrl() {
        return this.healthCheckUrl;
    }

    protected String getHealthCheckSuccessResponse() throws OpenShiftException {
        return "1";
    }

    @Override
    public IEmbeddedCartridge addEmbeddableCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        if (this.embeddedCartridges == null) {
            this.loadEmbeddedCartridges();
        }
        CartridgeResourceDTO embeddedCartridgeDTO = (CartridgeResourceDTO)new AddEmbeddedCartridgeRequest().execute(cartridge.getName());
        EmbeddedCartridgeResource embeddedCartridge = new EmbeddedCartridgeResource(this.embeddedCartridgesInfos.get(embeddedCartridgeDTO.getName()), embeddedCartridgeDTO, this);
        this.embeddedCartridges.add(embeddedCartridge);
        return embeddedCartridge;
    }

    @Override
    public List<IEmbeddedCartridge> addEmbeddableCartridges(List<IEmbeddableCartridge> cartridges) throws OpenShiftException {
        Assert.notNull(cartridges);
        ArrayList<IEmbeddedCartridge> addedCartridge = new ArrayList<IEmbeddedCartridge>();
        for (IEmbeddableCartridge cartridge : cartridges) {
            addedCartridge.add(this.addEmbeddableCartridge(cartridge));
        }
        return addedCartridge;
    }

    protected void removeEmbeddedCartridge(IEmbeddedCartridge embeddedCartridge) throws OpenShiftException {
        Assert.notNull(embeddedCartridge);
        this.embeddedCartridges.remove(embeddedCartridge);
    }

    private List<IEmbeddedCartridge> loadEmbeddedCartridges() throws OpenShiftException {
        this.embeddedCartridges = new ArrayList<IEmbeddedCartridge>();
        List embeddableCartridgeDTOs = (List)new ListEmbeddableCartridgesRequest().execute(new ServiceParameter[0]);
        for (CartridgeResourceDTO embeddableCartridgeDTO : embeddableCartridgeDTOs) {
            EmbeddedCartridgeResource embeddableCartridge = new EmbeddedCartridgeResource(this.embeddedCartridgesInfos.get(embeddableCartridgeDTO.getName()), embeddableCartridgeDTO, this);
            this.embeddedCartridges.add(embeddableCartridge);
        }
        return this.embeddedCartridges;
    }

    @Override
    public List<IEmbeddedCartridge> getEmbeddedCartridges() throws OpenShiftException {
        if (this.embeddedCartridges == null) {
            this.embeddedCartridges = this.loadEmbeddedCartridges();
        }
        return CollectionUtils.toUnmodifiableCopy(this.embeddedCartridges);
    }

    @Override
    public boolean hasEmbeddedCartridge(String cartridgeName) throws OpenShiftException {
        Assert.notNull(cartridgeName);
        return this.getEmbeddedCartridge(cartridgeName) != null;
    }

    @Override
    public boolean hasEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        return this.getEmbeddedCartridge(cartridge) != null;
    }

    @Override
    public IEmbeddedCartridge getEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        return this.getEmbeddedCartridge(cartridge.getName());
    }

    @Override
    public IEmbeddedCartridge getEmbeddedCartridge(String cartridgeName) throws OpenShiftException {
        Assert.notNull(cartridgeName);
        for (IEmbeddedCartridge embeddedCartridge : this.getEmbeddedCartridges()) {
            if (!cartridgeName.equals(embeddedCartridge.getName())) continue;
            return embeddedCartridge;
        }
        return null;
    }

    @Override
    public void removeEmbeddedCartridge(IEmbeddableCartridge cartridge) throws OpenShiftException {
        Assert.notNull(cartridge);
        IEmbeddedCartridge embeddedCartridge = this.getEmbeddedCartridge(cartridge);
        if (embeddedCartridge != null) {
            embeddedCartridge.destroy();
        }
    }

    @Override
    public List<IApplicationGear> getGears() throws OpenShiftException {
        if (this.gears == null) {
            this.gears = this.loadGears();
        }
        return Collections.unmodifiableList(this.gears);
    }

    private List<IApplicationGear> loadGears() throws OpenShiftException {
        this.gears = new ArrayList<IApplicationGear>();
        List gearDTOs = (List)new ListGearsRequest().execute(new ServiceParameter[0]);
        for (GearResourceDTO gearDTO : gearDTOs) {
            ArrayList<IApplicationGearComponent> components = new ArrayList<IApplicationGearComponent>();
            for (GearComponentDTO gearComponentDTO : gearDTO.getComponents()) {
                components.add(new ApplicationGearComponentResource(gearComponentDTO));
            }
            ApplicationGearResource gear = new ApplicationGearResource(gearDTO, components, this);
            this.gears.add(gear);
        }
        return this.gears;
    }

    @Override
    public boolean waitForAccessible(long timeout) throws OpenShiftException {
        try {
            long startTime = System.currentTimeMillis();
            if (!this.waitForResolved(timeout, startTime)) {
                return false;
            }
            return this.waitForPositiveHealthResponse(timeout, startTime);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public Future<Boolean> waitForAccessibleAsync(final long timeout) throws OpenShiftException {
        IOpenShiftConnection connection = this.getDomain().getUser().getConnection();
        return connection.getExecutorService().submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ApplicationResource.this.waitForAccessible(timeout);
            }
        });
    }

    private boolean waitForPositiveHealthResponse(long timeout, long startTime) throws OpenShiftException, InterruptedException, OpenShiftEndpointException {
        String response = null;
        while (!this.isPositiveHealthResponse(response) && !this.isTimeouted(timeout, startTime)) {
            try {
                Thread.sleep(2048L);
                response = this.getService().request(this.healthCheckUrl, HttpMethod.GET, null);
            }
            catch (OpenShiftEndpointException e) {
                throw e;
            }
            catch (OpenShiftException e) {
            }
        }
        return this.isPositiveHealthResponse(response);
    }

    private boolean isPositiveHealthResponse(String response) throws OpenShiftException {
        return response != null && response.startsWith(this.getHealthCheckSuccessResponse());
    }

    private boolean waitForResolved(long timeout, long startTime) throws OpenShiftException, InterruptedException {
        try {
            while (!HostUtils.canResolv(this.healthCheckUrl) && !this.isTimeouted(timeout, startTime)) {
                Thread.sleep(2048L);
            }
            return HostUtils.canResolv(this.healthCheckUrl);
        }
        catch (MalformedURLException e) {
            throw new OpenShiftException(e, "Could not wait for application {0} to become accessible, it has an invalid URL \"{1}\": {2}", this.name, this.healthCheckUrl, e.getMessage());
        }
    }

    private boolean isTimeouted(long timeout, long startTime) {
        return System.currentTimeMillis() >= startTime + timeout;
    }

    @Override
    public void refresh() throws OpenShiftException {
        if (this.embeddedCartridges != null) {
            this.embeddedCartridges = this.loadEmbeddedCartridges();
        }
        if (this.gears != null) {
            this.gears = this.loadGears();
        }
        if (this.ports != null) {
            this.ports = this.loadPorts();
        }
    }

    @Override
    public void setSSHSession(Session session) {
        this.session = session;
    }

    @Override
    public Session getSSHSession() {
        return this.session;
    }

    @Override
    public boolean hasSSHSession() {
        return this.session != null && this.session.isConnected();
    }

    @Override
    public boolean isPortFowardingStarted() throws OpenShiftSSHOperationException {
        try {
            return this.session != null && this.session.isConnected() && this.session.getPortForwardingL().length > 0;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Unable to verify if port-forwarding has been started for application \"{0}\"", this.getName());
        }
    }

    @Override
    public List<IApplicationPortForwarding> refreshForwardablePorts() throws OpenShiftSSHOperationException {
        this.ports = this.loadPorts();
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> getForwardablePorts() throws OpenShiftSSHOperationException {
        if (this.ports == null) {
            this.ports = this.loadPorts();
        }
        return this.ports;
    }

    @Override
    public List<String> getEnvironmentProperties() throws OpenShiftSSHOperationException {
        ArrayList<String> openshiftProps = new ArrayList<String>();
        List<String> allEnvProps = this.sshExecCmd("set", EnumSshStream.INPUT);
        for (String line : allEnvProps) {
            if (!line.startsWith("OPENSHIFT_") && !line.startsWith("JENKINS_")) continue;
            openshiftProps.add(line);
        }
        return openshiftProps;
    }

    private List<IApplicationPortForwarding> loadPorts() throws OpenShiftSSHOperationException {
        this.ports = new ArrayList<IApplicationPortForwarding>();
        List<String> lines = this.sshExecCmd("rhc-list-ports", EnumSshStream.EXT_INPUT);
        for (String line : lines) {
            ApplicationPortForwarding port = ApplicationResource.extractForwardablePortFrom(this, line);
            if (port == null) continue;
            this.ports.add(port);
        }
        return this.ports;
    }

    private List<String> sshExecCmd(String command, EnumSshStream streamToUse) throws OpenShiftSSHOperationException {
        Session session = this.getSSHSession();
        if (session == null) {
            throw new OpenShiftSSHOperationException("No SSH session available for application ''{0}''", this.getName());
        }
        Channel channel = null;
        BufferedReader reader = null;
        try {
            String line;
            session.openChannel("exec");
            channel = session.openChannel("exec");
            ((ChannelExec)channel).setCommand(command);
            channel.connect();
            ArrayList<String> lines = new ArrayList<String>();
            switch (streamToUse) {
                case EXT_INPUT: {
                    reader = new BufferedReader(new InputStreamReader(channel.getExtInputStream()));
                    break;
                }
                case INPUT: {
                    reader = new BufferedReader(new InputStreamReader(channel.getInputStream()));
                }
            }
            while ((line = reader.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
        catch (JSchException e) {
            throw new OpenShiftSSHOperationException(e, "Failed to list forwardable ports for application \"{0}\"", this.getName());
        }
        catch (IOException e) {
            throw new OpenShiftSSHOperationException(e, "Failed to list forwardable ports for application \"{0}\"", this.getName());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Failed to close SSH error stream reader", (Throwable)e);
                }
            }
            if (channel != null && channel.isConnected()) {
                channel.disconnect();
            }
        }
    }

    private static ApplicationPortForwarding extractForwardablePortFrom(IApplication application, String portValue) {
        if (portValue.contains("->")) {
            try {
                StringTokenizer nameTokenizer = new StringTokenizer(portValue, "->");
                String name = nameTokenizer.nextToken().trim();
                StringTokenizer ipPortTokenizer = new StringTokenizer(nameTokenizer.nextToken(), ":");
                String remoteIp = ipPortTokenizer.nextToken().trim();
                int remotePort = Integer.parseInt(ipPortTokenizer.nextToken().trim());
                return new ApplicationPortForwarding(application, name, remoteIp, remotePort);
            }
            catch (NoSuchElementException e) {
                LOGGER.error("Failed to parse remote port: " + portValue, (Throwable)e);
                throw e;
            }
        }
        return null;
    }

    @Override
    public List<IApplicationPortForwarding> startPortForwarding() throws OpenShiftSSHOperationException {
        if (!this.hasSSHSession()) {
            throw new OpenShiftSSHOperationException("SSH session for application \"{0}\" is closed or null. Cannot start port forwarding", this.getName());
        }
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.start(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {}
        }
        return this.ports;
    }

    @Override
    public List<IApplicationPortForwarding> stopPortForwarding() throws OpenShiftSSHOperationException {
        for (IApplicationPortForwarding port : this.ports) {
            try {
                port.stop(this.session);
            }
            catch (OpenShiftSSHOperationException openShiftSSHOperationException) {}
        }
        this.session.disconnect();
        return this.ports;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ApplicationResource other = (ApplicationResource)object;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return this.name;
    }

    private class ListGearsRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ListGearsRequest() {
            super(ApplicationResource.LINK_LIST_GEARS);
        }
    }

    private class ListEmbeddableCartridgesRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ListEmbeddableCartridgesRequest() {
            super(ApplicationResource.LINK_LIST_CARTRIDGES);
        }
    }

    private class AddEmbeddedCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected AddEmbeddedCartridgeRequest() {
            super(ApplicationResource.LINK_ADD_CARTRIDGE);
        }

        public <DTO> DTO execute(String embeddedCartridgeName) throws OpenShiftException {
            return super.execute(new ServiceParameter("cartridge", embeddedCartridgeName));
        }
    }

    private class RemoveAliasRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected RemoveAliasRequest() {
            super(ApplicationResource.LINK_REMOVE_ALIAS);
        }

        public <DTO> DTO execute(String alias) throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_REMOVE_ALIAS), new ServiceParameter("alias", alias));
        }
    }

    private class AddAliasRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected AddAliasRequest() {
            super(ApplicationResource.LINK_ADD_ALIAS);
        }

        public <DTO> DTO execute(String alias) throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_ADD_ALIAS), new ServiceParameter("alias", alias));
        }
    }

    private class ScaleDownRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ScaleDownRequest() {
            super(ApplicationResource.LINK_SCALE_DOWN);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_SCALE_DOWN));
        }
    }

    private class ScaleUpRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ScaleUpRequest() {
            super(ApplicationResource.LINK_SCALE_UP);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_SCALE_UP));
        }
    }

    private class ShowPortRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ShowPortRequest() {
            super(ApplicationResource.LINK_SHOW_PORT);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_SHOW_PORT));
        }
    }

    private class ConcealPortRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ConcealPortRequest() {
            super(ApplicationResource.LINK_CONCEAL_PORT);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_CONCEAL_PORT));
        }
    }

    private class ExposePortRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ExposePortRequest() {
            super(ApplicationResource.LINK_EXPOSE_PORT);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_EXPOSE_PORT));
        }
    }

    private class RestartApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected RestartApplicationRequest() {
            super(ApplicationResource.LINK_RESTART_APPLICATION);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_RESTART));
        }
    }

    private class ForceStopApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected ForceStopApplicationRequest() {
            super(ApplicationResource.LINK_FORCE_STOP_APPLICATION);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_FORCESTOP));
        }
    }

    private class StopApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected StopApplicationRequest() {
            super(ApplicationResource.LINK_STOP_APPLICATION);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_STOP));
        }
    }

    private class StartApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected StartApplicationRequest() {
            super(ApplicationResource.LINK_START_APPLICATION);
        }

        public <DTO> DTO execute() throws OpenShiftException {
            return super.execute(new ServiceParameter("event", IOpenShiftJsonConstants.VALUE_START));
        }
    }

    private class DeleteApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected DeleteApplicationRequest() {
            super(ApplicationResource.LINK_DELETE_APPLICATION);
        }
    }

    private class RefreshApplicationRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected RefreshApplicationRequest() {
            super(ApplicationResource.LINK_GET_APPLICATION);
        }
    }

    private static enum EnumSshStream {
        EXT_INPUT,
        INPUT;

    }
}

