/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client;

import com.openshift.client.IApplication;
import com.openshift.client.IEmbeddableCartridge;
import com.openshift.client.IEmbeddedCartridge;
import com.openshift.client.OpenShiftException;
import com.openshift.internal.client.AbstractOpenShiftResource;
import com.openshift.internal.client.ApplicationResource;
import com.openshift.internal.client.CartridgeType;
import com.openshift.internal.client.ServiceParameter;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.Message;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmbeddedCartridgeResource
extends AbstractOpenShiftResource
implements IEmbeddedCartridge {
    private static final Pattern INFO_URL_PATTERN = Pattern.compile("URL: (.+)\\n*");
    protected static final String JENKINS_CLIENT = "jenkins-client";
    protected static final String MYSQL = "mysql";
    protected static final String PHPMYADMIN = "phpmyadmin";
    protected static final String METRICS = "metrics";
    protected static final String POSTGRES = "postgresql";
    protected static final String MONGO = "mongodb";
    protected static final String ROCKMONGO = "rockmongo";
    protected static final String CRON = "cron";
    protected static final String GEN_MMS_AGENT = "10gen-mms-agent";
    private static final String LINK_DELETE_CARTRIDGE = "DELETE";
    private final String name;
    private final CartridgeType type;
    private String url;
    private final ApplicationResource application;

    protected EmbeddedCartridgeResource(String info, CartridgeResourceDTO dto, ApplicationResource application) {
        this(dto.getName(), dto.getType(), info, dto.getLinks(), dto.getCreationLog(), application);
    }

    protected EmbeddedCartridgeResource(String name, CartridgeType type, String info, Map<String, Link> links, List<Message> creationLog, ApplicationResource application) {
        super(application.getService(), links, creationLog);
        this.name = name;
        this.type = type;
        this.url = this.extractUrl(info, creationLog);
        this.application = application;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    protected final CartridgeType getType() {
        return this.type;
    }

    public final IApplication getApplication() {
        return this.application;
    }

    private String extractUrl(String info, List<Message> messages) {
        if (info != null) {
            return this.extractUrl(info);
        }
        return this.extractUrl(messages);
    }

    private String extractUrl(String string) {
        if (string == null) {
            return null;
        }
        Matcher matcher = INFO_URL_PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 1) {
            return null;
        }
        return matcher.group(1);
    }

    private String extractUrl(List<Message> messages) {
        if (messages == null) {
            return null;
        }
        for (Message message : messages) {
            String url = this.extractUrl(message.getText());
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public String getUrl() throws OpenShiftException {
        return this.url;
    }

    @Override
    public void refresh() throws OpenShiftException {
    }

    @Override
    public void destroy() throws OpenShiftException {
        new DeleteCartridgeRequest().execute(new ServiceParameter[0]);
        this.application.removeEmbeddedCartridge(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!IEmbeddableCartridge.class.isAssignableFrom(obj.getClass())) {
            return false;
        }
        IEmbeddableCartridge other = (IEmbeddableCartridge)obj;
        return !(this.name == null ? other.getName() != null : !this.name.equals(other.getName()));
    }

    public String toString() {
        return "EmbeddedCartridgeResource [name=" + this.name + ", url=" + this.url + ", type=" + (Object)((Object)this.type) + ", url=" + this.url + ", application=" + this.application + "]";
    }

    private class DeleteCartridgeRequest
    extends AbstractOpenShiftResource.ServiceRequest {
        protected DeleteCartridgeRequest() {
            super(EmbeddedCartridgeResource.LINK_DELETE_CARTRIDGE);
        }
    }
}

