/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.internal.client.utils.StringUtils;
import java.text.MessageFormat;

public class Message {
    private String text;
    private Severity severity;
    private String parameter;
    private int exitCode;

    public Message(String text, String parameter, String severity, int exitCode) {
        this.text = text;
        this.severity = Severity.safeValueOf(severity);
        this.parameter = parameter;
        this.exitCode = exitCode;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getText() {
        return this.text;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getOperationState());
        if (!StringUtils.isEmpty(this.parameter)) {
            builder.append(" on parameter \"{0}\"");
            if (this.severity != null) {
                builder.append(", sevirty \"{1}\"");
            }
        }
        if (this.exitCode != -1) {
            builder.append(" with exit code \"{2}\"");
        }
        builder.append('.');
        if (!StringUtils.isEmpty(this.text)) {
            builder.append("Reason given: \"{3}\"");
        }
        return MessageFormat.format(builder.toString(), new Object[]{this.parameter, this.severity, this.exitCode, this.text});
    }

    private String getOperationState() {
        switch (this.severity) {
            case ERROR: {
                return "Operation failed";
            }
            case INFO: {
                return "Operation succeeded";
            }
        }
        return "Operation state is unknown";
    }

    public static enum Severity {
        INFO,
        ERROR,
        UNKNOWN;


        private static Severity safeValueOf(String severityString) {
            try {
                if (severityString == null) {
                    return UNKNOWN;
                }
                return Severity.valueOf(severityString.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return UNKNOWN;
            }
        }
    }
}

