/*
 * Decompiled with CFR 0.152.
 */
package com.openshift.internal.client.response;

import com.openshift.client.ApplicationScale;
import com.openshift.client.OpenShiftException;
import com.openshift.client.OpenShiftRequestException;
import com.openshift.internal.client.GearProfile;
import com.openshift.internal.client.response.ApplicationResourceDTO;
import com.openshift.internal.client.response.CartridgeResourceDTO;
import com.openshift.internal.client.response.DomainResourceDTO;
import com.openshift.internal.client.response.EnumDataType;
import com.openshift.internal.client.response.GearComponentDTO;
import com.openshift.internal.client.response.GearResourceDTO;
import com.openshift.internal.client.response.KeyResourceDTO;
import com.openshift.internal.client.response.Link;
import com.openshift.internal.client.response.LinkParameter;
import com.openshift.internal.client.response.Message;
import com.openshift.internal.client.response.RestResponse;
import com.openshift.internal.client.response.UserResourceDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceDTOFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceDTOFactory.class);

    public static RestResponse get(String content) throws OpenShiftException {
        if (content == null || content.length() == 0) {
            return null;
        }
        LOGGER.trace("Unmarshalling response\n{}", (Object)content);
        ModelNode rootNode = ResourceDTOFactory.getModelNode(content);
        String type = rootNode.get("type").asString();
        String status = rootNode.get("status").asString();
        List<Message> messages = ResourceDTOFactory.createMessages(rootNode.get("messages"));
        EnumDataType dataType = EnumDataType.safeValueOf(type);
        if (dataType == null) {
            return new RestResponse(status, messages, null, null);
        }
        switch (dataType) {
            case user: {
                return new RestResponse(status, messages, ResourceDTOFactory.createUser(rootNode), dataType);
            }
            case keys: {
                return new RestResponse(status, messages, ResourceDTOFactory.createKeys(rootNode), dataType);
            }
            case key: {
                return new RestResponse(status, messages, ResourceDTOFactory.createKey(rootNode, messages), dataType);
            }
            case links: {
                return new RestResponse(status, messages, ResourceDTOFactory.createLinks(rootNode), dataType);
            }
            case domains: {
                return new RestResponse(status, messages, ResourceDTOFactory.createDomains(rootNode), dataType);
            }
            case domain: {
                return new RestResponse(status, messages, ResourceDTOFactory.createDomain(rootNode, messages), dataType);
            }
            case applications: {
                return new RestResponse(status, messages, ResourceDTOFactory.createApplications(rootNode), dataType);
            }
            case application: {
                return new RestResponse(status, messages, ResourceDTOFactory.createApplication(rootNode, messages), dataType);
            }
            case gears: {
                return new RestResponse(status, messages, ResourceDTOFactory.createGears(rootNode), dataType);
            }
            case cartridges: {
                return new RestResponse(status, messages, ResourceDTOFactory.createCartridges(rootNode), dataType);
            }
            case cartridge: {
                return new RestResponse(status, messages, ResourceDTOFactory.createCartridge(rootNode, messages), dataType);
            }
        }
        return null;
    }

    private static List<Message> createMessages(ModelNode messagesNode) {
        ArrayList<Message> messages = new ArrayList<Message>();
        if (messagesNode.getType() == ModelType.LIST) {
            for (ModelNode messageNode : messagesNode.asList()) {
                messages.add(ResourceDTOFactory.createMessage(messageNode));
            }
        }
        return messages;
    }

    private static Message createMessage(ModelNode messageNode) {
        String text = ResourceDTOFactory.getString(messageNode.get("text"));
        String parameter = ResourceDTOFactory.getString(messageNode.get("field"));
        int exitCode = ResourceDTOFactory.getInt(messageNode.get("exit_code"));
        String severity = ResourceDTOFactory.getString(messageNode.get("severity"));
        return new Message(text, parameter, severity, exitCode);
    }

    private static int getInt(ModelNode messageNode) {
        if (messageNode == null || !messageNode.isDefined()) {
            return -1;
        }
        return messageNode.asInt();
    }

    private static String getString(ModelNode node) {
        if (node == null || !node.isDefined()) {
            return null;
        }
        return node.asString();
    }

    private static ModelNode getModelNode(String content) throws OpenShiftException {
        if (content == null) {
            throw new OpenShiftException("Could not unmarshall response: no content.", new Object[0]);
        }
        ModelNode node = ModelNode.fromJSONString((String)content);
        if (!node.isDefined()) {
            throw new OpenShiftException("Could not unmarshall response: erroneous content.", new Object[0]);
        }
        return node;
    }

    private static UserResourceDTO createUser(ModelNode userNode) throws OpenShiftException {
        if (userNode.has("data")) {
            return ResourceDTOFactory.createUser(userNode.get("data"));
        }
        String rhlogin = ResourceDTOFactory.getAsString(userNode, "login");
        int maxGears = ResourceDTOFactory.getAsInteger(userNode, "max_gears");
        int consumedGears = ResourceDTOFactory.getAsInteger(userNode, "consumed_gears");
        Map<String, Link> links = ResourceDTOFactory.createLinks(userNode.get("links"));
        return new UserResourceDTO(rhlogin, maxGears, consumedGears, links);
    }

    private static List<KeyResourceDTO> createKeys(ModelNode rootNode) throws OpenShiftException {
        ArrayList<KeyResourceDTO> keys = new ArrayList<KeyResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode dataNode : rootNode.get("data").asList()) {
                if (dataNode.getType() != ModelType.OBJECT) continue;
                keys.add(ResourceDTOFactory.createKey(dataNode, null));
            }
        }
        return keys;
    }

    private static KeyResourceDTO createKey(ModelNode keyNode, List<Message> creationLog) throws OpenShiftException {
        if (keyNode.has("data")) {
            return ResourceDTOFactory.createKey(keyNode.get("data"), creationLog);
        }
        String name = ResourceDTOFactory.getAsString(keyNode, "name");
        String type = ResourceDTOFactory.getAsString(keyNode, "type");
        String content = ResourceDTOFactory.getAsString(keyNode, "content");
        Map<String, Link> links = ResourceDTOFactory.createLinks(keyNode.get("links"));
        return new KeyResourceDTO(name, type, content, links, creationLog);
    }

    private static Map<String, Link> createLinks(ModelNode linksNode) throws OpenShiftException {
        if (linksNode.has("data")) {
            return ResourceDTOFactory.createLinks(linksNode.get("data"));
        }
        HashMap<String, Link> links = new HashMap<String, Link>();
        if (linksNode.isDefined()) {
            for (ModelNode linkNode : linksNode.asList()) {
                String linkName = linkNode.asProperty().getName();
                ModelNode valueNode = linkNode.asProperty().getValue();
                if (!valueNode.isDefined()) continue;
                String rel = valueNode.get("rel").asString();
                String href = valueNode.get("href").asString();
                String method = valueNode.get("method").asString();
                List<LinkParameter> requiredParams = ResourceDTOFactory.createLinkParameters(valueNode.get("required_params"));
                List<LinkParameter> optionalParams = ResourceDTOFactory.createLinkParameters(valueNode.get("optional_params"));
                links.put(linkName, new Link(rel, href, method, requiredParams, optionalParams));
            }
        }
        return links;
    }

    private static List<DomainResourceDTO> createDomains(ModelNode rootNode) throws OpenShiftException {
        ArrayList<DomainResourceDTO> domains = new ArrayList<DomainResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode dataNode : rootNode.get("data").asList()) {
                if (dataNode.getType() == ModelType.OBJECT) {
                    domains.add(ResourceDTOFactory.createDomain(dataNode, null));
                    continue;
                }
                throw new OpenShiftException("Unexpected node type: {0}", dataNode.getType());
            }
        } else {
            ModelNode domainNode = rootNode.get("domain");
            if (domainNode.isDefined() && domainNode.getType() == ModelType.OBJECT) {
                domains.add(ResourceDTOFactory.createDomain(domainNode, null));
            } else {
                throw new OpenShiftException("Unexpected node type: {0}", domainNode.getType());
            }
        }
        return domains;
    }

    private static DomainResourceDTO createDomain(ModelNode domainNode, List<Message> creationLog) throws OpenShiftException {
        if (domainNode.has("data")) {
            return ResourceDTOFactory.createDomain(domainNode.get("data"), creationLog);
        }
        String namespace = ResourceDTOFactory.getAsString(domainNode, "id");
        String suffix = ResourceDTOFactory.getAsString(domainNode, "suffix");
        Map<String, Link> links = ResourceDTOFactory.createLinks(domainNode.get("links"));
        return new DomainResourceDTO(namespace, suffix, links, creationLog);
    }

    private static List<ApplicationResourceDTO> createApplications(ModelNode rootNode) throws OpenShiftException {
        ArrayList<ApplicationResourceDTO> applicationDTOs = new ArrayList<ApplicationResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode applicationNode : rootNode.get("data").asList()) {
                applicationDTOs.add(ResourceDTOFactory.createApplication(applicationNode, null));
            }
        }
        return applicationDTOs;
    }

    private static ApplicationResourceDTO createApplication(ModelNode appNode, List<Message> creationLog) throws OpenShiftException {
        if (appNode.has("data")) {
            return ResourceDTOFactory.createApplication(appNode.get("data"), creationLog);
        }
        String framework = ResourceDTOFactory.getAsString(appNode, "framework");
        String creationTime = ResourceDTOFactory.getAsString(appNode, "creation_time");
        String name = ResourceDTOFactory.getAsString(appNode, "name");
        String uuid = ResourceDTOFactory.getAsString(appNode, "uuid");
        ApplicationScale scalable = ApplicationScale.safeValueOf(ResourceDTOFactory.getAsString(appNode, "scalable"));
        GearProfile gearProfile = ResourceDTOFactory.createGearProfile(appNode);
        String applicationUrl = ResourceDTOFactory.getAsString(appNode, "app_url");
        String gitUrl = ResourceDTOFactory.getAsString(appNode, "git_url");
        String domainId = ResourceDTOFactory.getAsString(appNode, "domain_id");
        String healthCheckPath = ResourceDTOFactory.getAsString(appNode, "health_check_path");
        Map<String, Link> links = ResourceDTOFactory.createLinks(appNode.get("links"));
        List<String> aliases = ResourceDTOFactory.createAliases(appNode.get("aliases"));
        Map<String, String> embeddedCartridgesInfos = ResourceDTOFactory.createEmbeddedCartridgesInfos(appNode.get("embedded"));
        return new ApplicationResourceDTO(framework, domainId, creationTime, name, gearProfile, scalable, uuid, applicationUrl, gitUrl, healthCheckPath, aliases, embeddedCartridgesInfos, links, creationLog);
    }

    private static GearProfile createGearProfile(ModelNode appNode) {
        String gearProfileName = ResourceDTOFactory.getAsString(appNode, "gear_profile");
        if (gearProfileName == null) {
            return null;
        }
        return new GearProfile(gearProfileName);
    }

    private static Map<String, String> createEmbeddedCartridgesInfos(ModelNode embeddedNode) {
        HashMap<String, String> infos = new HashMap<String, String>();
        for (Property embeddedCartridgeProperty : embeddedNode.asPropertyList()) {
            String embeddedCartridgeInfo = ResourceDTOFactory.getEmbeddedCartridgeInfo(embeddedCartridgeProperty.getValue());
            if (embeddedCartridgeInfo == null) continue;
            infos.put(embeddedCartridgeProperty.getName(), embeddedCartridgeInfo);
        }
        return infos;
    }

    private static String getEmbeddedCartridgeInfo(ModelNode embeddedCartridgeNode) {
        if (embeddedCartridgeNode == null || !embeddedCartridgeNode.has("info") || !embeddedCartridgeNode.get("info").isDefined()) {
            return null;
        }
        return embeddedCartridgeNode.get("info").asString();
    }

    private static List<GearResourceDTO> createGears(ModelNode gearsNode) {
        if (gearsNode.has("data")) {
            return ResourceDTOFactory.createGears(gearsNode.get("data"));
        }
        ArrayList<GearResourceDTO> gears = new ArrayList<GearResourceDTO>();
        if (gearsNode.getType() == ModelType.LIST) {
            for (ModelNode childNode : gearsNode.asList()) {
                gears.add(ResourceDTOFactory.createGear(childNode, null));
            }
        }
        return gears;
    }

    private static GearResourceDTO createGear(ModelNode gearNode, List<Message> creationLog) {
        if (gearNode.has("data")) {
            return ResourceDTOFactory.createGear(gearNode.get("data"), creationLog);
        }
        String uuid = ResourceDTOFactory.getAsString(gearNode, "uuid");
        String gitUrl = ResourceDTOFactory.getAsString(gearNode, "git_url");
        List<GearComponentDTO> components = ResourceDTOFactory.createGearComponents(gearNode.get("components"));
        return new GearResourceDTO(uuid, gitUrl, components, creationLog);
    }

    private static List<GearComponentDTO> createGearComponents(ModelNode gearsComponentNode) {
        ArrayList<GearComponentDTO> components = new ArrayList<GearComponentDTO>();
        if (gearsComponentNode.getType() == ModelType.LIST) {
            for (ModelNode componentNode : gearsComponentNode.asList()) {
                String name = ResourceDTOFactory.getAsString(componentNode, "name");
                String internalPort = ResourceDTOFactory.getAsString(componentNode, "internal_port");
                String proxyPort = ResourceDTOFactory.getAsString(componentNode, "proxy_port");
                String proxyHost = ResourceDTOFactory.getAsString(componentNode, "proxy_host");
                components.add(new GearComponentDTO(name, internalPort, proxyHost, proxyPort, null));
            }
        }
        return components;
    }

    private static List<CartridgeResourceDTO> createCartridges(ModelNode rootNode) throws OpenShiftException {
        ArrayList<CartridgeResourceDTO> cartridges = new ArrayList<CartridgeResourceDTO>();
        if (rootNode.has("data")) {
            for (ModelNode cartridgeNode : rootNode.get("data").asList()) {
                cartridges.add(ResourceDTOFactory.createCartridge(cartridgeNode, null));
            }
        }
        return cartridges;
    }

    private static CartridgeResourceDTO createCartridge(ModelNode cartridgeNode, List<Message> creationLog) throws OpenShiftException {
        if (cartridgeNode.has("data")) {
            return ResourceDTOFactory.createCartridge(cartridgeNode.get("data"), creationLog);
        }
        String name = ResourceDTOFactory.getAsString(cartridgeNode, "name");
        String type = ResourceDTOFactory.getAsString(cartridgeNode, "type");
        Map<String, Link> links = ResourceDTOFactory.createLinks(cartridgeNode.get("links"));
        return new CartridgeResourceDTO(name, type, links, creationLog);
    }

    private static List<String> createAliases(ModelNode aliasNodesList) {
        ArrayList<String> aliases = new ArrayList<String>();
        switch (aliasNodesList.getType()) {
            case OBJECT: 
            case LIST: {
                for (ModelNode aliasNode : aliasNodesList.asList()) {
                    aliases.add(aliasNode.asString());
                }
                break;
            }
            default: {
                aliases.add(aliasNodesList.asString());
            }
        }
        return aliases;
    }

    private static List<LinkParameter> createLinkParameters(ModelNode linkParamNodes) throws OpenShiftRequestException {
        ArrayList<LinkParameter> linkParams = new ArrayList<LinkParameter>();
        if (linkParamNodes.isDefined()) {
            for (ModelNode linkParamNode : linkParamNodes.asList()) {
                linkParams.add(ResourceDTOFactory.createLinkParameter(linkParamNode));
            }
        }
        return linkParams;
    }

    private static LinkParameter createLinkParameter(ModelNode linkParamNode) throws OpenShiftRequestException {
        String description = linkParamNode.get("description").asString();
        String type = linkParamNode.get("type").asString();
        String defaultValue = linkParamNode.get("default_value").asString();
        String name = linkParamNode.get("name").asString();
        return new LinkParameter(name, type, defaultValue, description, ResourceDTOFactory.createValidOptions(linkParamNode));
    }

    private static List<String> createValidOptions(ModelNode linkParamNode) {
        ArrayList<String> validOptions = new ArrayList<String>();
        ModelNode validOptionsNode = linkParamNode.get("valid_options");
        if (validOptionsNode.isDefined()) {
            switch (validOptionsNode.getType()) {
                case STRING: {
                    validOptions.add(validOptionsNode.asString());
                    break;
                }
                case LIST: {
                    for (ModelNode validOptionNode : validOptionsNode.asList()) {
                        validOptions.add(validOptionNode.asString());
                    }
                    break;
                }
            }
        }
        return validOptions;
    }

    private static String getAsString(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asString() : null;
    }

    private static Boolean getAsBoolean(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asBoolean() : Boolean.FALSE.booleanValue();
    }

    private static int getAsInteger(ModelNode node, String propertyName) {
        ModelNode propertyNode = node.get(propertyName);
        return propertyNode.isDefined() ? propertyNode.asInt() : 0;
    }
}

