/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.handlers;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectHelper;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.webprj.model.handlers.WebPrjSupport;

public class CreateWebPrjSupport
extends WebPrjSupport {
    protected Throwable exc = null;
    protected WebPrjSupport.Step[] steps = new WebPrjSupport.Step[]{new Step0(), new Step1()};

    protected void reset() {
        super.reset();
    }

    public String getDescription() {
        return StrutsUIMessages.CREATE_WEB_PROJECT;
    }

    public WebPrjSupport.Step getStep(int step) {
        return this.steps[step];
    }

    class Step0
    implements WebPrjSupport.Step {
        Step0() {
        }

        public String[] getActionNames() {
            return new String[]{NEXT, CANCEL};
        }

        public String getMessage() {
            return StrutsUIMessages.ENTER_PROJECTNAME_AND_CONFIGURATIONFILE_VERSION;
        }

        public String getTitle() {
            return StrutsUIMessages.STEP1_PROJECTNAME_AND_VERSION;
        }

        public int prepareStep(XModelObject object) {
            String name = CreateWebPrjSupport.this.p.getProperty("name", "");
            String version = CreateWebPrjSupport.this.p.getProperty("version");
            CreateWebPrjSupport.this.setAttributeValue(0, "name", name);
            if (version != null) {
                CreateWebPrjSupport.this.setAttributeValue(0, "version", version);
            }
            return 0;
        }

        public int doStep(XModelObject object) throws XModelException {
            Properties p2 = CreateWebPrjSupport.this.extractStepData(0);
            String name = p2.getProperty("name");
            String version = p2.getProperty("version");
            CreateWebPrjSupport.this.p.setProperty("name", name);
            CreateWebPrjSupport.this.p.setProperty("version", version);
            return 1;
        }

        public int undoStep(XModelObject object) {
            return -1;
        }
    }

    class Step1
    implements WebPrjSupport.Step {
        private Map<String, String> templates;

        Step1() {
        }

        public String[] getActionNames() {
            return new String[]{BACK, FINISH, CANCEL};
        }

        public String getMessage() {
            return StrutsUIMessages.PROJECT_ROOTFOLDER_AND_SELECT_TEMPLATE;
        }

        public String getTitle() {
            return StrutsUIMessages.STEP2_LOCATION_AND_TEMPLATE;
        }

        public int prepareStep(XModelObject object) {
            XModel model = object.getModel();
            String home = XModelConstants.getHome((XModel)model);
            String templ = String.valueOf(XModelObjectUtil.expand((String)home, (XModel)model, null).replace('\\', '/')) + "/templates";
            this.templates = NewWebProjectHelper.getTemplates((String)CreateWebPrjSupport.this.p.getProperty("version"), (String)templ);
            CreateWebPrjSupport.setConstraint(CreateWebPrjSupport.this.getEntityData()[1], "template", new ArrayList<String>(this.templates.keySet()));
            String location = CreateWebPrjSupport.this.p.getProperty("location");
            String template = CreateWebPrjSupport.this.p.getProperty("template");
            if (location != null) {
                CreateWebPrjSupport.this.setAttributeValue(1, "location", location);
            } else {
                String root;
                XModelObject tomcat = model.getRoot("Options").getChildByPath("tomcat server");
                File webapps = null;
                if (tomcat != null && (root = tomcat.getAttributeValue("root dir")) != null && root.length() > 0) {
                    root = XModelObjectUtil.expand((String)root, (XModel)model, null).replace('\\', '/');
                    webapps = new File(root, "webapps");
                }
                if (webapps == null) {
                    webapps = new File(home, "tomcat/webapps");
                }
                if (webapps.exists() && webapps.isDirectory()) {
                    CreateWebPrjSupport.this.setAttributeValue(1, "location", String.valueOf(webapps.getAbsolutePath()) + File.separator + CreateWebPrjSupport.this.p.getProperty("name"));
                }
            }
            if ((template == null || template.length() == 0) && this.templates.containsKey("Blank")) {
                template = "Blank";
            }
            if (template != null) {
                CreateWebPrjSupport.this.setAttributeValue(1, "template", template);
            }
            return 0;
        }

        public synchronized int doStep(XModelObject object) throws XModelException {
            int i;
            Properties p2 = CreateWebPrjSupport.this.extractStepData(1);
            String location = p2.getProperty("location");
            String template = p2.getProperty("template");
            File webDir = new File(location);
            File[] list = webDir.listFiles();
            if (list != null && list.length > 0 && ((i = object.getModel().getService().showDialog(CreateWebPrjSupport.this.getDescription(), NLS.bind((String)StrutsUIMessages.FOLDER_EXISTS_AND_ISNOT_EMPTY, (Object)location), new String[]{StrutsUIMessages.YES, StrutsUIMessages.NO}, null, 0)) == 1 || i < 0)) {
                return 0;
            }
            CreateWebPrjSupport.this.p.setProperty("location", location);
            CreateWebPrjSupport.this.p.setProperty("template", template);
            CreateWebPrjSupport.this.p.setProperty("templateURL", this.templates.get(template));
            return 1;
        }

        public int undoStep(XModelObject object) {
            return -1;
        }
    }
}

