/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverManager;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;

public class ConnectionProfileUtil {
    public static String getDriverDefinitionId(IConnectionProfile profile) {
        if (profile == null) {
            return null;
        }
        return profile.getBaseProperties().getProperty("org.eclipse.datatools.connectivity.driverDefinitionID");
    }

    public static DriverInstance getDriverDefinition(String connectionProfile) {
        if (connectionProfile == null) {
            return null;
        }
        IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(connectionProfile);
        if (profile == null) {
            return null;
        }
        String driverID = ConnectionProfileUtil.getDriverDefinitionId(profile);
        return DriverManager.getInstance().getDriverInstanceByID(driverID);
    }

    public static String[] getConnectionProfileDriverURL(String connectionProfile) {
        DriverInstance di = ConnectionProfileUtil.getDriverDefinition(connectionProfile);
        if (di == null) {
            return null;
        }
        return di.getJarListAsArray();
    }

    public static String getDriverClass(String connectionProfile) {
        DriverInstance di = ConnectionProfileUtil.getDriverDefinition(connectionProfile);
        String driverClass = di != null ? di.getProperty("org.eclipse.datatools.connectivity.db.driverClass") : "";
        return driverClass;
    }

    public static Properties getHibernateConnectionProperties(IConnectionProfile profile) {
        Properties props = new Properties();
        if (profile != null) {
            String pass;
            Properties cpProperties = profile.getProperties(profile.getProviderId());
            String driverClass = ConnectionProfileUtil.getDriverClass(profile.getName());
            props.setProperty("hibernate.connection.driver_class", driverClass);
            String url = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.URL");
            props.setProperty("hibernate.connection.url", url);
            String user = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.username");
            if (user != null && user.length() > 0) {
                props.setProperty("hibernate.connection.username", user);
            }
            if ((pass = cpProperties.getProperty("org.eclipse.datatools.connectivity.db.password")) != null && pass.length() > 0) {
                props.setProperty("hibernate.connection.password", pass);
            }
        }
        return props;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String autoDetectDialect(Properties properties) {
        if (properties.getProperty("hibernate.dialect") != null) return properties.getProperty("hibernate.dialect");
        String url = properties.getProperty("hibernate.connection.url");
        String user = properties.getProperty("hibernate.connection.username");
        String pass = properties.getProperty("hibernate.connection.password");
        Connection connection = null;
        connection = java.sql.DriverManager.getConnection(url, user, pass);
        Dialect dialect = DialectFactory.buildDialect((Properties)properties, (Connection)connection);
        String string = dialect.toString();
        if (connection == null) return string;
        try {
            connection.close();
            return string;
        }
        catch (SQLException sQLException) {}
        return string;
        catch (SQLException sQLException) {
            try {
                if (connection == null) return null;
            }
            catch (Throwable throwable) {
                if (connection == null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (SQLException sQLException2) {}
                throw throwable;
            }
            try {
                connection.close();
                return null;
            }
            catch (SQLException sQLException3) {}
            return null;
        }
    }
}

