/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.tasks.build;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Mkdir;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.util.JavaEnvUtils;
import org.jboss.ant.tasks.build.BuildTask;
import org.jboss.ant.util.FileUtil;

public class CopyRelease
extends BuildTask {
    private String release;
    private Vector filesets = new Vector();
    private String tofile;
    private String exploded;
    private String requiredJDK;
    private String overwrite;

    public void execute() {
        String version = JavaEnvUtils.getJavaVersion();
        if (version.equalsIgnoreCase(this.getRequiredJDK()) || this.getRequiredJDK().equalsIgnoreCase("default")) {
            String[] files = this.getRelease().split(", ");
            for (int j = 0; j < files.length; ++j) {
                int i;
                File outputDir = new File(files[j]);
                Mkdir mkdir = new Mkdir();
                mkdir.setTaskName("mkdir");
                mkdir.setProject(this.getProject());
                mkdir.setDir(outputDir);
                mkdir.execute();
                if (this.getExploded().equalsIgnoreCase("true")) {
                    Expand expand = new Expand();
                    expand.setTaskName("unzip");
                    expand.setProject(this.getProject());
                    expand.setDest(new File(files[j]));
                    if (this.getOverwrite() != null) {
                        if (this.getOverwrite().equalsIgnoreCase("true")) {
                            expand.setOverwrite(true);
                        } else {
                            expand.setOverwrite(false);
                        }
                    }
                    for (i = 0; i < this.getFilesets().size(); ++i) {
                        expand.addFileset((FileSet)this.getFilesets().elementAt(i));
                    }
                    expand.execute();
                }
                if (!this.getExploded().equalsIgnoreCase("false")) continue;
                Copy copy = new Copy();
                copy.setTaskName("copy");
                copy.setProject(this.getProject());
                if (this.getTofile() != null) {
                    copy.setTofile(FileUtil.resolve(outputDir, this.getTofile()));
                } else {
                    copy.setTodir(outputDir);
                }
                for (i = 0; i < this.getFilesets().size(); ++i) {
                    copy.addFileset((FileSet)this.getFilesets().elementAt(i));
                    FileSet thisset = (FileSet)this.getFilesets().elementAt(i);
                }
                copy.execute();
            }
        }
    }

    public String getRelease() {
        return this.release;
    }

    public void setRelease(String release) {
        this.release = release;
    }

    public Vector getFilesets() {
        return this.filesets;
    }

    public void addFileset(FileSet fileset) {
        this.filesets.add(fileset);
    }

    public String getTofile() {
        return this.tofile;
    }

    public void setTofile(String tofile) {
        this.tofile = tofile;
    }

    public String getExploded() {
        return this.exploded;
    }

    public void setExploded(String exploded) {
        this.exploded = exploded;
    }

    public String getRequiredJDK() {
        return this.requiredJDK;
    }

    public void setRequiredJDK(String requiredJDK) {
        this.requiredJDK = requiredJDK;
    }

    public String getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(String overwrite) {
        this.overwrite = overwrite;
    }
}

