/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.metawidget.config.iface.ResourceResolver;
import org.metawidget.inspector.hibernate.HibernateInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateInspector
extends BaseXmlInspector {
    private static final String HIBERNATE_CONFIGURATION_ELEMENT = "hibernate-configuration";
    private static final String HIBERNATE_MAPPING_ELEMENT = "hibernate-mapping";
    private static final InputStream[] EMPTY_INPUTSTREAM_ARRAY = new InputStream[0];
    private final boolean mHideIds;

    public HibernateInspector(HibernateInspectorConfig config) {
        super(config);
        this.mHideIds = config.isHideIds();
    }

    @Override
    protected String getTopLevelTypeAttribute() {
        return "name";
    }

    @Override
    protected String getTypeAttribute() {
        return "class";
    }

    @Override
    protected String getExtendsAttribute() {
        return "extends";
    }

    @Override
    protected Element getDocumentElement(ResourceResolver resolver, InputStream ... files) throws Exception {
        Document documentMaster = null;
        for (InputStream file : files) {
            Document documentParsed = XmlUtils.parse(file);
            if (!documentParsed.hasChildNodes()) continue;
            Element parsed = documentParsed.getDocumentElement();
            String nodeName = parsed.getNodeName();
            if (HIBERNATE_CONFIGURATION_ELEMENT.equals(nodeName)) {
                Element mapping = XmlUtils.getChildNamed(documentParsed.getDocumentElement(), "session-factory", "mapping");
                ArrayList<InputStream> inputStreamList = CollectionUtils.newArrayList();
                while (mapping != null) {
                    inputStreamList.add(resolver.openResource(mapping.getAttribute("resource")));
                    mapping = XmlUtils.getSiblingNamed(mapping, "mapping");
                }
                parsed = this.getDocumentElement(resolver, inputStreamList.toArray(EMPTY_INPUTSTREAM_ARRAY));
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = parsed.getOwnerDocument();
                    continue;
                }
            } else if (HIBERNATE_MAPPING_ELEMENT.equals(nodeName)) {
                this.preprocessDocument(documentParsed);
                if (documentMaster == null || !documentMaster.hasChildNodes()) {
                    documentMaster = documentParsed;
                    continue;
                }
            } else {
                throw InspectorException.newException("Expected an XML document starting with 'hibernate-configuration' or 'hibernate-mapping', but got '" + nodeName + "'");
            }
            XmlUtils.combineElements(documentMaster.getDocumentElement(), parsed, this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (documentMaster == null) {
            return null;
        }
        return documentMaster.getDocumentElement();
    }

    @Override
    protected void preprocessDocument(Document document) {
        Element root = document.getDocumentElement();
        String packagePrefix = root.getAttribute("package");
        if (packagePrefix != null && !"".equals(packagePrefix)) {
            packagePrefix = packagePrefix + '.';
            String topLevelAttribute = this.getTopLevelTypeAttribute();
            String extendsAttribute = this.getExtendsAttribute();
            Element child = XmlUtils.getFirstChildElement(root);
            while (child != null) {
                String extendsClass;
                String name = child.getAttribute(topLevelAttribute);
                if (name != null && !"".equals(name) && name.indexOf(46) == -1) {
                    child.setAttribute(topLevelAttribute, packagePrefix + name);
                }
                if ((extendsClass = child.getAttribute(extendsAttribute)) != null && !"".equals(extendsClass) && extendsClass.indexOf(46) == -1) {
                    child.setAttribute(extendsAttribute, packagePrefix + extendsClass);
                }
                this.prependPackageToClassAttribute(child, packagePrefix);
                child = XmlUtils.getNextSiblingElement(child);
            }
        }
    }

    @Override
    protected Map<String, String> inspectProperty(Element toInspect) {
        Element withClass;
        String typeAttribute;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        attributes.put("name", toInspect.getAttribute("name"));
        String type = toInspect.getAttribute("type");
        if ("clob".equals(type)) {
            attributes.put("type", String.class.getName());
            attributes.put("large", "true");
        }
        if (toInspect.hasAttribute(typeAttribute = this.getTypeAttribute())) {
            attributes.put("type", toInspect.getAttribute(typeAttribute));
        }
        if ("true".equals(toInspect.getAttribute("not-null"))) {
            attributes.put("required", "true");
        }
        if (toInspect.hasAttribute("length")) {
            attributes.put("maximum-length", toInspect.getAttribute("length"));
        }
        String nodeName = toInspect.getNodeName();
        if (this.mHideIds && "id".equals(nodeName)) {
            attributes.put("hidden", "true");
        }
        if (("bag".equals(nodeName) || "list".equals(nodeName) || "set".equals(nodeName)) && (withClass = XmlUtils.getChildWithAttribute(toInspect, typeAttribute)) != null) {
            attributes.put("parameterized-type", withClass.getAttribute(typeAttribute));
            if (withClass.hasAttribute("property-ref")) {
                attributes.put("inverse-relationship", withClass.getAttribute("property-ref"));
            }
        }
        if (toInspect.hasAttribute("property-ref")) {
            attributes.put("inverse-relationship", toInspect.getAttribute("property-ref"));
        }
        return attributes;
    }

    private void prependPackageToClassAttribute(Element element, String packagePrefix) {
        NodeList children = element.getChildNodes();
        String typeAttribute = this.getTypeAttribute();
        int length = children.getLength();
        for (int loop = 0; loop < length; ++loop) {
            Node node = children.item(loop);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            String clazz = child.getAttribute(typeAttribute);
            if (clazz != null && !"".equals(clazz) && clazz.indexOf(46) == -1) {
                child.setAttribute(typeAttribute, packagePrefix + clazz);
            }
            this.prependPackageToClassAttribute(child, packagePrefix);
        }
    }
}

