/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jpa.JpaInspectorConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaInspector
extends BaseObjectInspector {
    private final boolean mHideIds;
    private final boolean mHideVersions;
    private final boolean mHideTransients;

    public JpaInspector() {
        this(new JpaInspectorConfig());
    }

    public JpaInspector(JpaInspectorConfig config) {
        super(config);
        this.mHideIds = config.isHideIds();
        this.mHideVersions = config.isHideVersions();
        this.mHideTransients = config.isHideTransients();
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        ManyToOne manyToOne;
        String mappedBy;
        OneToMany oneToMany;
        OneToOne oneToOne;
        Column column;
        HashMap<String, String> attributes = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(Lob.class)) {
            attributes.put("large", "true");
        }
        if ((column = property.getAnnotation(Column.class)) != null) {
            if (!column.nullable()) {
                attributes.put("required", "true");
            }
            if (column.length() != 255) {
                attributes.put("maximum-length", String.valueOf(column.length()));
            }
        }
        if ((oneToOne = property.getAnnotation(OneToOne.class)) != null) {
            String mappedBy2;
            if (!oneToOne.optional()) {
                attributes.put("required", "true");
            }
            if (!"".equals(mappedBy2 = oneToOne.mappedBy())) {
                attributes.put("inverse-relationship", mappedBy2);
            }
        }
        if ((oneToMany = property.getAnnotation(OneToMany.class)) != null && !"".equals(mappedBy = oneToMany.mappedBy())) {
            attributes.put("inverse-relationship", mappedBy);
        }
        if ((manyToOne = property.getAnnotation(ManyToOne.class)) != null && !manyToOne.optional()) {
            attributes.put("required", "true");
        }
        if (this.mHideIds && property.isAnnotationPresent(Id.class)) {
            attributes.put("hidden", "true");
        } else if (this.mHideIds && property.isAnnotationPresent(EmbeddedId.class)) {
            attributes.put("hidden", "true");
        } else if (this.mHideVersions && property.isAnnotationPresent(Version.class)) {
            attributes.put("hidden", "true");
        } else if (this.mHideTransients && property.isAnnotationPresent(Transient.class)) {
            attributes.put("hidden", "true");
        }
        Temporal temporal = property.getAnnotation(Temporal.class);
        if (temporal != null) {
            switch (temporal.value()) {
                case DATE: {
                    attributes.put("datetime-type", "date");
                    break;
                }
                case TIME: {
                    attributes.put("datetime-type", "time");
                    break;
                }
                case TIMESTAMP: {
                    attributes.put("datetime-type", "both");
                }
            }
        }
        return attributes;
    }
}

