/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util.simple;

public class PathUtils {
    static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static TypeAndNames parsePath(String path) {
        return new TypeAndNames(path, '/');
    }

    public static TypeAndNames parsePath(String path, char separator) {
        return new TypeAndNames(path, separator);
    }

    private PathUtils() {
    }

    public static class TypeAndNames {
        private String mPath;
        private char mSeparator;
        private String mParsedType;
        private String mParsedNames;
        private String[] mParsedNamesAsArray;

        public TypeAndNames(String path, char separator) {
            this.mPath = path.trim();
            this.mSeparator = separator;
        }

        public String getType() {
            if (this.mParsedType == null) {
                int indexOfTypeEnd = this.mPath.indexOf(this.mSeparator);
                if (indexOfTypeEnd == -1) {
                    this.mParsedType = this.mPath;
                    this.mParsedNames = "";
                } else {
                    this.mParsedType = this.mPath.substring(0, indexOfTypeEnd);
                    this.mParsedNames = indexOfTypeEnd == this.mPath.length() - 1 ? "" : this.mPath.substring(indexOfTypeEnd + 1);
                }
            }
            return this.mParsedType;
        }

        public String getNames() {
            if (this.mParsedNames == null) {
                this.getType();
            }
            return this.mParsedNames;
        }

        public String[] getNamesAsArray() {
            if (this.mParsedNamesAsArray == null) {
                String names = this.getNames();
                this.mParsedNamesAsArray = "".equals(names) ? EMPTY_STRING_ARRAY : this.getNames().split("\\" + this.mSeparator);
            }
            return this.mParsedNamesAsArray;
        }
    }
}

