/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.buffers;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.forge.shell.console.jline.Terminal;
import org.jboss.forge.shell.integration.BufferManager;

public class JLineScreenBuffer
implements BufferManager {
    private OutputStream outputStream;
    private Terminal terminal;
    private boolean directWrite = true;
    private int maxBufferSize = 10240;
    private ByteBuffer buffer;
    private int bufferSize = 0;

    public JLineScreenBuffer(Terminal terminal, OutputStream outputStream) {
        this.terminal = terminal;
        this.outputStream = outputStream;
        this.buffer = ByteBuffer.allocateDirect(this.maxBufferSize);
    }

    public void bufferOnlyMode() {
        this.directWrite = false;
    }

    public synchronized void directWriteMode() {
        this.directWrite = true;
        this.flushBuffer();
    }

    public synchronized void flushBuffer() {
        try {
            byte[] buf = new byte[2048];
            this.buffer.rewind();
            do {
                int i;
                for (i = 0; i < buf.length && this.bufferSize > 0; ++i) {
                    buf[i] = this.buffer.get();
                    --this.bufferSize;
                }
                this.outputStream.write(buf, 0, i);
            } while (this.bufferSize > 0);
            this.bufferSize = 0;
            this.buffer.clear();
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("could not flush", e);
        }
    }

    public synchronized void write(int b) {
        if (this.bufferSize + 1 >= this.maxBufferSize) {
            this.flushBuffer();
        }
        this.buffer.put((byte)b);
        ++this.bufferSize;
        this._flush();
    }

    public synchronized void write(byte b) {
        if (this.bufferSize + 1 >= this.maxBufferSize) {
            this.flushBuffer();
        }
        this.buffer.put(b);
        ++this.bufferSize;
        this._flush();
    }

    public synchronized void write(byte[] b) {
        if (this.bufferSize + b.length >= this.maxBufferSize) {
            this.flushBuffer();
            this.write(b);
        }
        this.buffer.put(b, 0, b.length);
        this.bufferSize += b.length;
        this._flush();
    }

    public synchronized void write(byte[] b, int offset, int length) {
        if (this.bufferSize + length >= this.maxBufferSize) {
            this.flushBuffer();
            this.write(b, offset, length);
        }
        this.buffer.put(b, offset, length);
        this.bufferSize += length;
        this._flush();
    }

    public synchronized void write(String s) {
        if (this.bufferSize + s.length() >= this.maxBufferSize) {
            this.flushBuffer();
            this.write(s);
        }
        this.buffer.put(s.getBytes());
        this.bufferSize += s.length();
        this._flush();
    }

    private void segmentedWrite(byte[] b, int offset, int length) {
        if (b.length > this.maxBufferSize) {
            int segs = b.length / this.maxBufferSize;
            int tail = b.length % this.maxBufferSize;
            for (int i = 0; i < segs; ++i) {
                this.write(b, (i + offset) * this.maxBufferSize, this.maxBufferSize);
            }
            this.write(b, (segs + 1) * this.maxBufferSize, tail);
        } else {
            this.write(b, offset, length);
        }
    }

    private void _flush() {
        if (this.directWrite) {
            this.flushBuffer();
        }
    }

    public void directWrite(String s) {
        try {
            this.outputStream.write(s.getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("could not write", e);
        }
    }

    public void setBufferPosition(int row, int col) {
    }

    public int getHeight() {
        return this.terminal.getHeight();
    }

    public int getWidth() {
        return this.terminal.getWidth();
    }
}

