/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.console.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.jboss.forge.shell.console.jline.TerminalSupport;
import org.jboss.forge.shell.console.jline.console.Key;
import org.jboss.forge.shell.console.jline.internal.Configuration;
import org.jboss.forge.shell.console.jline.internal.Log;
import org.jboss.forge.shell.console.jline.internal.ReplayPrefixOneCharInputStream;
import org.jboss.forge.shell.console.jline.internal.TerminalLineSettings;

public class UnixTerminal
extends TerminalSupport {
    private final TerminalLineSettings settings = new TerminalLineSettings();
    private final ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(Configuration.getInputEncoding());
    private final InputStreamReader replayReader = new InputStreamReader((InputStream)this.replayStream, this.replayStream.getEncoding());

    public UnixTerminal() throws Exception {
        super(true);
    }

    protected TerminalLineSettings getSettings() {
        return this.settings;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.setAnsiSupported(true);
        this.settings.set("-icanon min 1");
        this.setEchoEnabled(false);
    }

    @Override
    public void restore() throws Exception {
        this.settings.restore();
        super.restore();
        System.out.println();
    }

    @Override
    public int getWidth() {
        int w = this.settings.getProperty("columns");
        return w < 1 ? 80 : w;
    }

    @Override
    public int getHeight() {
        int h = this.settings.getProperty("rows");
        return h < 1 ? 24 : h;
    }

    @Override
    public synchronized void setEchoEnabled(boolean enabled) {
        try {
            if (enabled) {
                this.settings.set("echo");
            } else {
                this.settings.set("-echo");
            }
            super.setEchoEnabled(enabled);
        }
        catch (Exception e) {
            Log.error("Failed to ", enabled ? "enable" : "disable", " echo: ", e);
        }
    }

    @Override
    public int readVirtualKey(InputStream in) throws IOException {
        UnixKey key;
        int c = this.readCharacter(in);
        if (Key.valueOf(c) == Key.DELETE && this.settings.getProperty("erase") == Key.DELETE.code) {
            c = Key.BACKSPACE.code;
        }
        if ((key = UnixKey.valueOf(c)) == UnixKey.ARROW_START) {
            while (key == UnixKey.ARROW_START) {
                c = this.readCharacter(in);
                key = UnixKey.valueOf(c);
            }
            if (key == UnixKey.ARROW_PREFIX || key == UnixKey.O_PREFIX) {
                c = this.readCharacter(in);
                key = UnixKey.valueOf(c);
                if (key == UnixKey.ARROW_UP) {
                    return Key.CTRL_P.code;
                }
                if (key == UnixKey.ARROW_DOWN) {
                    return Key.CTRL_N.code;
                }
                if (key == UnixKey.ARROW_LEFT) {
                    return Key.CTRL_B.code;
                }
                if (key == UnixKey.ARROW_RIGHT) {
                    return Key.CTRL_F.code;
                }
                if (key == UnixKey.HOME_CODE) {
                    return Key.CTRL_A.code;
                }
                if (key == UnixKey.END_CODE) {
                    return Key.CTRL_E.code;
                }
                if (key == UnixKey.DEL_THIRD) {
                    this.readCharacter(in);
                    return Key.DELETE.code;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    public static enum UnixKey {
        ARROW_START(27),
        ARROW_PREFIX(91),
        ARROW_LEFT(68),
        ARROW_RIGHT(67),
        ARROW_UP(65),
        ARROW_DOWN(66),
        O_PREFIX(79),
        HOME_CODE(72),
        END_CODE(70),
        DEL_THIRD(51),
        DEL_SECOND(126);

        public final short code;
        private static final Map<Short, UnixKey> codes;

        private UnixKey(int code) {
            this.code = (short)code;
        }

        public static UnixKey valueOf(int code) {
            return codes.get((short)code);
        }

        static {
            HashMap<Short, UnixKey> map = new HashMap<Short, UnixKey>();
            for (UnixKey key : UnixKey.values()) {
                map.put(key.code, key);
            }
            codes = map;
        }
    }
}

