/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.console.jline.internal;

import java.io.PrintStream;

public final class Log {
    public static final boolean DEBUG = Boolean.getBoolean(Log.class.getName() + ".debug");
    public static final boolean TRACE = Boolean.getBoolean(Log.class.getName() + ".trace");
    private static PrintStream output = System.err;

    public static PrintStream getOutput() {
        return output;
    }

    public static void setOutput(PrintStream out) {
        assert (out != null);
        output = out;
    }

    private static void print(Object message) {
        if (message instanceof Throwable) {
            ((Throwable)message).printStackTrace();
        } else if (message.getClass().isArray()) {
            Object[] array = (Object[])message;
            for (int i = 0; i < array.length; ++i) {
                output.print(array[i]);
                if (i + 1 >= array.length) continue;
                output.print(",");
            }
        } else {
            output.print(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(Level level, Object[] messages) {
        PrintStream printStream = output;
        synchronized (printStream) {
            output.format("[%s] ", new Object[]{level});
            for (Object message : messages) {
                Log.print(message);
            }
            output.println();
            output.flush();
        }
    }

    public static void trace(Object ... messages) {
        if (TRACE) {
            Log.log(Level.TRACE, messages);
        }
    }

    public static void debug(Object ... messages) {
        if (TRACE || DEBUG) {
            Log.log(Level.DEBUG, messages);
        }
    }

    public static void warn(Object ... messages) {
        Log.log(Level.WARN, messages);
    }

    public static void error(Object ... messages) {
        Log.log(Level.ERROR, messages);
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

