/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.Streams;

@Alias(value="cat")
@Topic(value="File & Resources")
@Help(value="Concatenate and print files")
public class ConcatenatePlugin
implements Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@PipeIn InputStream in, @Option(description="path", required=false) Resource<?>[] paths, PipeOut out) throws IOException {
        String lastBuf = null;
        if (in != null) {
            lastBuf = ConcatenatePlugin.writeOutToConsole(in, out);
        }
        if (paths != null) {
            for (Resource<?> res : paths) {
                InputStream is = null;
                try {
                    is = res.getResourceInputStream();
                    if (is == null) continue;
                    lastBuf = ConcatenatePlugin.writeOutToConsole(is, out);
                }
                finally {
                    Streams.closeQuietly((Closeable)is);
                }
            }
        }
        if (lastBuf == null || lastBuf.charAt(lastBuf.length() - 1) != '\n') {
            out.println();
        }
    }

    private static String writeOutToConsole(InputStream istream, PipeOut out) throws IOException {
        int read;
        byte[] buf = new byte[10];
        String s = null;
        while ((read = istream.read(buf)) != -1) {
            s = new String(buf, 0, read);
            out.print(s);
        }
        return s;
    }
}

