/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.NativeSystemCall;
import org.jboss.forge.shell.util.OSUtils;

@Alias(value="edit")
@Topic(value="File & Resources")
@Help(value="Edit files with the default system editor")
public class EditPlugin
implements Plugin {
    @Inject
    public EditPlugin() {
    }

    @DefaultCommand
    public void run(@Option(description="The files to edit", defaultValue=".") Resource<?>[] dirs) throws IOException {
        for (Resource<?> resource : dirs) {
            if (!(resource instanceof FileResource)) continue;
            Desktop dt = Desktop.getDesktop();
            try {
                dt.edit((File)resource.getUnderlyingResourceObject());
            }
            catch (UnsupportedOperationException e) {
                if (OSUtils.isLinux()) {
                    NativeSystemCall.exec((boolean)true, (String)"gedit", (String[])new String[]{resource.getFullyQualifiedName()});
                    continue;
                }
                throw e;
            }
        }
    }
}

