/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.util.List;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="find")
@Topic(value="File & Resources")
@Help(value="Lists all resources recursively from the given resource.")
public class FindPlugin
implements Plugin {
    @DefaultCommand
    public void run(@Option(description="The starting resource to be listed", defaultValue=".") Resource<?> r, PipeOut out) throws IOException {
        this.listResources(out, r);
    }

    private void listResources(PipeOut out, Resource<?> r) {
        List list = r.listResources();
        out.println(r.getFullyQualifiedName());
        if (list != null && !list.isEmpty()) {
            for (Resource resource : list) {
                this.listResources(out, resource);
            }
        }
    }
}

