/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.resources.ResourceFlag;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="fingerprint")
@Topic(value="File & Resources")
@Help(value="calculate a hash for the specified resource")
public class FingerprintPlugin
implements Plugin {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@PipeIn InputStream pipeIn, @Option(name="cipher", help="hash cipher to use (default: 'SHA-256')", defaultValue="SHA-256") String cipher, @Option(description="FILE ...", defaultValue="*") Resource<?>[] resources, PipeOut pipeOut) throws IOException {
        cipher = cipher.toUpperCase().trim();
        String name = null;
        try {
            MessageDigest md = MessageDigest.getInstance(cipher);
            if (pipeIn != null) {
                name = "<pipe>";
                this.fingerprint(pipeIn, md);
            } else if (resources != null) {
                InputStream inputStream = null;
                StringBuilder names = new StringBuilder();
                for (Resource<?> r : resources) {
                    if (r.isFlagSet(ResourceFlag.Node)) continue;
                    names.append(r.getName()).append(" ");
                    try {
                        inputStream = r.getResourceInputStream();
                        this.fingerprint(inputStream, md);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                name = names.toString().trim();
            }
            if (pipeOut.isPiped()) {
                name = "";
            }
            pipeOut.print(name);
            pipeOut.print(" ");
            for (byte b : md.digest()) {
                pipeOut.print(Integer.toHexString(0xFF & b));
            }
            pipeOut.println();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("the hashing algorithm '" + cipher + "' could not be found");
        }
    }

    private void fingerprint(InputStream instream, MessageDigest md) throws IOException {
        byte b;
        while ((b = (byte)instream.read()) != -1) {
            md.update(b);
        }
    }
}

