/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.Ref;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.git.GitUtils;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.CompositeDependencyFilter;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyFilter;
import org.jboss.forge.project.dependencies.DependencyQuery;
import org.jboss.forge.project.dependencies.DependencyQueryBuilder;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.DependencyRepositoryImpl;
import org.jboss.forge.project.dependencies.DependencyResolver;
import org.jboss.forge.project.dependencies.NonSnapshotDependencyFilter;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.resources.DependencyResource;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.InstalledPluginRegistry;
import org.jboss.forge.shell.PluginEntry;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.ShellPrompt;
import org.jboss.forge.shell.Wait;
import org.jboss.forge.shell.events.PluginInstalled;
import org.jboss.forge.shell.events.PluginRemoved;
import org.jboss.forge.shell.events.ReinitializeEnvironment;
import org.jboss.forge.shell.exceptions.Abort;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.IndexPluginNameCompleter;
import org.jboss.forge.shell.plugins.builtin.InstalledPluginCompleter;
import org.jboss.forge.shell.util.Files;
import org.jboss.forge.shell.util.ForgeProxySelector;
import org.jboss.forge.shell.util.PluginRef;
import org.jboss.forge.shell.util.PluginUtil;
import org.jboss.forge.shell.util.ProxySettings;

@Alias(value="forge")
@Topic(value="Shell Environment")
@Help(value="Forge control and writer environment commands. Manage plugins and other forge addons.")
public class ForgePlugin
implements Plugin {
    private static final String MODULE_TEMPLATE_XML = "/org/jboss/forge/modules/module-template.xml";
    private final Event<ReinitializeEnvironment> reinitializeEvent;
    private final Event<PluginInstalled> pluginInstalledEvent;
    private final Event<PluginRemoved> pluginRemovedEvent;
    private final ShellPrintWriter writer;
    private final DependencyResolver resolver;
    private final ForgeEnvironment environment;
    private final ShellPrompt prompt;
    private final Shell shell;
    private final Configuration configuration;
    @Inject
    private Wait wait;

    @Inject
    public ForgePlugin(ForgeEnvironment environment, Event<ReinitializeEnvironment> reinitializeEvent, ShellPrintWriter writer, ShellPrompt prompt, DependencyResolver resolver, Shell shell, Configuration configuration, Event<PluginInstalled> pluginInstalledEvent, Event<PluginRemoved> pluginRemovedEvent) {
        this.environment = environment;
        this.reinitializeEvent = reinitializeEvent;
        this.writer = writer;
        this.prompt = prompt;
        this.shell = shell;
        this.resolver = resolver;
        this.configuration = configuration;
        this.pluginInstalledEvent = pluginInstalledEvent;
        this.pluginRemovedEvent = pluginRemovedEvent;
    }

    @DefaultCommand
    public void about(PipeOut out) {
        out.println("    _____                    ");
        out.println("   |  ___|__  _ __ __ _  ___ ");
        out.println("   | |_ / _ \\| `__/ _` |/ _ \\  " + out.renderColor(ShellColor.YELLOW, "\\\\"));
        out.println("   |  _| (_) | | | (_| |  __/  " + out.renderColor(ShellColor.YELLOW, "//"));
        out.println("   |_|  \\___/|_|  \\__, |\\___| ");
        out.println("                   |___/      ");
        out.println("");
        out.print(ShellColor.ITALIC, "JBoss Forge");
        out.print(", version [ ");
        out.print(ShellColor.BOLD, this.environment.getRuntimeVersion());
        out.print(" ] - JBoss, by ");
        out.print(ShellColor.RED, "Red Hat, Inc.");
        out.println(" [ http://forge.jboss.org ]");
    }

    @Command(value="restart", help="Reload all plugins and default configurations")
    public void restart() throws Exception {
        this.reinitializeEvent.fire((Object)new ReinitializeEnvironment());
    }

    @Command(value="list-plugins", help="List all installed plugin JAR files.")
    public void listInstalled(PipeOut out, String input) {
        List<PluginEntry> plugins = InstalledPluginRegistry.list();
        for (PluginEntry plugin : plugins) {
            if (!Strings.isNullOrEmpty((String)input) && !plugin.toString().contains(input)) continue;
            out.println(plugin.toString());
        }
    }

    @Command(value="find-plugin", help="Searches the configured Forge plugin index for a plugin matching the given search text")
    public void find(@Option(description="search string") String searchString, PipeOut out) throws Exception {
        List<PluginRef> pluginList = PluginUtil.findPlugin(this.shell, this.configuration, searchString);
        if (!pluginList.isEmpty()) {
            out.println();
        }
        for (PluginRef ref : pluginList) {
            out.println(" - " + out.renderColor(ShellColor.BOLD, ref.getName()) + " (" + ref.getArtifact() + ")");
            out.println("\tAuthor: " + ref.getAuthor());
            out.println("\tWebsite: " + ref.getWebsite());
            out.println("\tLocation: " + ref.getLocation());
            out.println("\tTags: " + ref.getTags());
            out.println("\tDescription: " + ref.getDescription());
            out.println();
        }
    }

    @Command(value="remove-plugin", help="Removes a plugin from the current Forge runtime configuration")
    public void removePlugin(@Option(completer=InstalledPluginCompleter.class, description="plugin-name", required=true, help="The fully qualified plugin name e.g: 'org.jboss.forge.plugin:version'") String pluginName, PipeOut out) throws Exception {
        PluginEntry plugin = PluginEntry.fromCoordinates((String)pluginName);
        if (!InstalledPluginRegistry.has(plugin)) {
            throw new RuntimeException("No such installed plugin [" + pluginName + "]");
        }
        PluginEntry installedPlugin = InstalledPluginRegistry.get(plugin);
        InstalledPluginRegistry.remove(installedPlugin);
        this.pluginRemovedEvent.fire((Object)new PluginRemoved(installedPlugin));
        if (!InstalledPluginRegistry.has(plugin)) {
            ShellMessages.success((ShellPrintWriter)out, (String)("Successfully removed [" + pluginName + "]"));
            this.restart();
        } else {
            ShellMessages.error((ShellPrintWriter)out, (String)("Failed to remove [" + pluginName + ""));
        }
    }

    @Command(value="install-plugin", help="Installs a plugin from the configured Forge plugin index")
    public void installFromIndex(@Option(description="plugin-name", completer=IndexPluginNameCompleter.class) String pluginName, @Option(name="version", description="branch, tag, or version to build") String version, PipeOut out) throws Exception {
        PluginRef plugin = PluginUtil.findPluginByName(this.shell, this.configuration, pluginName, true);
        if (plugin == null) {
            throw new RuntimeException("no plugin found with name [" + pluginName + "]");
        }
        ShellMessages.info((ShellPrintWriter)out, (String)("Preparing to install plugin: " + plugin.getName()));
        if (!plugin.isGit()) {
            throw new UnsupportedOperationException("Not yet implemented");
        }
        this.installFromGit(plugin.getGitRepo(), Strings.isNullOrEmpty((String)version) ? plugin.getGitRef() : version, null, out);
    }

    @Command(value="source-plugin", help="Install a plugin from a local project folder")
    public void installFromLocalProject(@Option(description="project directory", required=true) Resource<?> projectFolder, PipeOut out) throws Exception {
        DirectoryResource workspace = (DirectoryResource)projectFolder.reify(DirectoryResource.class);
        if (workspace == null || !workspace.exists()) {
            throw new IllegalArgumentException("Project folder must be specified.");
        }
        this.buildFromCurrentProject(out, workspace);
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + workspace + "] successfully."));
        this.restart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Command(value="git-plugin", help="Install a plugin from a public git repository")
    public void installFromGit(@Option(description="git repo", required=true) String gitRepo, @Option(name="ref", description="branch or tag to build") String refName, @Option(name="checkoutDir", description="directory in which to clone the repository") Resource<?> checkoutDir, PipeOut out) throws Exception {
        DirectoryResource workspace = this.shell.getCurrentDirectory().createTempResource();
        try {
            DirectoryResource buildDir = workspace.getChildDirectory("repo");
            if (checkoutDir != null) {
                if (!checkoutDir.exists() && checkoutDir instanceof FileResource) {
                    ((FileResource)checkoutDir).mkdirs();
                }
                buildDir = (DirectoryResource)checkoutDir.reify(DirectoryResource.class);
            }
            if (buildDir.exists()) {
                buildDir.delete(true);
                buildDir.mkdir();
            }
            this.prepareProxyForJGit();
            ShellMessages.info((ShellPrintWriter)out, (String)("Checking out plugin source files to [" + buildDir.getFullyQualifiedName() + "] via 'git'"));
            Git repo = GitUtils.clone((DirectoryResource)buildDir, (String)gitRepo);
            Ref ref = null;
            String targetRef = refName;
            if (targetRef == null) {
                targetRef = this.environment.getRuntimeVersion();
            }
            if (targetRef != null) {
                String branchName;
                Map tags = repo.getRepository().getTags();
                ref = (Ref)tags.get(targetRef);
                if (ref == null) {
                    List refs = GitUtils.getRemoteBranches((Git)repo);
                    for (Ref branchRef : refs) {
                        branchName = branchRef.getName();
                        if (branchName == null || !branchName.endsWith(targetRef)) continue;
                        ref = repo.branchCreate().setName(targetRef).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + targetRef).call();
                    }
                }
                if (ref == null) {
                    String version;
                    ArrayList<String> sortedVersions = new ArrayList<String>();
                    for (Ref branchRef : GitUtils.getRemoteBranches((Git)repo)) {
                        branchName = branchRef.getName();
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, branchName = branchName.replaceFirst("refs/heads/", ""))) continue;
                        sortedVersions.add(branchName);
                    }
                    for (String tag : tags.keySet()) {
                        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, tag)) continue;
                        sortedVersions.add(tag);
                    }
                    Collections.sort(sortedVersions);
                    if (!sortedVersions.isEmpty() && InstalledPluginRegistry.isApiCompatible((CharSequence)targetRef, version = (String)sortedVersions.get(sortedVersions.size() - 1)) && (ref = (Ref)tags.get(version)) == null) {
                        ref = repo.branchCreate().setName(version).setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.TRACK).setStartPoint("origin/" + version).call();
                    }
                }
            }
            if (ref == null) {
                ref = repo.getRepository().getRef("master");
            }
            if (ref != null) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Switching to branch/tag [" + ref.getName() + "]"));
                GitUtils.checkout((Git)repo, (Ref)ref, (boolean)false, (CreateBranchCommand.SetupUpstreamMode)CreateBranchCommand.SetupUpstreamMode.TRACK, (boolean)false);
            } else {
                if (refName != null) {
                    throw new RuntimeException("Could not locate ref [" + targetRef + "] in repository [" + repo.getRepository().getDirectory().getAbsolutePath() + "]");
                }
                ShellMessages.warn((ShellPrintWriter)out, (String)("Could not find a Ref matching the current Forge version [" + this.environment.getRuntimeVersion() + "], building Plugin from HEAD."));
            }
            this.buildFromCurrentProject(out, buildDir);
        }
        finally {
            if (checkoutDir != null) {
                ShellMessages.info((ShellPrintWriter)out, (String)("Cleaning up temp workspace [" + workspace.getFullyQualifiedName() + "]"));
                workspace.delete(true);
            }
        }
        ShellMessages.success((ShellPrintWriter)out, (String)("Installed from [" + gitRepo + "] successfully."));
        this.restart();
    }

    @Command(value="update-abort", help="Aborts a previous forge update")
    public void updateAbort() throws IOException {
        DirectoryResource forgeHome = this.environment.getForgeHome();
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        if (updateDirectory.exists()) {
            if (updateDirectory.delete(true)) {
                ShellMessages.success((ShellPrintWriter)this.shell, (String)"Update files were deleted. Run 'forge update' if you want to update this installation again.");
            } else {
                ShellMessages.info((ShellPrintWriter)this.shell, (String)"Could not abort. Try to run 'forge update-abort' again");
            }
        } else {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"No update files found");
        }
    }

    @Command(value="update", help="Update this forge installation")
    public void update() throws IOException {
        DirectoryResource forgeHome = this.environment.getForgeHome();
        DirectoryResource updateDir = forgeHome.getChildDirectory(".update");
        if (updateDir.exists()) {
            ShellMessages.warn((ShellPrintWriter)this.shell, (String)"There is an update pending. Restart Forge for the update to take effect. To abort this update, type 'forge update-abort'");
            return;
        }
        Dependency forgeDistribution = this.getLatestAvailableDistribution();
        if (forgeDistribution == null) {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"Forge is up to date! Enjoy!");
        } else {
            this.shell.print(ShellColor.YELLOW, "***INFO*** ");
            this.shell.print("This Forge installation will be updated to ");
            this.shell.println(ShellColor.BOLD, forgeDistribution.getVersion());
            if (this.prompt.promptBoolean("Is that ok ?", true)) {
                this.updateForge(forgeDistribution);
            }
        }
    }

    private Dependency getLatestAvailableDistribution() {
        final String runtimeVersion = this.environment.getRuntimeVersion();
        DependencyQueryBuilder query = DependencyQueryBuilder.create((Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-distribution:::zip")).setFilter((DependencyFilter)new CompositeDependencyFilter(new DependencyFilter[]{new NonSnapshotDependencyFilter(), new DependencyFilter(){

            public boolean accept(Dependency dependency) {
                return dependency.getVersion().compareTo(runtimeVersion) > 0;
            }
        }})).setRepositories(new DependencyRepository[]{new DependencyRepositoryImpl(DependencyFacet.KnownRepository.JBOSS_NEXUS)});
        List versions = this.resolver.resolveVersions((DependencyQuery)query);
        return versions.isEmpty() ? null : (Dependency)versions.get(versions.size() - 1);
    }

    private void updateForge(Dependency dependency) throws IOException {
        this.wait.start("Update in progress. Please wait");
        List resolvedArtifacts = this.resolver.resolveArtifacts(dependency);
        Assert.isTrue((resolvedArtifacts.size() == 1 ? 1 : 0) != 0, (String)"Artifact was not found");
        DependencyResource resource = (DependencyResource)resolvedArtifacts.get(0);
        DirectoryResource forgeHome = this.environment.getForgeHome();
        Files.unzip((File)resource.getUnderlyingResourceObject(), (File)forgeHome.getUnderlyingResourceObject());
        DirectoryResource childDirectory = forgeHome.getChildDirectory(dependency.getArtifactId() + "-" + dependency.getVersion());
        DirectoryResource updateDirectory = forgeHome.getChildDirectory(".update");
        if (updateDirectory.exists()) {
            updateDirectory.delete(true);
        }
        childDirectory.renameTo((FileResource)updateDirectory);
        this.wait.stop();
        ShellMessages.success((ShellPrintWriter)this.shell, (String)"Forge\u00a0will now restart\u00a0to complete the update...");
        System.exit(0);
    }

    private void prepareProxyForJGit() {
        ProxySettings proxySettings = ProxySettings.fromForgeConfiguration(this.configuration);
        if (proxySettings == null) {
            return;
        }
        if (!(ProxySelector.getDefault() instanceof ForgeProxySelector)) {
            ForgeProxySelector selector = new ForgeProxySelector(ProxySelector.getDefault(), proxySettings);
            ProxySelector.setDefault(selector);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildFromCurrentProject(PipeOut out, DirectoryResource buildDir) throws Abort {
        block11: {
            DirectoryResource savedLocation = this.shell.getCurrentDirectory();
            try {
                Dependency managedDependency;
                this.shell.setCurrentResource((Resource)buildDir);
                Project project = this.shell.getCurrentProject();
                if (project == null) {
                    throw new IllegalStateException("Unable to recognise plugin project in [" + buildDir.getFullyQualifiedName() + "]");
                }
                DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
                DependencyBuilder shellApi = DependencyBuilder.create((String)"org.jboss.forge:forge-shell-api");
                String apiVersion = null;
                if (!deps.hasEffectiveDependency((Dependency)shellApi) && !this.prompt.promptBoolean("The project does not appear to be a Forge Plugin Project, install anyway?", false)) {
                    throw new Abort("Installation aborted");
                }
                Dependency directDependency = deps.getDirectDependency((Dependency)shellApi);
                if (directDependency != null && !Strings.isNullOrEmpty((String)directDependency.getVersion())) {
                    apiVersion = directDependency.getVersion();
                }
                if (apiVersion == null && (managedDependency = deps.getManagedDependency((Dependency)shellApi)) != null && !Strings.isNullOrEmpty((String)managedDependency.getVersion())) {
                    apiVersion = managedDependency.getVersion();
                }
                if (apiVersion == null) {
                    Dependency effectiveDependency = deps.getEffectiveDependency((Dependency)shellApi);
                    apiVersion = effectiveDependency != null ? effectiveDependency.getVersion() : this.environment.getRuntimeVersion();
                }
                List<String> groupIds = Arrays.asList("org.jboss.seam.render", "org.jboss.forge");
                List<String> providedDeps = Arrays.asList("forge-javaee-api", "forge-maven-api", "forge-scaffold-api", "forge-shell-api");
                List dependencies = deps.getDependencies();
                for (Dependency dependency : dependencies) {
                    if (groupIds.contains(dependency.getGroupId()) && !ScopeType.PROVIDED.equals((Object)dependency.getScopeTypeEnum()) && !ScopeType.TEST.equals((Object)dependency.getScopeTypeEnum())) {
                        ShellMessages.warn((ShellPrintWriter)out, (String)("Dependency [" + dependency.toCoordinates() + "] was not correctly marked as PROVIDED scope; this has been corrected."));
                        deps.addDirectDependency((Dependency)DependencyBuilder.create((Dependency)dependency).setScopeType(ScopeType.PROVIDED));
                        continue;
                    }
                    if (!dependency.getGroupId().equals("org.jboss.forge") || providedDeps.contains(dependency.getArtifactId()) || ScopeType.TEST.equals((Object)deps.getEffectiveDependency(dependency).getScopeTypeEnum())) continue;
                    ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Plugin has a dependency on internal Forge API [" + dependency + "] - this is not allowed and may cause failures."));
                }
                ShellMessages.info((ShellPrintWriter)out, (String)"Invoking build with underlying build system.");
                Resource artifact = ((PackagingFacet)project.getFacet(PackagingFacet.class)).createBuilder().runTests(false).build();
                if (artifact != null && artifact.exists()) {
                    MetadataFacet meta = (MetadataFacet)project.getFacet(MetadataFacet.class);
                    Dependency dep = meta.getOutputDependency();
                    ShellMessages.info((ShellPrintWriter)out, (String)"Installing plugin artifact.");
                    this.createModule(project, (Dependency)DependencyBuilder.create((Dependency)dep).setVersion(dep.getVersion() + "-" + UUID.randomUUID().toString()), artifact, apiVersion);
                    break block11;
                }
                throw new IllegalStateException("Build artifact [" + artifact + "] is missing and cannot be installed. Please resolve build errors and try again.");
            }
            finally {
                this.shell.setCurrentResource((Resource)savedLocation);
            }
        }
    }

    private boolean needDependenciesAsResourceRoot(Project project) {
        FileResource forgeXml = (FileResource)project.getProjectRoot().getChild("src/main/resources/META-INF/forge.xml");
        if (forgeXml.exists()) {
            try {
                Node node = XMLParser.parse((InputStream)forgeXml.getResourceInputStream());
                return node.getSingle("dependencies-as-resource-root") != null;
            }
            catch (ParserException e) {
                return false;
            }
        }
        return false;
    }

    private DirectoryResource createModule(Project project, Dependency dep, Resource<?> artifact, String apiVersion) {
        boolean dependenciesAsResourceRoot = this.needDependenciesAsResourceRoot(project);
        DirectoryResource moduleDir = this.getOrCreatePluginModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)moduleDir.getChild("module.xml");
        if (moduleXml.exists() && !this.prompt.promptBoolean("An existing installation for version [" + pluginSlot + "] of this plugin was found. Replace it?", true)) {
            throw new RuntimeException("Aborted.");
        }
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName);
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        resources.createChild("resource-root").attribute("path", dep.getArtifactId() + ".jar");
        if (dependenciesAsResourceRoot) {
            this.writeResourceRoots(project, module, moduleDir, resources);
        }
        FileResource jar = (FileResource)moduleDir.getChild(dep.getArtifactId() + ".jar").reify(FileResource.class);
        jar.createNewFile();
        jar.setContents(artifact.getResourceInputStream());
        Node dependencies = module.getSingle("dependencies");
        if (!dependenciesAsResourceRoot) {
            dependencies.createChild("module").attribute("name", pluginName + ".dependencies").attribute("slot", pluginSlot);
        }
        dependencies.createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "org.jboss.seam.render").attribute("services", "import");
        dependencies.createChild("module").attribute("name", "javax.api");
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
        if (!dependenciesAsResourceRoot) {
            this.createDependenciesModule(project, dep);
        }
        this.registerPlugin(pluginName, pluginSlot, apiVersion);
        return moduleDir;
    }

    private List<DependencyResource> getPluginDependencies(Project project, Node module) {
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        ArrayList<DependencyResource> pluginDependencies = new ArrayList<DependencyResource>();
        List effectiveDependenciesInScopes = deps.getEffectiveDependenciesInScopes(new ScopeType[]{ScopeType.COMPILE, ScopeType.RUNTIME});
        for (Dependency d : effectiveDependenciesInScopes) {
            if (d.getPackagingTypeEnum().equals((Object)PackagingType.JAR) && !d.getGroupId().equals("org.jboss.forge")) {
                List<DependencyResource> artifacts = this.resolveArtifacts(project, d);
                pluginDependencies.addAll(artifacts);
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-javaee-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.javaee.api").attribute("services", "import");
                continue;
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-scaffold-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.scaffold.api").attribute("services", "import");
                continue;
            }
            if (DependencyBuilder.areEquivalent((Dependency)d, (Dependency)DependencyBuilder.create((String)"org.jboss.forge:forge-maven-api"))) {
                module.getSingle("dependencies").createChild("module").attribute("name", "org.jboss.forge.maven.api").attribute("services", "import");
                continue;
            }
            if (!d.getGroupId().equals("org.jboss.forge")) continue;
            ShellMessages.error((ShellPrintWriter)this.writer, (String)("Plugin has a dependency on internal Forge API [" + d + "] - this is not allowed and may cause failures."));
        }
        return pluginDependencies;
    }

    private void writeResourceRoots(Project project, Node module, DirectoryResource directory, Node resources) {
        List<DependencyResource> pluginDependencies = this.getPluginDependencies(project, module);
        for (DependencyResource d : pluginDependencies) {
            String name = d.getName();
            Resource child = directory.getChild(name);
            child.delete();
            FileResource depJar = (FileResource)child.reify(FileResource.class);
            depJar.setContents(d.getResourceInputStream());
            resources.createChild("resource-root").attribute("path", name);
        }
    }

    private void createDependenciesModule(Project project, Dependency dep) {
        DirectoryResource dependencyDir = this.getOrCreatePluginDependenciesModuleDirectory(dep);
        String pluginName = dep.getGroupId() + "." + dep.getArtifactId();
        String pluginSlot = dep.getVersion();
        FileResource moduleXml = (FileResource)dependencyDir.getChild("module.xml");
        moduleXml.delete();
        moduleXml.createNewFile();
        Node module = XMLParser.parse((InputStream)this.getClass().getResourceAsStream(MODULE_TEMPLATE_XML));
        module.attribute("name", pluginName + ".dependencies");
        module.attribute("slot", pluginSlot);
        Node resources = module.getSingle("resources");
        Node dependencies = module.getSingle("dependencies");
        dependencies.createChild("module").attribute("name", "javax.api");
        dependencies.createChild("module").attribute("name", "org.jboss.forge.shell.api");
        this.writeResourceRoots(project, module, dependencyDir, resources);
        moduleXml.setContents(XMLParser.toXMLString((Node)module));
    }

    private List<DependencyResource> resolveArtifacts(Project project, Dependency dep) {
        Dependency d = dep;
        List<Object> artifacts = new ArrayList<DependencyResource>();
        DependencyFacet deps = (DependencyFacet)project.getFacet(DependencyFacet.class);
        for (Dependency d2 : deps.getDependencies()) {
            if (!DependencyBuilder.areEquivalent((Dependency)d, (Dependency)d2) || d2.getVersion() == null) continue;
            d = d2;
            break;
        }
        if (artifacts.size() != 1) {
            artifacts = this.resolver.resolveArtifacts(d, deps.getRepositories());
        }
        if (artifacts.size() != 1) {
            ShellMessages.warn((ShellPrintWriter)this.writer, (String)("Could not resolve dependency [" + d.toCoordinates() + "]"));
        }
        return artifacts;
    }

    public void registerPlugin(String pluginName, String pluginSlot, String apiVersion) {
        String runtimeVersion = InstalledPluginRegistry.getRuntimeAPIVersion();
        if (!InstalledPluginRegistry.isApiCompatible((CharSequence)runtimeVersion, apiVersion)) {
            throw new RuntimeException("Could not install plugin [" + pluginName + "] because it references Forge API version [" + apiVersion + "] which may not be compatible with my current version [" + runtimeVersion + "]. Please consider upgrading forge, by typing 'forge update'. Otherwise, try installing an older version of the plugin.");
        }
        PluginEntry entry = InstalledPluginRegistry.install(pluginName, apiVersion, pluginSlot);
        this.pluginInstalledEvent.fire((Object)new PluginInstalled(entry));
    }

    public DirectoryResource getOrCreatePluginModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }

    public DirectoryResource getOrCreatePluginDependenciesModuleDirectory(Dependency dep) {
        DirectoryResource pluginDir = this.environment.getPluginDirectory();
        List<String> groupId = Arrays.asList(dep.getGroupId().split("\\."));
        List<String> artifactId = Arrays.asList(dep.getArtifactId().split("\\."));
        DirectoryResource dir = pluginDir;
        for (String segment : groupId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        for (String segment : artifactId) {
            dir = dir.getOrCreateChildDirectory(segment);
        }
        dir = dir.getOrCreateChildDirectory("dependencies");
        dir = dir.getOrCreateChildDirectory(dep.getVersion());
        return dir;
    }
}

