/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.fusesource.jansi.Ansi;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeIn;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.GeneralUtils;

@Alias(value="more")
@Topic(value="Shell Environment")
public class MorePlugin
implements Plugin {
    private static final String MOREPROMPT = "[SPACE:PageDn U:PageUp ENT:LineDn J:LineUp Q:Quit]  ";
    private static final String SEARCH_FORWARD_PROMPT = "Search-Foward: ";
    private static final String SEARCH_BACKWARDS_PROMPT = "Search-Backwards: ";
    private static final String PATTERN_NOT_FOUND = "-- Pattern not found: ";
    private static final String INVALID_COMMAND = "-- Invalid command: ";
    private static final String ERASE_TO_END = new String(new char[]{'\u001b', '[', 'K'});
    private static final String ERASE_TO_END_AND_CR = new String(new char[]{'\u001b', '[', 'K', '\n'});
    private final Shell shell;
    private String statusBarCache;

    @Inject
    public MorePlugin(Shell shell) {
        this.shell = shell;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DefaultCommand
    public void run(@PipeIn InputStream pipeIn, Resource<?> file, @Option(name="noautoexit", shortName="x", flagOnly=true) boolean noAutoExit, PipeOut pipeOut) throws IOException {
        if (file != null) {
            InputStream fileInstream = null;
            try {
                fileInstream = file.getResourceInputStream();
                this.more(fileInstream, pipeOut, noAutoExit);
            }
            finally {
                if (fileInstream != null) {
                    fileInstream.close();
                }
            }
        } else if (pipeIn != null) {
            this.more(pipeIn, pipeOut, noAutoExit);
        }
    }

    /*
     * Unable to fully structure code
     */
    void more(InputStream stream, PipeOut out, boolean noAutoExit) throws IOException {
        buffer = new byte[2048];
        height = this.shell.getHeight() - 1;
        lCounter = width = this.shell.getWidth();
        y = 0;
        if (noAutoExit) {
            this.shell.clear();
        }
        this.shell.bufferingMode();
        lineBuffer = new LineBuffer(stream, width);
        lastPattern = new StringBuilder();
        block16: while (true) {
            block24: {
                if ((read = lineBuffer.read(buffer)) == -1) break block24;
                i = 0;
                block17: while (true) {
                    if (i >= read) continue block16;
                    if (--lCounter <= -1) {
                        lineBuffer.seenLine();
                        lCounter = width;
                        ++y;
                    }
                    c = buffer[i];
                    block0 : switch (c) {
                        case 13: {
                            break;
                        }
                        case 10: {
                            lineBuffer.seenLine();
                            lCounter = width;
                            if (++y == 1) {
                                this.shell.print(MorePlugin.ERASE_TO_END);
                            }
                        }
                        default: {
                            if (y < height) ** GOTO lbl-1000
                            y = height;
                            height = this.shell.getHeight() - 1;
                            if (this.statusBarCache != null) {
                                this.shell.print(MorePlugin.ERASE_TO_END_AND_CR + this.statusBarCache);
                                this.shell.flush();
                            } else {
                                this.shell.print(MorePlugin.ERASE_TO_END_AND_CR);
                            }
                            switch (this.prompt(lineBuffer, out, lastPattern)) {
                                case -1: {
                                    y = 0;
                                    continue block16;
                                }
                                case -2: {
                                    --y;
                                    break block0;
                                }
                                case -3: {
                                    y = 0;
                                    break block0;
                                }
                                case 0: {
                                    noAutoExit = false;
                                    break block17;
                                }
                                default: lbl-1000:
                                // 2 sources

                                {
                                    this.shell.write(c);
                                }
                            }
                        }
                    }
                    ++i;
                }
            }
            if (noAutoExit) {
                switch (this.prompt(lineBuffer, out, lastPattern)) {
                    case -1: {
                        y = 0;
                        break;
                    }
                    case -2: {
                        --y;
                        break;
                    }
                    case -3: {
                        y = 0;
                        break;
                    }
                    case 0: {
                        noAutoExit = false;
                    }
                }
            }
            if (!noAutoExit) break;
        }
    }

    private int prompt(LineBuffer lineBuffer, PipeOut out, StringBuilder lastPattern) throws IOException {
        boolean backwards = false;
        block10: while (true) {
            String topBottomIndicator = lineBuffer.getCurrentLine() - this.shell.getHeight() + 1 == 0 ? " TOP" : (lineBuffer.atEnd() ? " END" : "");
            String prompt = "[SPACE:PageDn U:PageUp ENT:LineDn J:LineUp Q:Quit]  [line:" + lineBuffer.getCurrentLine() + topBottomIndicator + "]  ";
            String bottomLineReset = new Ansi().cursor(this.shell.getAbsoluteHeight(), 0).toString();
            this.statusBarCache = bottomLineReset + MorePlugin.attr(47, 30) + prompt + GeneralUtils.pad(this.shell.getWidth() - prompt.length()) + MorePlugin.attr(0) + bottomLineReset + MorePlugin.attr(0);
            this.shell.print(this.statusBarCache);
            this.shell.flush();
            int scanCode = this.shell.scan();
            switch (scanCode) {
                case 16: 
                case 69: 
                case 74: 
                case 101: 
                case 106: {
                    lineBuffer.rewindBuffer(this.shell.getHeight() - 1, lineBuffer.getCurrentLine() - 1);
                    lineBuffer.setLineWidth(this.shell.getWidth());
                    return -1;
                }
                case 85: 
                case 117: {
                    lineBuffer.rewindBuffer(this.shell.getHeight() - 1, lineBuffer.getCurrentLine() - this.shell.getHeight());
                    lineBuffer.setLineWidth(this.shell.getWidth());
                    return -1;
                }
                case 10: 
                case 14: 
                case 75: 
                case 89: 
                case 107: 
                case 121: {
                    lineBuffer.setLineWidth(this.shell.getWidth());
                    return -2;
                }
                case 32: {
                    lineBuffer.setLineWidth(this.shell.getWidth());
                    return -3;
                }
                case 81: 
                case 113: {
                    this.shell.clearLine();
                    this.shell.cursorLeft(prompt.length());
                    this.shell.flush();
                    return 0;
                }
                case 63: {
                    backwards = true;
                }
                case 47: {
                    String p;
                    String searched;
                    this.shell.clearLine();
                    this.shell.cursorLeft(prompt.length());
                    String string = prompt = backwards ? SEARCH_BACKWARDS_PROMPT : SEARCH_FORWARD_PROMPT;
                    if (lastPattern != null) {
                        prompt = prompt + "[ENT to repeat search '" + lastPattern + "']: ";
                    }
                    out.print(ShellColor.BOLD, prompt);
                    this.shell.flush();
                    String pattern = this.shell.promptAndSwallowCR().trim();
                    this.shell.clearLine();
                    this.shell.cursorLeft(prompt.length() + pattern.length());
                    prompt = prompt + "Scanning buffer...";
                    out.print(ShellColor.BOLD, prompt);
                    this.shell.flush();
                    if (pattern.equals("") && lastPattern.length() != 0) {
                        p = searched = lineBuffer.toString();
                    } else {
                        if (lastPattern.length() != 0) {
                            lastPattern.delete(0, lastPattern.length() - 1);
                        }
                        lastPattern.append(pattern);
                        p = searched = pattern;
                    }
                    int result = lineBuffer.findPattern(p, backwards);
                    if (result == -1) {
                        this.shell.clearLine();
                        this.shell.cursorLeft(prompt.length());
                        this.shell.print(ShellColor.RED, PATTERN_NOT_FOUND + searched);
                        this.shell.flush();
                        this.shell.scan();
                        this.shell.clearLine();
                        this.shell.cursorLeft(PATTERN_NOT_FOUND.length() + searched.length());
                        this.shell.flush();
                        continue block10;
                    }
                    lineBuffer.rewindBuffer(this.shell.getHeight() - 1, result);
                    this.shell.clear();
                    this.shell.flush();
                    return -1;
                }
                case 65: 
                case 97: {
                    this.shell.print(bottomLineReset);
                    this.shell.print(ShellColor.BOLD, "Less&More for JBoss Forge by Mike Brock. Copyright (c) 2011 Red Hat [Press a Key]");
                    this.shell.flush();
                    this.shell.scan();
                    continue block10;
                }
            }
            this.shell.clearLine();
            this.shell.cursorLeft(prompt.length());
            out.print(ShellColor.RED, INVALID_COMMAND + (char)scanCode);
            this.shell.scan();
            this.shell.clearLine();
            this.shell.cursorLeft(INVALID_COMMAND.length() + 1);
        }
    }

    private static String attr(int ... code) {
        return new String(new char[]{'\u001b', '['}) + MorePlugin._attr(code) + "m";
    }

    private static String _attr(int ... code) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (int c : code) {
            if (!first) {
                b.append(';');
            }
            first = false;
            b.append(c);
        }
        return b.toString();
    }

    private static class LineBuffer
    extends InputStream {
        private final InputStream stream;
        private final StringBuilder curr;
        private final ArrayList<Integer> index;
        private boolean buffered = false;
        private int bufferPos;
        private int bufferLine;
        private int lineWidth;
        private int lineCounter;
        private static final int INDEX_MARK_SIZE = 100;
        private static final int MAX_PREBUFFER = 5120;
        int totalLines = 0;

        private LineBuffer(InputStream stream, int lineWidth) {
            this.stream = stream;
            this.curr = new StringBuilder();
            this.index = new ArrayList();
            this.lineWidth = lineWidth;
            this.lineCounter = lineWidth - 1;
        }

        @Override
        public int read() throws IOException {
            int read;
            if (this.buffered) {
                if (this.bufferPos < this.curr.length()) {
                    return this.curr.charAt(this.bufferPos++);
                }
                int c = this.stream.read();
                if (c == -1) {
                    return -1;
                }
                this.buffered = false;
                return this.read();
            }
            byte[] buffer = new byte[1024];
            int totalBytes = 0;
            while ((read = this.stream.read(buffer)) != -1) {
                for (int i = 0; i < read; ++i) {
                    byte c = buffer[i];
                    if (c == -1) continue;
                    this.curr.append((char)c);
                    if (--this.lineCounter != 0 && c != 10) continue;
                    this.lineCounter = this.lineWidth - 1;
                    this.markLine();
                }
                if ((totalBytes += read) <= 5120) continue;
            }
            this.buffered = true;
            return this.read();
        }

        public void seenLine() {
            ++this.bufferLine;
        }

        public void markLine() {
            if (++this.totalLines % 100 == 0) {
                this.index.add(this.curr.length());
            }
        }

        public int getCurrentLine() {
            return this.bufferLine;
        }

        public void setLineWidth(int lineWidth) {
            this.lineWidth = lineWidth;
        }

        public int findLine(int line) {
            int idxMark = line / 100;
            if (idxMark > this.index.size()) {
                return this.curr.length() - 1;
            }
            int cursor = idxMark == 0 ? 0 : this.index.get(idxMark - 1);
            int currLine = idxMark * 100;
            int lCount = this.lineWidth;
            block4: while (cursor < this.curr.length() && currLine != line) {
                switch (this.curr.charAt(cursor++)) {
                    case '\r': {
                        ++cursor;
                        continue block4;
                    }
                    case '\n': {
                        lCount = this.lineWidth;
                        ++currLine;
                        continue block4;
                    }
                }
                if (--lCount > -1) continue;
                ++currLine;
                lCount = this.lineWidth;
            }
            return cursor;
        }

        public int findPattern(String pattern, boolean backwards) throws IOException {
            int read;
            int startLine;
            Pattern p = Pattern.compile(".*" + pattern + ".*");
            int currentBuffer = this.bufferPos;
            int currentLine = this.bufferLine;
            int cursor = 0;
            if (backwards) {
                this.bufferLine = 0;
                startLine = 0;
                this.bufferPos = 0;
            } else {
                startLine = this.bufferPos = this.findLine(this.bufferLine);
                cursor = this.bufferPos;
            }
            int line = this.bufferLine;
            int lCount = this.lineWidth;
            byte[] buffer = new byte[128];
            while ((read = this.read(buffer)) != -1) {
                for (int i = 0; i < read; ++i) {
                    ++cursor;
                    switch (buffer[i]) {
                        case 13: {
                            ++i;
                        }
                        case 10: {
                            ++line;
                            lCount = this.lineWidth;
                            if (p.matcher(this.curr.subSequence(startLine, cursor - 1)).matches()) {
                                return line;
                            }
                            startLine = cursor;
                        }
                    }
                    if (--lCount > 0) continue;
                    ++line;
                    lCount = this.lineWidth;
                }
            }
            this.bufferPos = currentBuffer;
            this.bufferLine = currentLine;
            return -1;
        }

        public void rewindBuffer(int height, int toLine) {
            int renderFrom = toLine - height;
            if (renderFrom < 0) {
                this.bufferLine = 0;
                this.bufferPos = 0;
            } else {
                this.bufferPos = this.findLine(renderFrom);
                this.bufferLine = renderFrom;
            }
        }

        public boolean atEnd() {
            return this.bufferLine >= this.totalLines;
        }
    }
}

