/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresResource;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.PathspecParser;

@Alias(value="mv")
@Topic(value="File & Resources")
@RequiresResource(value={DirectoryResource.class})
@Help(value="Renames a file or directory")
public class MovePlugin
implements Plugin {
    @Inject
    @Current
    Resource<?> directory;
    private final ResourceFactory resourceFactory;

    @Inject
    public MovePlugin(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    @DefaultCommand
    public void rename(@Option(description="source", required=true) Resource<?> source, @Option(description="target", required=true) String target, @Option(name="force", shortName="f", description="force operation", flagOnly=true) boolean force, PipeOut out) {
        Resource<?> directory = this.directory;
        this.rename(source, directory, target, force, out);
    }

    private void rename(Resource<?> source, Resource<?> directory, String target, boolean force, PipeOut out) {
        List results = new PathspecParser(this.resourceFactory, directory, target).resolve();
        if (results.size() > 1) {
            throw new RuntimeException("ambiguous target file name: " + target);
        }
        Resource targetResource = (Resource)results.get(0);
        if (targetResource.exists()) {
            if (this.isDirectory(targetResource)) {
                targetResource = targetResource.getChild(source.getName());
            } else if (force && this.isFile(targetResource)) {
                ((FileResource)targetResource).delete(false);
            } else {
                throw new RuntimeException("destination file exists: " + targetResource.getFullyQualifiedName());
            }
        }
        ((FileResource)source).renameTo(targetResource.getFullyQualifiedName());
    }

    private boolean isFile(Resource<?> source) {
        return source instanceof FileResource;
    }

    private boolean isDirectory(Resource<?> source) {
        return source instanceof DirectoryResource;
    }
}

