/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.events.PickupResource;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.util.PathspecParser;

@Alias(value="pick-up")
@Topic(value="File & Resources")
@Help(value="Picks up a specific resource to work with.")
@Singleton
public class PickupResourcePlugin
implements Plugin {
    private final Shell shell;
    private final ResourceFactory resourceFactory;

    @Inject
    public PickupResourcePlugin(Shell shell, ResourceFactory factory) {
        this.shell = shell;
        this.resourceFactory = factory;
    }

    void pickup(@Observes PickupResource event) {
        this.run(event.getResource(), null);
    }

    @DefaultCommand
    public void run(@Option(required=false) Resource<?> resource, @Option(required=false, name="find", shortName="f") String path) {
        if (path != null) {
            PathspecParser pathspecParser = new PathspecParser(this.resourceFactory, this.shell.getCurrentResource(), path);
            List targets = pathspecParser.search();
            if (targets.isEmpty()) {
                this.shell.println("No such resource");
            } else {
                if (targets.size() > 1) {
                    this.shell.println("Multiple targets");
                    this.shell.println("----------------");
                    int offset = this.shell.getCurrentResource().getFullyQualifiedName().length();
                    for (Resource r : targets) {
                        this.shell.println(" --> ." + r.getFullyQualifiedName().substring(offset));
                    }
                    return;
                }
                resource = (Resource)targets.get(0);
            }
        }
        this.shell.setCurrentResource(resource);
        if (this.shell.getCurrentResource() == null) {
            this.shell.println("No such resource: " + resource);
            return;
        }
        this.shell.println("Picked up type <" + this.shell.getCurrentResource().getClass().getSimpleName() + ">: " + resource);
    }
}

