/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.completer.EnvironmentPropertiesCompleter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.Echo;

@Alias(value="set")
@Topic(value="Shell Environment")
@Help(value="Sets and lists environment variables")
public class SetPlugin
implements Plugin {
    private final ForgeEnvironment forge;
    private final ShellPrintWriter writer;

    @Inject
    public SetPlugin(ForgeEnvironment forge, ShellPrintWriter writer) {
        this.forge = forge;
        this.writer = writer;
    }

    @DefaultCommand
    public void run(@Option(description="varname", completer=EnvironmentPropertiesCompleter.class) String variable, String ... value) {
        if (variable == null) {
            this.listVars();
        } else {
            this.forge.setProperty(variable, (Object)Echo.tokensToString(value));
        }
    }

    private void listVars() {
        for (Map.Entry entry : this.forge.getProperties().entrySet()) {
            this.writer.println((String)entry.getKey() + "=" + entry.getValue());
        }
    }
}

