/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.FacetActionAborted;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.events.FacetInstalled;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.project.packaging.PackagingType;
import org.jboss.forge.project.services.FacetFactory;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.exceptions.Abort;
import org.jboss.forge.shell.util.ConstraintInspector;

public class FacetInstallationHandler {
    @Inject
    private FacetFactory factory;
    @Inject
    private Shell shell;
    @Inject
    private Project project;
    @Inject
    private BeanManager manager;

    public void installRequest(@Observes InstallFacets request) {
        ArrayList<Facet> installed = new ArrayList<Facet>();
        this.shell.printlnVerbose("Received Facet installation request " + request.getFacetTypes());
        if (!request.promptRequested() || this.shell.promptBoolean("An action has requested to install the following facets into your project " + request.getFacetTypes() + " continue?", true)) {
            for (Class type : request.getFacetTypes()) {
                Facet facet = this.factory.getFacet(type);
                if (!this.project.hasFacet(type)) {
                    this.install(facet, false);
                    installed.add(facet);
                    continue;
                }
                this.shell.printlnVerbose("Facet type already installed [" + type + "]");
            }
        } else if (request.promptRequested()) {
            throw new FacetActionAborted("Facet installation aborted.");
        }
        for (Facet facet : installed) {
            this.manager.fireEvent((Object)new FacetInstalled(facet), new Annotation[0]);
        }
    }

    private void install(Facet facet, boolean prompt) {
        if (!this.performInstallation(facet, prompt)) {
            ShellMessages.error((ShellPrintWriter)this.shell, (String)("Failed to install [" + ConstraintInspector.getName(facet.getClass()) + "]; there may be a mess!"));
        }
    }

    private boolean performInstallation(Facet facet, boolean prompt) {
        if (this.project.hasFacet(facet.getClass())) {
            return true;
        }
        facet.setProject(this.project);
        try {
            this.installDependencies(facet, prompt);
            PackagingType type = this.updatePackaging(facet);
            if (!this.project.hasFacet(facet.getClass())) {
                this.project.installFacet(facet);
            }
            if (type != null) {
                ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).setPackagingType(type);
            }
            if (facet.isInstalled()) {
                ShellMessages.success((ShellPrintWriter)this.shell, (String)("Installed [" + ConstraintInspector.getName(facet.getClass()) + "] successfully."));
                return true;
            }
        }
        catch (Abort e) {
            this.abort();
        }
        return false;
    }

    private void installDependencies(Facet facet, boolean prompt) throws Abort {
        List deps = ConstraintInspector.getFacetDependencies(facet.getClass());
        if (!this.project.hasAllFacets((Collection)deps)) {
            ArrayList<Class> missingDeps = new ArrayList<Class>();
            ArrayList<String> facetNames = new ArrayList<String>();
            for (Class f : deps) {
                if (this.project.hasFacet(f)) continue;
                facetNames.add(ConstraintInspector.getName((Class)f));
                missingDeps.add(f);
            }
            if (prompt && !this.shell.promptBoolean("The [" + ConstraintInspector.getName(facet.getClass()) + "] facet depends on the following missing facet(s): " + facetNames + ". Install as well?")) {
                throw new Abort();
            }
            ArrayList<Facet> installed = new ArrayList<Facet>();
            for (Class d : missingDeps) {
                Facet instance = this.factory.getFacet(d);
                if (this.performInstallation(instance, prompt)) {
                    installed.add(instance);
                    continue;
                }
                for (Facet f : installed) {
                    if (!f.uninstall()) {
                        ShellMessages.info((ShellPrintWriter)this.shell, (String)("Could not uninstall [" + ConstraintInspector.getName(f.getClass()) + "]. Must be cleaned up manually."));
                        continue;
                    }
                    ShellMessages.info((ShellPrintWriter)this.shell, (String)("Uninstalled facet [" + ConstraintInspector.getName(f.getClass()) + "]."));
                }
                throw new Abort();
            }
        }
    }

    private PackagingType updatePackaging(Facet facet) throws Abort {
        List types = ConstraintInspector.getCompatiblePackagingTypes(facet.getClass());
        String facetName = ConstraintInspector.getName(facet.getClass());
        PackagingType packaging = ((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType();
        if (types.isEmpty() || types.contains(packaging)) {
            return null;
        }
        if (this.shell.promptBoolean("Facet [" + facetName + "] requires packaging type(s) " + types + ", but is currently [" + packaging + "]. Update packaging? (Note: this could deactivate other plugins in your project.)")) {
            if (types.size() == 1) {
                return (PackagingType)types.get(0);
            }
            return (PackagingType)this.shell.promptChoiceTyped("Select a new packaging type:", types);
        }
        throw new Abort();
    }

    private void abort() {
        ShellMessages.info((ShellPrintWriter)this.shell, (String)"Installation cancelled!");
    }
}

