/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.tracking;

import com.dmurph.tracking.AnalyticsConfigData;
import com.dmurph.tracking.JGoogleAnalyticsTracker;
import java.io.Closeable;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.env.Configuration;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.events.PostStartup;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.Streams;
import org.jboss.forge.tracking.LinuxSystem;

@Alias(value="analytics")
public class GoogleAnalyticsPlugin
implements Plugin {
    private static final String ANALYTICS_ENABLED = "forge.analytics.enabled";
    private static final String ANALYTICS_LAST_RUN = "forge.analytics.lastrun";
    private static final String ANALYTICS_DATE_MASK = "yyyyMMdd";
    public static final String VALUE_NO_REFERRAL = "0";
    @Inject
    private Configuration configuration;
    @Inject
    private Shell shell;
    @Inject
    private ForgeEnvironment environment;
    private JGoogleAnalyticsTracker analyticsTracker;
    private static final String FORGE_GOOGLE_ANALYTICS_KEY = System.getProperty("forge.google_analytics.key", "UA-34467975-2");

    public void onStartup(@Observes PostStartup startup) {
        Boolean enabled = this.configuration.getBoolean(ANALYTICS_ENABLED, null);
        if (enabled == null) {
            enabled = Boolean.getBoolean("forge.analytics.no_prompt") ? Boolean.FALSE : Boolean.valueOf(this.shell.promptBoolean("Will you allow the Forge team to receive anonymous usage statistics for this instance of JBoss Forge?", false));
            this.configuration.setProperty(ANALYTICS_ENABLED, (Object)enabled);
        }
        this.setEnabled(enabled);
        if (enabled.booleanValue() && this.isAllowedToRun()) {
            this.sendInfoToAnalytics();
        }
    }

    boolean isAllowedToRun() {
        boolean ret = true;
        String lastRunDate = this.configuration.getString(ANALYTICS_LAST_RUN, null);
        if (lastRunDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(ANALYTICS_DATE_MASK);
            String now = sdf.format(new Date());
            ret = !now.equals(lastRunDate);
        }
        return ret;
    }

    @DefaultCommand
    public void setEnabled(@Option(name="enabled", required=true) Boolean enabled) {
        this.configuration.setProperty(ANALYTICS_ENABLED, (Object)enabled);
        this.getAnalyticsTracker().setEnabled(enabled.booleanValue());
    }

    boolean isEnabled() {
        return this.configuration.getBoolean(ANALYTICS_ENABLED, Boolean.FALSE);
    }

    @Command(value="info")
    public void displayInfo() {
        this.shell.print("Analytics is: ");
        this.shell.println(ShellColor.BOLD, this.isEnabled() ? "enabled" : "disabled");
        Date lastRunDate = this.getLastRunDate();
        if (lastRunDate != null) {
            DateFormat dateInstance = DateFormat.getDateInstance(1);
            this.shell.print("Analytics was last run at: ");
            this.shell.println(ShellColor.BOLD, dateInstance.format(lastRunDate));
        }
        this.shell.print("Forge Version: ");
        this.shell.println(ShellColor.BOLD, this.getForgeVersion());
        this.shell.print("Operating System: ");
        this.shell.println(ShellColor.BOLD, this.getOS());
        this.shell.print("Java Version: ");
        this.shell.println(ShellColor.BOLD, this.getJavaVersion());
        this.shell.print("Installed Plugins: ");
        this.shell.println(ShellColor.BOLD, this.getInstalledPlugins().toString());
    }

    private Date getLastRunDate() {
        Date date = null;
        String lastRunDate = this.configuration.getString(ANALYTICS_LAST_RUN, null);
        if (lastRunDate != null) {
            SimpleDateFormat sdf = new SimpleDateFormat(ANALYTICS_DATE_MASK);
            try {
                return sdf.parse(lastRunDate);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return date;
    }

    private void setLastRunDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(ANALYTICS_DATE_MASK);
        this.configuration.setProperty(ANALYTICS_LAST_RUN, (Object)sdf.format(date));
    }

    private JGoogleAnalyticsTracker getAnalyticsTracker() {
        if (this.analyticsTracker == null) {
            AnalyticsConfigData config = new AnalyticsConfigData(FORGE_GOOGLE_ANALYTICS_KEY);
            config.setFlashVersion(this.getJavaVersion());
            this.analyticsTracker = new JGoogleAnalyticsTracker(config, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        }
        return this.analyticsTracker;
    }

    private void sendInfoToAnalytics() {
        this.getAnalyticsTracker().trackPageView(this.getOS(), this.getForgeVersion(), "");
        for (String plugin : this.getInstalledPlugins()) {
            this.getAnalyticsTracker().trackEvent("plugin", plugin);
        }
        this.setLastRunDate(new Date());
    }

    private String getOS() {
        if (OSUtils.isLinux()) {
            return LinuxSystem.INSTANCE.getDistroNameAndVersion();
        }
        return OSUtils.getOsName();
    }

    private String getForgeVersion() {
        return this.environment.getRuntimeVersion();
    }

    private String getJavaVersion() {
        return System.getProperty("java.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getInstalledPlugins() {
        ArrayList<String> plugins = new ArrayList<String>();
        Resource registry = this.environment.getPluginDirectory().getChild("installed.xml");
        InputStream is = null;
        if (registry.exists()) {
            try {
                is = registry.getResourceInputStream();
                for (Node plugin : XMLParser.parse((InputStream)is).get("plugin")) {
                    plugins.add(plugin.getAttribute("name"));
                }
            }
            finally {
                Streams.closeQuietly((Closeable)is);
            }
        }
        return plugins;
    }
}

