/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.plugins;

import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.maven.plugins.Configuration;
import org.jboss.forge.maven.plugins.ConfigurationBuilder;
import org.jboss.forge.maven.plugins.Execution;
import org.jboss.forge.maven.plugins.MavenPlugin;
import org.jboss.forge.project.dependencies.Dependency;

public class MavenPluginImpl
implements MavenPlugin {
    private Dependency dependency;
    private Configuration configuration;
    private final List<Execution> executions = new ArrayList<Execution>();
    private boolean extensions;
    private List<Dependency> pluginDependencies = new ArrayList<Dependency>();

    public MavenPluginImpl() {
    }

    public MavenPluginImpl(MavenPlugin plugin) {
        this.dependency = plugin.getDependency();
        this.configuration = plugin.getConfig();
    }

    @Override
    public Dependency getDependency() {
        return this.dependency;
    }

    public void setDependency(Dependency dependency) {
        this.dependency = dependency;
    }

    @Override
    public Configuration getConfig() {
        if (this.configuration == null) {
            this.configuration = ConfigurationBuilder.create();
        }
        return this.configuration;
    }

    @Override
    public List<Execution> listExecutions() {
        return this.executions;
    }

    @Override
    public boolean isExtensionsEnabled() {
        return this.extensions;
    }

    @Override
    public List<Dependency> getDirectDependencies() {
        return this.pluginDependencies;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("<plugin>");
        this.appendDependency(b, this.dependency);
        if (this.extensions) {
            b.append("<extensions>true</extensions>");
        }
        if (this.configuration != null) {
            b.append(this.configuration.toString());
        }
        if (this.executions.size() > 0) {
            b.append("<executions>");
            for (Execution execution : this.executions) {
                b.append(execution.toString());
            }
            b.append("</executions>");
        }
        if (this.pluginDependencies.size() > 0) {
            b.append("<dependencies>");
            for (Dependency pluginDependency : this.pluginDependencies) {
                b.append("<dependency>");
                this.appendDependency(b, pluginDependency);
                b.append("</dependency>");
            }
            b.append("</dependencies>");
        }
        b.append("</plugin>");
        return b.toString();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void addExecution(Execution execution) {
        this.executions.add(execution);
    }

    public void setExtenstions(boolean extenstions) {
        this.extensions = extenstions;
    }

    public void addPluginDependency(Dependency dependency) {
        this.pluginDependencies.add(dependency);
    }

    private void appendDependency(StringBuilder builder, Dependency appendDependency) {
        this.appendDependencyData(builder, appendDependency, true);
        if (!appendDependency.getExcludedDependencies().isEmpty()) {
            builder.append("<exclusions>");
            for (Dependency exclusion : appendDependency.getExcludedDependencies()) {
                this.appendExclusion(builder, exclusion);
            }
            builder.append("</exclusions>");
        }
    }

    private void appendExclusion(StringBuilder builder, Dependency exclusion) {
        builder.append("<exclusion>");
        this.appendDependencyData(builder, exclusion, false);
        builder.append("</exclusion>");
    }

    private void appendDependencyData(StringBuilder builder, Dependency dependency, boolean withVersion) {
        if (dependency.getGroupId() != null) {
            builder.append("<groupId>").append(dependency.getGroupId()).append("</groupId>");
        }
        if (dependency.getArtifactId() != null) {
            builder.append("<artifactId>").append(dependency.getArtifactId()).append("</artifactId>");
        }
        if (withVersion && dependency.getVersion() != null) {
            builder.append("<version>").append(dependency.getVersion()).append("</version>");
        }
    }
}

