/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.dev.mvn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jboss.forge.dev.mvn.InstalledDependencyCompleter;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.facets.JavaSourceFacet;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="shade")
@Topic(value="Project")
@RequiresProject
@RequiresFacet(value={MavenCoreFacet.class, JavaSourceFacet.class})
@Help(value="Provides quick configurations for the maven-shade-plugin. Find more information at the project homepage ( http://maven.apache.org/plugins/maven-shade-plugin/ )")
public class MavenShadePlugin
implements org.jboss.forge.shell.plugins.Plugin {
    private final Shell shell;
    private final Project project;
    private final Dependency dep = DependencyBuilder.create((String)"org.apache.maven.plugins:maven-shade-plugin:1.4");

    @Inject
    public MavenShadePlugin(Shell shell, Project project) {
        this.shell = shell;
        this.project = project;
    }

    @Command(help="Setup the basic shade configuration (includes all dependencies)")
    public void setup(PipeOut out) throws XmlPullParserException, IOException {
        if (!this.isInstalled()) {
            this.install();
        }
        if (this.isInstalled()) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Shade plugin is installed.");
        }
    }

    @Command(help="Add a dependency to the uber-jar")
    public void include(final @Option(completer=InstalledDependencyCompleter.class, description="the dependency pattern to include [e.g: com.example.*:*]") Dependency dep) {
        this.modifyConfiguration(new ModifyNode(){

            @Override
            public void modify(Node configuration) {
                Node excludes = configuration.getOrCreate("artifactSet").getOrCreate("includes");
                for (Node n : excludes.get("include")) {
                    if (!DependencyBuilder.areEquivalent((Dependency)DependencyBuilder.create((String)n.getText()), (Dependency)dep)) continue;
                    return;
                }
                excludes.createChild("include").text(dep.getGroupId() + ":" + dep.getArtifactId());
            }
        });
    }

    @Command(help="Exclude a dependency from the uber-jar")
    public void exclude(final @Option(completer=InstalledDependencyCompleter.class) Dependency dep) {
        this.modifyConfiguration(new ModifyNode(){

            @Override
            public void modify(Node configuration) {
                Node excludes = configuration.getOrCreate("artifactSet").getOrCreate("excludes");
                for (Node n : excludes.get("exclude")) {
                    if (!DependencyBuilder.areEquivalent((Dependency)DependencyBuilder.create((String)n.getText()), (Dependency)dep)) continue;
                    return;
                }
                excludes.createChild("exclude").text(dep.getGroupId() + ":" + dep.getArtifactId());
            }
        });
    }

    @Command(help="Reset the current shade configuration (includes all dependencies).")
    public void reset() throws XmlPullParserException, IOException {
        this.assertInstalled();
        if (this.shell.promptBoolean("Really reset configuration?")) {
            this.removeShadePlugin();
            this.install();
        }
    }

    @Command(help="Remove all shade configurations from the POM")
    public void remove() throws XmlPullParserException, IOException {
        this.assertInstalled();
        if (this.shell.promptBoolean("Really remove all shade configuration?")) {
            this.removeShadePlugin();
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"Removed all shade configuration from POM.");
        } else if (!this.isInstalled()) {
            ShellMessages.success((ShellPrintWriter)this.shell, (String)"Shade is not configured.");
        } else {
            ShellMessages.info((ShellPrintWriter)this.shell, (String)"Aborted.");
        }
    }

    @Command(help="Relocates bundled dependency classes to a new package")
    public void relocate(final @Option(name="pattern", help="the original package", type=PromptType.JAVA_PACKAGE, required=true) String pattern, final @Option(name="shadedPattern", help="the renamed \"shaded\" package", type=PromptType.JAVA_PACKAGE, required=true) String shadedPattern, final String ... excludes) throws XmlPullParserException, IOException {
        this.modifyConfiguration(new ModifyNode(){

            @Override
            public void modify(Node configuration) {
                Node relocationNode = configuration.getOrCreate("relocations").createChild("relocation");
                relocationNode.createChild("pattern").text(pattern);
                relocationNode.createChild("shadedPattern").text(shadedPattern);
                String excludeMsg = "";
                if (excludes != null && excludes.length > 0) {
                    Node excludesNode = relocationNode.createChild("excludes");
                    for (String e : excludes) {
                        excludesNode.createChild("exclude").text(e);
                    }
                    excludeMsg = ", excluding " + Arrays.asList(excludes);
                }
                ShellMessages.success((ShellPrintWriter)MavenShadePlugin.this.shell, (String)("Relocating [" + pattern + "] to [" + shadedPattern + "]" + excludeMsg));
            }
        });
    }

    @Command(value="make-executable", help="Make the resulting jar executable by specifying the target Main class")
    public void makeExecutable(final @Option(name="mainClass", description="the fully qualified main class [e.g: com.example.Main]", type=PromptType.JAVA_CLASS, required=true) String mainClass) throws XmlPullParserException, IOException {
        this.modifyConfiguration(new ModifyNode(){

            @Override
            public void modify(Node configuration) {
                Node relocationNode = configuration.getOrCreate("transformers").getOrCreate("transformer@implementation=org.apache.maven.plugins.shade.resource.ManifestResourceTransformer");
                relocationNode.getOrCreate("mainClass").text(mainClass);
            }
        });
    }

    private void modifyConfiguration(ModifyNode command) {
        try {
            this.assertInstalled();
            MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
            Model pom = mvn.getPOM();
            Plugin plugin = this.getPlugin(pom);
            PluginExecution execution = (PluginExecution)plugin.getExecutions().get(0);
            Node configuration = XMLParser.parse((String)((Xpp3Dom)execution.getConfiguration()).toUnescapedString());
            command.modify(configuration);
            execution.setConfiguration((Object)Xpp3DomBuilder.build((InputStream)XMLParser.toXMLInputStream((Node)configuration), (String)"UTF-8"));
            mvn.setPOM(pom);
        }
        catch (Exception e) {
            throw new RuntimeException("Error updating configuration", e);
        }
    }

    private void removeShadePlugin() {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.getBuild().removePlugin(this.getPlugin(pom));
        mvn.setPOM(pom);
    }

    private void assertInstalled() {
        if (!this.isInstalled()) {
            throw new RuntimeException("Shade plugin not installed. Run 'shade setup' to continue.");
        }
    }

    private void install() throws XmlPullParserException, IOException {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        Plugin plugin = new Plugin();
        plugin.setArtifactId(this.dep.getArtifactId());
        plugin.setGroupId(this.dep.getGroupId());
        plugin.setVersion(this.dep.getVersion());
        Xpp3Dom dom = Xpp3DomBuilder.build((InputStream)new ByteArrayInputStream("<configuration></configuration>".getBytes()), (String)"UTF-8");
        List executions = plugin.getExecutions();
        PluginExecution execution = new PluginExecution();
        execution.setPhase("package");
        execution.addGoal("shade");
        execution.setConfiguration((Object)dom);
        executions.add(execution);
        pom.getBuild().getPlugins().add(plugin);
        mvn.setPOM(pom);
    }

    private boolean isInstalled() {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        return this.getPlugin(pom) != null;
    }

    private Plugin getPlugin(Model pom) {
        for (Plugin p : pom.getBuild().getPlugins()) {
            if (!this.dep.getGroupId().equals(p.getGroupId()) || !this.dep.getArtifactId().equals(p.getArtifactId())) continue;
            return p;
        }
        return null;
    }

    private static interface ModifyNode {
        public void modify(Node var1);
    }
}

