/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven;

import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.artifact.repository.layout.FlatRepositoryLayout;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.RepositoryPolicy;
import org.jboss.forge.parser.java.util.Strings;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;

public final class RepositoryUtils {
    private RepositoryUtils() {
    }

    public static Proxy convertFromMavenProxy(org.apache.maven.settings.Proxy proxy) {
        Proxy result = null;
        if (proxy != null) {
            Authentication auth = new Authentication(proxy.getUsername(), proxy.getPassword());
            result = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), auth);
        }
        return result;
    }

    public static ArtifactRepository convertFromMavenSettingsRepository(Repository repository) {
        RepositoryPolicy snapshots;
        MavenArtifactRepository result = new MavenArtifactRepository();
        result.setId(repository.getId());
        result.setUrl(repository.getUrl());
        String layout = repository.getLayout();
        if ("default".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        } else if ("flat".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new FlatRepositoryLayout());
        }
        RepositoryPolicy releases = repository.getReleases();
        if (releases != null) {
            result.setReleaseUpdatePolicy(new ArtifactRepositoryPolicy(releases.isEnabled(), releases.getUpdatePolicy(), releases.getChecksumPolicy()));
        }
        if ((snapshots = repository.getSnapshots()) != null) {
            result.setSnapshotUpdatePolicy(new ArtifactRepositoryPolicy(snapshots.isEnabled(), snapshots.getUpdatePolicy(), snapshots.getChecksumPolicy()));
        }
        return result;
    }

    public static ArtifactRepository toArtifactRepository(String id, String url, String layout, boolean containsReleases, boolean containsSnapshots) {
        MavenArtifactRepository result = new MavenArtifactRepository();
        result.setId(id);
        result.setUrl(url);
        if (Strings.isNullOrEmpty((String)layout) || "default".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new DefaultRepositoryLayout());
        } else if ("flat".equals(layout)) {
            result.setLayout((ArtifactRepositoryLayout)new FlatRepositoryLayout());
        }
        result.setReleaseUpdatePolicy(new ArtifactRepositoryPolicy(containsReleases, "never", "warn"));
        result.setSnapshotUpdatePolicy(new ArtifactRepositoryPolicy(containsSnapshots, "daily", "warn"));
        return result;
    }
}

