/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.util.Properties;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.meta.action.impl.handlers.OpenWithExternalHandler;
import org.jboss.tools.common.meta.action.impl.handlers.OpenWithHelper;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class OpenWithChoiceHandler
extends AbstractHandler {
    @Override
    public boolean isEnabled(XModelObject object) {
        if (object == null || object.getFileType() != 1) {
            return false;
        }
        return this.check(object);
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        String displayName = WizardKeys.getMenuItemDisplayName(this.action, object == null ? null : object.getModelEntity());
        if (!OpenWithExternalHandler.checkSave(displayName, object)) {
            return;
        }
        ServiceDialog d = object.getModel().getService();
        String ext = OpenWithHelper.getLogicalExtension(object, this.action);
        XAttributeData a1 = HUtil.find(this.data, 0, "name");
        XAttributeData a2 = HUtil.find(this.data, 0, "default");
        XModelObject o = OpenWithHelper.getEditorObject(object.getModel(), ext);
        String oldname = null;
        if (o != null) {
            oldname = o.get("NAME");
            a1.setValue(oldname);
            a2.setValue("yes");
        } else {
            a2.setValue("no");
        }
        int i = d.showDialog("Open With", "Select external program", new String[]{ModelMessages.OK, ModelMessages.Cancel}, this.data[0], 0);
        if (i != 0) {
            return;
        }
        DefaultCreateHandler.extractProperties(this.data[0]);
        String en = HUtil.getValue(this.data, 0, "name");
        boolean def = "yes".equals(HUtil.getValue(this.data, 0, "default"));
        if (def && !en.equals(oldname)) {
            OpenWithChoiceHandler.changeDefaultEditor(object.getModel(), ext, en);
        } else if (!def && en.equals(oldname)) {
            OpenWithChoiceHandler.removeDefaultEditor(object.getModel(), ext);
        }
        XModelObject editor = object.getModel().getByPath(String.valueOf(OpenWithHelper.EDITORS) + "/" + en);
        String f = OpenWithHelper.getFileName(object);
        OpenWithExternalHandler.start(displayName, f, editor);
    }

    protected boolean check(XModelObject object) {
        String[] es = OpenWithHelper.getEditorList(object.getModel());
        HUtil.hackAttributeConstraintList(this.data, 0, "name", es);
        return es.length > 0;
    }

    static void changeDefaultEditor(XModel model, String ext, String editor) throws XModelException {
        XModelObject o = model.getByPath(OpenWithHelper.EDITORS);
        StringBuffer sb = new StringBuffer();
        String ov = o.getAttributeValue("extensions");
        String[] es = XModelObjectUtil.asStringArray(ov);
        boolean done = false;
        int i = 0;
        while (i < es.length) {
            if (!es[i].toLowerCase().startsWith(String.valueOf(ext.toLowerCase()) + ":")) {
                OpenWithChoiceHandler.append(sb, es[i]);
            } else {
                done = true;
                OpenWithChoiceHandler.append(sb, String.valueOf(ext) + ":" + editor);
            }
            ++i;
        }
        if (!done) {
            OpenWithChoiceHandler.append(sb, String.valueOf(ext) + ":" + editor);
        }
        OpenWithChoiceHandler.applyChange(o, ov, sb.toString());
    }

    static void removeDefaultEditor(XModel model, String ext) throws XModelException {
        XModelObject o = model.getByPath(OpenWithHelper.EDITORS);
        StringBuffer sb = new StringBuffer();
        String ov = o.getAttributeValue("extensions");
        String[] es = XModelObjectUtil.asStringArray(ov);
        int i = 0;
        while (i < es.length) {
            if (!es[i].toLowerCase().startsWith(String.valueOf(ext.toLowerCase()) + ":")) {
                OpenWithChoiceHandler.append(sb, es[i]);
            }
            ++i;
        }
        OpenWithChoiceHandler.applyChange(o, ov, sb.toString());
    }

    private static void append(StringBuffer sb, String item) {
        if (sb.length() > 0) {
            sb.append(';');
        }
        sb.append(item);
    }

    private static void applyChange(XModelObject editors, String ov, String nv) throws XModelException {
        if (nv.equals(ov)) {
            return;
        }
        editors.getModel().changeObjectAttribute(editors, "extensions", nv);
        editors.getModel().saveOptions();
    }
}

