/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.JarFolderImpl;
import org.jboss.tools.common.model.filesystems.impl.RecognizedFileImpl;
import org.jboss.tools.common.model.markers.ResourceMarkers;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XMLUtil;

public class AbstractXMLFileImpl
extends RecognizedFileImpl {
    private static final long serialVersionUID = 3794621010387468744L;
    private RM markers = new RM();
    protected String[] _errors = new String[0];
    protected String[] errors = new String[0];
    protected String loaderError = null;
    public static final boolean turnOffDTDCheck = true;

    public boolean isIncorrect() {
        return "yes".equals(this.get("isIncorrect"));
    }

    public AbstractXMLFileImpl() {
        this.markers.setModelObject(this);
    }

    public String[] getErrors() {
        return this._errors;
    }

    public void setLoaderError(String loaderError) {
        this.loaderError = loaderError;
    }

    public String getLoaderError() {
        return this.loaderError;
    }

    protected final void setErrors(String body, boolean checkDTD, boolean checkSchema) {
        String[] errors;
        String[] stringArray = body.length() == 0 ? null : ("FileXML".equals(this.getModelEntity().getName()) ? null : (errors = this.getParent() instanceof JarFolderImpl ? null : XMLUtil.getXMLErrors(new StringReader(body), checkDTD, checkSchema)));
        if ((errors == null || errors.length == 0) && this.loaderError != null) {
            errors = new String[]{this.loaderError};
        }
        this.setErrors(body, errors);
    }

    protected final void setErrors(String body, String[] errors) {
        if (errors == null) {
            errors = new String[]{};
        }
        this.errors = errors;
        this._errors = (String[])errors.clone();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < errors.length) {
            String ln;
            String pos;
            String er = errors[i];
            int q = er.lastIndexOf(58);
            String string = pos = q < 0 ? "" : er.substring(q + 1);
            if (q >= 0) {
                er = er.substring(0, q);
            }
            String ln1 = ln = (q = er.lastIndexOf(58)) < 0 ? "" : er.substring(q + 1);
            if (q >= 0) {
                er = er.substring(0, q);
            }
            int iln = -1;
            try {
                if (q >= 0 && ln1.length() > 0) {
                    iln = Integer.parseInt(ln1);
                    ln1 = "" + (iln - 1);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            String ep = MessageFormat.format("ERROR: {0} {1}", FindObjectHelper.makeRef(String.valueOf(this.getPath()) + ":" + ln1, String.valueOf(ln) + ":" + pos), er);
            if (iln < 0) {
                this.markers.lines.remove(ep);
            } else {
                this.markers.lines.put(ep, iln);
            }
            sb.append(ep).append('\n');
            this.errors[i] = ep;
            ++i;
        }
        String s = sb.toString();
        if (s.equals(this.get("errors"))) {
            return;
        }
        super.set("incorrectBody", errors.length == 0 && this.loaderError == null ? "" : body);
        this.set("errors", s);
        this.setAttributeValue("isIncorrect", errors.length == 0 && this.loaderError == null ? "no" : "yes");
        if (!this.isOverlapped()) {
            this.markers.update();
        }
    }

    protected boolean isOverlapped() {
        XModelObject p = this.getParent();
        while (p != null && !"true".equals(p.get("overlapped"))) {
            p = p.getParent();
        }
        return p != null;
    }

    protected ResourceMarkers getResourceMarkers() {
        return this.markers;
    }

    class RM
    extends ResourceMarkers {
        Map<String, Integer> lines;
        boolean enabled;

        public RM() {
            super(ResourceMarkers.TEXT_PROBLEM);
            this.lines = new HashMap<String, Integer>();
            this.enabled = false;
        }

        @Override
        protected String[] getErrors() {
            if (!AbstractXMLFileImpl.this.isIncorrect()) {
                return new String[0];
            }
            String es = AbstractXMLFileImpl.this.get("errors");
            if (es == null || es.length() == 0) {
                return new String[0];
            }
            return AbstractXMLFileImpl.this.errors;
        }

        @Override
        protected int getLocation(String s) {
            Integer i = this.lines.get(s);
            return i == null ? -1 : i;
        }

        @Override
        public void update() {
            if (this.enabled) {
                super.update();
            }
        }
    }
}

