/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.MountFileSystemHandler;
import org.jboss.tools.common.model.util.FindObjectHelper;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class MountFolderHandler
extends AbstractHandler {
    private MountFileSystemHandler h = new MountFileSystemHandler();

    @Override
    public boolean isEnabled(XModelObject object) {
        if (object == null || "true".equals(object.get("overlapped"))) {
            return false;
        }
        String entity = object.getModelEntity().getName();
        if ("FileFolder".equals(entity)) {
            return true;
        }
        return object.getFileType() == 1 && "jar".equals(object.getAttributeValue("extension")) && this.isInFileFolderSystem(object);
    }

    @Override
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        String entity = this.data[0].getModelEntity().getName();
        p = new Properties();
        String path = object.getPath();
        String rpath = XModelObjectLoaderUtil.getResourcePath(object);
        String fspath = path.substring(0, path.length() - rpath.length());
        XModelObject fso = object.getModel().getByPath(fspath);
        String location = String.valueOf(fso.getAttributeValue("location")) + rpath;
        p.setProperty("location", location);
        XModelObject c = this.h.mount(fso.getParent(), p, entity);
        c.setModified(false);
        FindObjectHelper.findModelObject(c, 0);
    }

    private boolean isInFileFolderSystem(XModelObject o) {
        while (o != null && o.getFileType() != 3) {
            o = o.getParent();
        }
        return o != null && o.getModelEntity().getName().equals("FileSystemFolder");
    }
}

