/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.asf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.types.selectors.SelectorUtils;
import org.apache.tools.ant.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryScanner {
    private static final boolean ON_VMS = Os.isFamily((String)"openvms");
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final FileUtils FILE_UTILS = FileUtils.getFileUtils();
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS;
    private static Vector<String> defaultExcludes;
    protected File basedir;
    protected String[] includes;
    protected String[] excludes;
    protected FileSelector[] selectors = null;
    protected Vector<String> filesIncluded;
    protected Vector<String> filesNotIncluded;
    protected Vector<String> filesExcluded;
    protected Vector<String> dirsIncluded;
    protected Vector<String> dirsNotIncluded;
    protected Vector<String> dirsExcluded;
    protected Vector<String> filesDeselected;
    protected Vector<String> dirsDeselected;
    protected boolean isCaseSensitive = true;
    protected boolean everythingIncluded = true;
    private Map<File, File[]> fileListMap = new HashMap<File, File[]>();
    private Set<String> scannedDirs = new HashSet<String>();
    private Set<String> includeNonPatterns = new HashSet<String>();
    private Set<String> excludeNonPatterns = new HashSet<String>();
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private boolean complete = false;
    private Object scanLock = new Object();
    private IllegalStateException illegal = null;
    private DirectoryScannerIterator iterator = null;
    private boolean tmpNullIncludes;
    private boolean tmpNullExcludes;

    static {
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        CS_THEN_NON_CS = blArray;
        defaultExcludes = new Vector();
        DirectoryScanner.resetDefaultExcludes();
    }

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart((String)pattern, (String)str);
    }

    protected static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath((String)pattern, (String)str);
    }

    protected static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match((String)pattern, (String)str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match((String)pattern, (String)str, (boolean)isCaseSensitive);
    }

    public static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static String implodeStrings(String[] strings) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < strings.length) {
            buffer.append(strings[i]).append(',');
            ++i;
        }
        return buffer.toString();
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    public static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        int i = 0;
        while (i < DEFAULTEXCLUDES.length) {
            defaultExcludes.add(DEFAULTEXCLUDES[i]);
            ++i;
        }
    }

    public void setBasedir(String basedir) {
        this.setBasedir(basedir == null ? null : new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public synchronized File getBasedir() {
        return this.basedir;
    }

    public synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            int i = 0;
            while (i < includes.length) {
                this.includes[i] = DirectoryScanner.normalizePattern(includes[i]);
                ++i;
            }
        }
    }

    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            int i = 0;
            while (i < excludes.length) {
                this.excludes[i] = DirectoryScanner.normalizePattern(excludes[i]);
                ++i;
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                int i = 0;
                while (i < excludes.length) {
                    tmp[this.excludes.length + i] = DirectoryScanner.normalizePattern(excludes[i]);
                    ++i;
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = String.valueOf(pattern) + "**";
        }
        return pattern;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanWait() {
        Object object = this.scanLock;
        synchronized (object) {
            if (this.scanning) {
                while (this.scanning) {
                    try {
                        this.scanLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                return;
            }
            this.scanning = true;
            this.complete = false;
        }
    }

    protected void scanPrepare() {
        String[] stringArray;
        boolean nullIncludes;
        this.tmpNullIncludes = this.includes == null;
        this.tmpNullExcludes = this.excludes == null;
        this.illegal = null;
        this.clearResults();
        boolean bl = nullIncludes = this.includes == null;
        if (this.includes == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "**";
        } else {
            stringArray = this.includes;
        }
        this.includes = stringArray;
        String[] stringArray3 = this.excludes = this.excludes == null ? new String[]{} : this.excludes;
        if (this.basedir == null) {
            if (nullIncludes) {
                return;
            }
        } else {
            if (!this.basedir.exists()) {
                this.illegal = new IllegalStateException("basedir " + this.basedir + " does not exist");
            }
            if (!this.basedir.isDirectory()) {
                this.illegal = new IllegalStateException("basedir " + this.basedir + " is not a directory");
            }
            if (this.illegal != null) {
                throw this.illegal;
            }
        }
        if (this.isIncluded("")) {
            if (!this.isExcluded("")) {
                if (this.isSelected("", this.basedir)) {
                    this.dirsIncluded.addElement("");
                } else {
                    this.dirsDeselected.addElement("");
                }
            } else {
                this.dirsExcluded.addElement("");
            }
        } else {
            this.dirsNotIncluded.addElement("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() throws IllegalStateException {
        this.scanWait();
        try {
            DirectoryScanner directoryScanner = this;
            synchronized (directoryScanner) {
                this.scanPrepare();
                this.runScan();
            }
        }
        finally {
            this.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        Object object = this.scanLock;
        synchronized (object) {
            this.clearCaches();
            this.iterator = null;
            this.includes = this.tmpNullIncludes ? null : this.includes;
            this.excludes = this.tmpNullExcludes ? null : this.excludes;
            this.complete = true;
            this.scanning = false;
            this.scanLock.notifyAll();
        }
    }

    private void runScan() {
        Map<String, String> newroots = this.getNewRoots();
        if (newroots.containsKey("") && this.basedir != null) {
            this.scandirWrap(this.basedir, "");
        } else {
            File canonBase = null;
            if (this.basedir != null) {
                try {
                    canonBase = this.basedir.getCanonicalFile();
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            for (Map.Entry<String, String> entry : newroots.entrySet()) {
                this.handleOneEntry(entry, canonBase);
            }
        }
    }

    protected void handleOneEntry(Map.Entry entry, File canonBase) {
        String[] currentelement_ = new String[]{(String)entry.getKey()};
        if (this.basedir == null && !FileUtils.isAbsolutePath((String)currentelement_[0])) {
            return;
        }
        String originalpattern = (String)entry.getValue();
        File[] myfile_ = new File[]{this.getChild(this.basedir, currentelement_[0])};
        this.perfectOneEntry(canonBase, myfile_, currentelement_);
        File myfile = myfile_[0];
        String currentelement = currentelement_[0];
        if (myfile != null && myfile.exists()) {
            if (myfile.isDirectory()) {
                if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                    this.accountForIncludedDir(currentelement, myfile);
                } else {
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = String.valueOf(currentelement) + File.separatorChar;
                    }
                    this.scandirWrap(myfile, currentelement);
                }
            } else {
                boolean included;
                boolean bl = included = this.isCaseSensitive() ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase(currentelement);
                if (included) {
                    this.accountForIncludedFile(currentelement, myfile);
                }
            }
        }
    }

    protected void perfectOneEntry(File canonBase, File[] myfile_, String[] currentelement_) {
        File f;
        File myfile = myfile_[0];
        String currentelement = currentelement_[0];
        if (myfile.exists()) {
            try {
                String path;
                String string = path = this.basedir == null ? myfile.getCanonicalPath() : FILE_UTILS.removeLeadingPath(canonBase, myfile.getCanonicalFile());
                if ((!path.equals(currentelement) || ON_VMS) && (myfile = this.findFile(this.basedir, currentelement, true)) != null && this.basedir != null) {
                    currentelement = FILE_UTILS.removeLeadingPath(this.basedir, myfile);
                }
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || (f = this.findFile(this.basedir, currentelement, false)) == null || !f.exists())) {
            currentelement = this.basedir == null ? f.getAbsolutePath() : FILE_UTILS.removeLeadingPath(this.basedir, f);
            myfile = f;
        }
        myfile_[0] = myfile;
        currentelement_[0] = currentelement;
    }

    protected Map<String, String> getNewRoots() {
        HashMap<String, String> newroots = new HashMap<String, String>();
        int i = 0;
        while (i < this.includes.length) {
            if (!(FileUtils.isAbsolutePath((String)this.includes[i]) ? this.basedir != null && !SelectorUtils.matchPatternStart((String)this.includes[i], (String)this.basedir.getAbsolutePath(), (boolean)this.isCaseSensitive()) : this.basedir == null)) {
                newroots.put(SelectorUtils.rtrimWildcardTokens((String)this.includes[i]), this.includes[i]);
            }
            ++i;
        }
        return newroots;
    }

    protected synchronized void clearResults() {
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    protected void scandirWrap(File dir, String vpath) {
        if (this.iterator == null) {
            this.scandirImpl(dir, vpath);
        } else {
            this.iterator.addFileToScanList(dir, vpath);
        }
    }

    protected void scandirImpl(File dir, String vpath) {
        if (dir == null) {
            throw new BuildException("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new BuildException(dir + " doesn't exist.");
        }
        if (!dir.isDirectory()) {
            throw new BuildException(dir + " is not a directory.");
        }
        if (this.hasBeenScanned(vpath)) {
            return;
        }
        File[] newfiles = this.list(dir);
        if (newfiles == null) {
            throw new BuildException("IO error scanning directory '" + dir.getAbsolutePath() + "'");
        }
        int i = 0;
        while (i < newfiles.length) {
            String name = String.valueOf(vpath) + this.getName(newfiles[i]);
            File file = newfiles[i];
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedDir(name, file);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(name);
                    if (this.couldHoldIncluded(name)) {
                        this.scandirWrap(file, String.valueOf(name) + File.separator);
                    }
                }
            } else if (file.isFile()) {
                if (this.isIncluded(name)) {
                    this.accountForIncludedFile(name, file);
                } else {
                    this.everythingIncluded = false;
                    this.filesNotIncluded.addElement(name);
                }
            }
            ++i;
        }
    }

    protected String getName(File file) {
        return file.getName();
    }

    private void accountForIncludedFile(String name, File file) {
        this.processIncluded(name, file, this.filesIncluded, this.filesExcluded, this.filesDeselected);
    }

    private void accountForIncludedDir(String name, File file) {
        this.processIncluded(name, file, this.dirsIncluded, this.dirsExcluded, this.dirsDeselected);
        if (this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandirWrap(file, String.valueOf(name) + File.separator);
        }
    }

    private void processIncluded(String name, File file, Vector<String> inc, Vector<String> exc, Vector<String> des) {
        if (inc.contains(name) || exc.contains(name) || des.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            exc.add(name);
            this.postExclude(file, name);
        } else if (this.isSelected(name, file)) {
            included = true;
            inc.add(name);
            this.postInclude(file, name);
        } else {
            des.add(name);
        }
        this.everythingIncluded &= included;
    }

    protected void postInclude(File f, String name) {
        if (this.iterator != null) {
            this.iterator.addMatch(f, name);
        }
    }

    protected void postExclude(File f, String name) {
    }

    protected boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.includePatterns.length) {
            if (DirectoryScanner.matchPath(this.includePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean couldHoldIncluded(String name) {
        int i = 0;
        while (i < this.includes.length) {
            if (DirectoryScanner.matchPatternStart(this.includes[i], name, this.isCaseSensitive()) && this.isMorePowerfulThanExcludes(name, this.includes[i]) && this.isDeeper(this.includes[i], name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDeeper(String pattern, String name) {
        Vector p = SelectorUtils.tokenizePath((String)pattern);
        Vector n = SelectorUtils.tokenizePath((String)name);
        return p.contains("**") || p.size() > n.size();
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = String.valueOf(name) + File.separator + "**";
        int counter = 0;
        while (counter < this.excludes.length) {
            if (this.excludes[counter].equals(soughtexclude)) {
                return false;
            }
            ++counter;
        }
        return true;
    }

    private boolean contentsExcluded(String name) {
        name = name.endsWith(File.separator) ? name : String.valueOf(name) + File.separator;
        int i = 0;
        while (i < this.excludes.length) {
            String e = this.excludes[i];
            if (e.endsWith("**") && SelectorUtils.matchPath((String)e.substring(0, e.length() - 2), (String)name, (boolean)this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        int i = 0;
        while (i < this.excludePatterns.length) {
            if (DirectoryScanner.matchPath(this.excludePatterns[i], name, this.isCaseSensitive())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelected(String name, File file) {
        if (this.selectors != null) {
            int i = 0;
            while (i < this.selectors.length) {
                if (!this.selectors[i].isSelected(this.basedir, name, file)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public synchronized String[] getIncludedFiles() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public synchronized int getIncludedFilesCount() {
        if (this.filesIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.filesIncluded.size();
    }

    public synchronized String[] getIncludedDirectories() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public synchronized int getIncludedDirsCount() {
        if (this.dirsIncluded == null) {
            throw new IllegalStateException("Must call scan() first");
        }
        return this.dirsIncluded.size();
    }

    public synchronized void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + defaultExcludes.size()];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        int i = 0;
        while (i < defaultExcludesTemp.length) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
            ++i;
        }
        this.excludes = newExcludes;
    }

    public synchronized Resource getResource(String name) {
        return new FileResource(this.basedir, name);
    }

    private File[] list(File file) {
        File[] files = this.fileListMap.get(file);
        if (files == null && (files = this.list2(file)) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    protected File[] list2(File file) {
        return file.listFiles();
    }

    private File findFile(File base, String path, boolean cs) {
        if (FileUtils.isAbsolutePath((String)path)) {
            if (base == null) {
                String[] s = FILE_UTILS.dissect(path);
                base = new File(s[0]);
                path = s[1];
            } else {
                File f = FILE_UTILS.normalize(path);
                String s = FILE_UTILS.removeLeadingPath(base, f);
                if (s.equals(f.getAbsolutePath())) {
                    return null;
                }
                path = s;
            }
        }
        return this.findFile(base, SelectorUtils.tokenizePath((String)path), cs);
    }

    private File findFile(File base, Vector pathElements, boolean cs) {
        if (pathElements.size() == 0) {
            return base;
        }
        String current = (String)pathElements.remove(0);
        if (base == null) {
            return this.findFile(new File(current), pathElements, cs);
        }
        if (!base.isDirectory()) {
            return null;
        }
        File[] files = this.list(base);
        if (files == null) {
            throw new BuildException("IO error scanning directory " + base.getAbsolutePath());
        }
        boolean[] matchCase = cs ? CS_SCAN_ONLY : CS_THEN_NON_CS;
        int i = 0;
        while (i < matchCase.length) {
            int j = 0;
            while (j < files.length) {
                if (matchCase[i] ? files[j].getName().equals(current) : files[j].getName().equalsIgnoreCase(current)) {
                    return this.findFile(files[j], pathElements, cs);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath((String)path));
    }

    private boolean isSymlink(File base, Vector pathElements) {
        if (pathElements.size() > 0) {
            String current = (String)pathElements.remove(0);
            try {
                return FILE_UTILS.isSymbolicLink(base, current) || this.isSymlink(new File(base, current), pathElements);
            }
            catch (IOException iOException) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    Set<String> getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set<String> set, String[] patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.length);
        int i = 0;
        while (i < patterns.length) {
            if (!SelectorUtils.hasWildcards((String)patterns[i])) {
                set.add(this.isCaseSensitive() ? patterns[i] : patterns[i].toUpperCase());
            } else {
                al.add(patterns[i]);
            }
            ++i;
        }
        return set.size() == 0 ? patterns : al.toArray(new String[al.size()]);
    }

    protected File getChild(File file, String element) {
        return new File(file, element);
    }

    public Iterator<File> iterator() {
        this.iterator = new DirectoryScannerIterator();
        return this.iterator;
    }

    protected class DSPair {
        private File file;
        private String vpath;

        public DSPair(File file, String vpath) {
            this.file = file;
            this.vpath = vpath;
        }

        static /* synthetic */ String access$1(DSPair dSPair) {
            return dSPair.vpath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DirectoryScannerIterator
    implements Iterator<File> {
        protected ArrayList<DSPair> matches = new ArrayList();
        protected ArrayList<DSPair> toScan = new ArrayList();
        protected DirectoryScanner scanner;
        protected int pointer = 0;

        public DirectoryScannerIterator() {
            DirectoryScanner.this.iterator = this;
            DirectoryScanner.this.scanPrepare();
            DirectoryScanner.this.runScan();
        }

        protected void addFileToScanList(File file, String vpath) {
            this.toScan.add(0, new DSPair(file, vpath));
        }

        protected void addMatch(File file, String vpath) {
            this.matches.add(this.pointer, new DSPair(file, vpath));
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.pointer <= this.matches.size() - 1) {
                return true;
            }
            if (!this.toScan.isEmpty()) ** GOTO lbl7
            return false;
lbl-1000:
            // 1 sources

            {
                pair = this.toScan.remove(0);
                DirectoryScanner.this.scandirImpl(DSPair.access$0(pair), DSPair.access$1(pair));
lbl7:
                // 2 sources

                ** while (!this.toScan.isEmpty() && this.pointer == this.matches.size())
            }
lbl8:
            // 1 sources

            v0 = hasNext = this.pointer <= this.matches.size() - 1 || this.pointer == this.matches.size() && this.toScan.isEmpty() == false;
            if (!hasNext) {
                DirectoryScanner.this.release();
            }
            return hasNext;
        }

        @Override
        public File next() {
            if (this.pointer <= this.matches.size() - 1) {
                return this.matches.get(this.pointer++).file;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

