/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.ArchivesCoreMessages;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.DirectoryScannerFactory;
import org.jboss.ide.eclipse.archives.core.model.EventManager;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFileSet;
import org.jboss.ide.eclipse.archives.core.model.IArchiveFolder;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeVisitor;
import org.jboss.ide.eclipse.archives.core.util.ModelUtil;
import org.jboss.ide.eclipse.archives.core.util.PathUtils;
import org.jboss.ide.eclipse.archives.core.util.internal.ModelTruezipBridge;
import org.jboss.ide.eclipse.archives.core.util.internal.TrueZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveBuildDelegate {
    public static int CANNOT_REGISTER_CODE = 31415;

    public IStatus fullProjectBuild(IPath project, IProgressMonitor monitor) {
        EventManager.cleanProjectBuild(project);
        EventManager.startedBuild(project);
        IArchiveModelRootNode root = ArchivesModel.instance().getRoot(project);
        if (root == null) {
            IArchiveModelRootNode registered;
            if (ArchivesModel.instance().canReregister(project) && (registered = ArchivesModel.instance().registerProject(project, monitor)) != null) {
                return Status.OK_STATUS;
            }
            Status s = new Status(4, "org.jboss.ide.eclipse.archives.core", CANNOT_REGISTER_CODE, ArchivesCore.bind(ArchivesCoreMessages.ErrorLocatingRootNode, project.toOSString()), null);
            EventManager.error(null, new IStatus[]{s});
            monitor.done();
            return Status.OK_STATUS;
        }
        IArchiveNode[] nodes = root.getChildren(0);
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        monitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.BuildingProject, ArchivesCore.getInstance().getVFS().getProjectName(project)), nodes.length * 1000);
        int i = 0;
        while (i < nodes.length) {
            errors.addAll(Arrays.asList(this.fullArchiveBuild((IArchive)nodes[i], (IProgressMonitor)new SubProgressMonitor(monitor, 1000), false)));
            ++i;
        }
        EventManager.finishedBuild(project);
        EventManager.error(null, errors.toArray(new IStatus[errors.size()]));
        monitor.done();
        if (errors.size() == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.archives.core", 4, ArchivesCoreMessages.ErrorBuilding, null);
        int i2 = 0;
        while (i2 < errors.size()) {
            ms.add((IStatus)errors.get(i2));
            ++i2;
        }
        return ms;
    }

    protected IArchive[] findReferences(IArchive node2) {
        final TreeSet s = new TreeSet();
        final IPath dest = node2.getArchiveFilePath();
        ArchivesModel.instance().accept(new IArchiveNodeVisitor(){

            public boolean visit(IArchiveNode node) {
                IArchiveFileSet fs;
                DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] wrapper;
                if (node.getNodeType() == 2 && (wrapper = (fs = (IArchiveFileSet)node).getMatches(dest)) != null && wrapper.length > 0) {
                    s.add(fs.getRootArchive());
                }
                return true;
            }
        });
        return s.toArray(new IArchive[s.size()]);
    }

    public IStatus fullArchiveBuild(IArchive pkg, IProgressMonitor monitor) {
        return this.fullArchiveBuild(pkg, monitor, true);
    }

    protected IStatus fullArchiveBuild(IArchive pkg, IProgressMonitor monitor, boolean log) {
        if (!pkg.canBuild()) {
            Status s = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.CannotBuildBadConfiguration, pkg.getName()), null);
            if (log) {
                EventManager.error(pkg, new IStatus[]{s});
            }
            monitor.done();
            return s;
        }
        EventManager.cleanArchiveBuild(pkg);
        EventManager.startedBuildingArchive(pkg);
        IPath filePath = pkg.getArchiveFilePath();
        if (filePath.toFile().isFile()) {
            filePath.toFile().delete();
        } else {
            TrueZipUtil.javaIODeleteDir(filePath.toFile());
        }
        IPath dest = PathUtils.getGlobalLocation(pkg);
        if (dest != null && !dest.toFile().exists() && !dest.toFile().mkdirs()) {
            Status s = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.CannotBuildOutputLocationNotWriteable, pkg.getName(), dest.toString()), null);
            if (log) {
                EventManager.error(pkg, new IStatus[]{s});
            }
            monitor.done();
            return s;
        }
        ArrayList<Object> errors = new ArrayList<Object>();
        monitor.beginTask(ArchivesCore.bind(ArchivesCoreMessages.BuildingArchive, pkg.toString()), 8000);
        if (!ModelTruezipBridge.createFile(pkg)) {
            Status e = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.ErrorCreatingOutputFile, ModelTruezipBridge.getFilePath(pkg), pkg.toString()));
            errors.add(e);
        }
        monitor.worked(200);
        IArchiveFolder[] folders = ModelUtil.findAllDescendentFolders(pkg);
        SubProgressMonitor folderMonitor = new SubProgressMonitor(monitor, 800);
        folderMonitor.beginTask(ArchivesCoreMessages.CreatingFolders, folders.length * 100);
        int i = 0;
        while (i < folders.length) {
            if (!ModelTruezipBridge.createFile(folders[i])) {
                Status e = new Status(4, "org.jboss.ide.eclipse.archives.core", ArchivesCore.bind(ArchivesCoreMessages.ErrorCreatingOutputFile, ModelTruezipBridge.getFilePath(folders[i]), folders[i].toString()));
                errors.add(e);
            }
            folderMonitor.worked(100);
            ++i;
        }
        folderMonitor.done();
        IArchiveFileSet[] filesets = ModelUtil.findAllDescendentFilesets(pkg);
        SubProgressMonitor filesetMonitor = new SubProgressMonitor(monitor, 6000);
        filesetMonitor.beginTask(ArchivesCoreMessages.BuildingFilesets, filesets.length * 1000);
        int i2 = 0;
        while (i2 < filesets.length) {
            IStatus[] errors2 = this.fullFilesetBuild(filesets[i2], (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)filesetMonitor, 1000), pkg);
            errors.addAll(Arrays.asList(errors2));
            ++i2;
        }
        filesetMonitor.done();
        ArrayList<IArchive> referencingArchives = new ArrayList<IArchive>();
        referencingArchives.addAll(Arrays.asList(this.findReferences(pkg)));
        SubProgressMonitor referenceMon = new SubProgressMonitor(monitor, 1000);
        referenceMon.beginTask(ArchivesCoreMessages.BuildingArchive, referencingArchives.size() * 1000);
        for (IArchive toBuild : referencingArchives) {
            if (toBuild.equals(pkg)) continue;
            errors.add(this.fullArchiveBuild(toBuild, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)referenceMon, 1000), log));
        }
        EventManager.finishedBuildingArchive(pkg);
        IStatus[] errors2 = errors.toArray(new IStatus[errors.size()]);
        if (log) {
            EventManager.error(pkg, errors2);
        }
        monitor.done();
        if (errors2.length == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus ms = new MultiStatus("org.jboss.ide.eclipse.archives.core", 4, ArchivesCoreMessages.ErrorBuilding, null);
        int i3 = 0;
        while (i3 < errors.size()) {
            ms.add((IStatus)errors.get(i3));
            ++i3;
        }
        return ms;
    }

    protected IStatus[] fullFilesetBuild(IArchiveFileSet fileset, IProgressMonitor monitor, IArchive topLevel) {
        EventManager.startedCollectingFileSet(fileset);
        fileset.resetScanner();
        DirectoryScannerFactory.DirectoryScannerExtension.FileWrapper[] paths = fileset.findMatchingPaths();
        ModelTruezipBridge.FileWrapperStatusPair result = ModelTruezipBridge.fullFilesetBuild(fileset, monitor, true);
        EventManager.filesUpdated(topLevel, fileset, paths);
        EventManager.finishedCollectingFileSet(fileset);
        return result.s;
    }

    public void incrementalBuild(IArchive archive, Set<IPath> addedChanged, Set<IPath> removed, boolean workspaceRelative, IProgressMonitor monitor) {
        IArchiveFileSet[] matchingFilesets;
        IPath globalPath;
        ArrayList<IStatus> errors = new ArrayList<IStatus>();
        if (addedChanged.size() == 0 && removed.size() == 0) {
            return;
        }
        int totalWork = addedChanged.size() * 100 + removed.size() * 200 + 50 + 500;
        monitor.beginTask(ArchivesCoreMessages.ProjectArchivesIncrementalBuild, totalWork);
        ArrayList<IArchive> topPackagesChanged = new ArrayList<IArchive>();
        ArrayList<IArchiveFileSet> seen = new ArrayList<IArchiveFileSet>();
        for (IPath path : removed) {
            globalPath = !workspaceRelative ? path : ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(path);
            matchingFilesets = ModelUtil.getMatchingFilesets(archive, path, workspaceRelative);
            this.localFireAffectedTopLevelPackages(topPackagesChanged, matchingFilesets);
            int j = 0;
            while (j < matchingFilesets.length) {
                IStatus[] errors2 = ModelTruezipBridge.deleteFiles(matchingFilesets[j], matchingFilesets[j].getMatches(globalPath), (IProgressMonitor)new NullProgressMonitor(), false);
                errors.addAll(Arrays.asList(errors2));
                if (!seen.contains(matchingFilesets[j])) {
                    seen.add(matchingFilesets[j]);
                }
                ++j;
            }
            EventManager.fileRemoved(path, matchingFilesets);
            monitor.worked(100);
        }
        Iterator fit = seen.iterator();
        while (fit.hasNext()) {
            ((IArchiveFileSet)fit.next()).resetScanner();
        }
        for (IPath path : addedChanged) {
            globalPath = !workspaceRelative ? path : ArchivesCore.getInstance().getVFS().workspacePathToAbsolutePath(path);
            matchingFilesets = ModelUtil.getMatchingFilesets(archive, path, workspaceRelative);
            this.localFireAffectedTopLevelPackages(topPackagesChanged, matchingFilesets);
            int j = 0;
            while (j < matchingFilesets.length) {
                if (!seen.contains(matchingFilesets[j])) {
                    seen.add(matchingFilesets[j]);
                    matchingFilesets[j].resetScanner();
                }
                IStatus[] errors2 = ModelTruezipBridge.copyFiles(matchingFilesets[j], matchingFilesets[j].getMatches(globalPath), (IProgressMonitor)new NullProgressMonitor(), true, false);
                errors.addAll(Arrays.asList(errors2));
                ++j;
            }
            EventManager.fileUpdated(path, matchingFilesets);
            monitor.worked(200);
        }
        TrueZipUtil.sync();
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                return 0;
            }
        };
        TreeSet<IPath> changedPaths = new TreeSet<IPath>(c);
        Iterator<IArchive> i2 = topPackagesChanged.iterator();
        SubProgressMonitor consumedMon = new SubProgressMonitor(monitor, 500);
        while (i2.hasNext()) {
            try {
                IArchive changed = i2.next();
                if (!addedChanged.contains(changed.getArchiveFilePath())) {
                    changedPaths.add(changed.getArchiveFilePath());
                }
                EventManager.finishedBuildingArchive(changed);
            }
            catch (ClassCastException cce) {
                cce.printStackTrace();
            }
        }
        if (errors.size() > 0) {
            EventManager.error(null, errors.toArray(new IStatus[errors.size()]));
        } else {
            this.incrementalBuild(null, changedPaths, new TreeSet<IPath>(), false, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)consumedMon, 500));
        }
        monitor.worked(50);
        monitor.done();
    }

    private void localFireAffectedTopLevelPackages(ArrayList<IArchive> affected, IArchiveFileSet[] filesets) {
        int i = 0;
        while (i < filesets.length) {
            if (!affected.contains(filesets[i].getRootArchive())) {
                affected.add(filesets[i].getRootArchive());
                EventManager.startedBuildingArchive(filesets[i].getRootArchive());
            }
            ++i;
        }
    }
}

