/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.util.internal;

import de.schlichtherle.io.AbstractArchiveDetector;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.zip.Zip32Driver;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;

public class TrueZipUtil {
    private static ArchiveDetector JAR_ARCHIVE_DETECTOR;

    public static de.schlichtherle.io.File getFile(IPath path) {
        return TrueZipUtil.getFile(path, (ArchiveDetector)ArchiveDetector.DEFAULT);
    }

    public static de.schlichtherle.io.File getFile(IPath path, ArchiveDetector detector) {
        return new de.schlichtherle.io.File(path.toOSString(), detector);
    }

    public static boolean pathExists(IPath path) {
        return TrueZipUtil.pathExists(TrueZipUtil.getFile(path));
    }

    public static boolean pathExists(de.schlichtherle.io.File file) {
        return file.exists();
    }

    public static long getTimestamp(IPath path) {
        return TrueZipUtil.getTimestamp(TrueZipUtil.getFile(path));
    }

    public static long getTimestamp(de.schlichtherle.io.File file) {
        return file.lastModified();
    }

    public static boolean copyFile(String source, IPath dest) throws IOException {
        return TrueZipUtil.copyFile(source, TrueZipUtil.getFile(dest), true);
    }

    public static boolean copyFile(String source, de.schlichtherle.io.File file, boolean updateTimestamps) {
        file.getParentFile().mkdirs();
        boolean b = new de.schlichtherle.io.File(source, (ArchiveDetector)ArchiveDetector.NULL).archiveCopyAllTo((File)file);
        return b && (!updateTimestamps || TrueZipUtil.updateParentTimestamps(file));
    }

    public static boolean touchFile(IPath path) {
        de.schlichtherle.io.File f = TrueZipUtil.getFile(path);
        boolean b = f.setLastModified(System.currentTimeMillis());
        return b && TrueZipUtil.updateParentTimestamps(path);
    }

    public static boolean deleteAll(IPath path, String fileName) {
        return TrueZipUtil.deleteAll(path.append(fileName));
    }

    public static boolean deleteAll(IPath path) {
        return TrueZipUtil.deleteAll(TrueZipUtil.getFile(path));
    }

    public static boolean deleteAll(de.schlichtherle.io.File file) {
        return file.deleteAll();
    }

    public static boolean deleteEmptyChildren(File file) {
        boolean b = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                b &= TrueZipUtil.deleteEmptyFolders(children[i]);
                ++i;
            }
        }
        return b;
    }

    public static boolean deleteEmptyFolders(File file) {
        boolean b = true;
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                b &= TrueZipUtil.deleteEmptyFolders(children[i]);
                ++i;
            }
            if (file.listFiles().length == 0) {
                file.delete();
            }
        }
        return b;
    }

    public static boolean createFolder(IPath parent, String folderName) {
        boolean b = new de.schlichtherle.io.File((File)TrueZipUtil.getFile(parent, (ArchiveDetector)ArchiveDetector.DEFAULT), folderName, (ArchiveDetector)ArchiveDetector.NULL).mkdirs();
        return b && TrueZipUtil.updateParentTimestamps(parent.append(folderName));
    }

    public static boolean createFolder(IPath path) {
        return TrueZipUtil.createFolder(path.removeLastSegments(1), path.lastSegment());
    }

    public static boolean createArchive(IPath parent, String folderName) {
        boolean b = new de.schlichtherle.io.File((File)TrueZipUtil.getFile(parent, (ArchiveDetector)ArchiveDetector.DEFAULT), folderName, TrueZipUtil.getJarArchiveDetector()).mkdirs();
        return b && TrueZipUtil.updateParentTimestamps(parent.append(folderName));
    }

    public static boolean createArchive(IPath path) {
        return TrueZipUtil.createArchive(path.removeLastSegments(1), path.lastSegment());
    }

    public static void umount() {
        try {
            de.schlichtherle.io.File.umount();
        }
        catch (ArchiveException archiveException) {}
    }

    public static void syncExec(Runnable run) {
        try {
            if (run != null) {
                run.run();
            }
        }
        catch (Exception exception) {}
        TrueZipUtil.umount();
    }

    public static void sync() {
        TrueZipUtil.syncExec(null);
    }

    public static boolean updateParentTimestamps(IPath path) {
        return TrueZipUtil.updateParentTimestamps(TrueZipUtil.getFile(path));
    }

    public static boolean updateParentTimestamps(de.schlichtherle.io.File file) {
        long time = System.currentTimeMillis();
        de.schlichtherle.io.File parent = (de.schlichtherle.io.File)file.getParentFile();
        boolean b = true;
        while (parent != null) {
            b &= parent.setLastModified(time);
            parent = parent.getEnclArchive();
        }
        return b;
    }

    public static ArchiveDetector getJarArchiveDetector() {
        if (JAR_ARCHIVE_DETECTOR == null) {
            JAR_ARCHIVE_DETECTOR = new JarArchiveDetector();
        }
        return JAR_ARCHIVE_DETECTOR;
    }

    public static boolean javaIODeleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = TrueZipUtil.javaIODeleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        }
        return dir.delete();
    }

    public static class JarArchiveDetector
    extends AbstractArchiveDetector {
        public ArchiveDriver getArchiveDriver(String arg0) {
            return new Zip32Driver();
        }
    }
}

