/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.jpa.container;

import javax.inject.Inject;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.spec.javaee.jpa.api.JPADataSource;
import org.jboss.forge.spec.javaee.jpa.api.PersistenceContainer;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.PersistenceUnitDef;
import org.jboss.shrinkwrap.descriptor.api.spec.jpa.persistence.TransactionType;

public class NonJTAContainer
implements PersistenceContainer {
    @Inject
    private ShellPrintWriter writer;

    @Override
    public PersistenceUnitDef setupConnection(PersistenceUnitDef unit, JPADataSource dataSource) {
        unit.transactionType(TransactionType.RESOURCE_LOCAL);
        if (Strings.isNullOrEmpty((String)dataSource.getJndiDataSource())) {
            throw new RuntimeException("Must specify a JNDI data-source.");
        }
        if (dataSource.hasJdbcConnectionInfo()) {
            ShellMessages.info((ShellPrintWriter)this.writer, (String)("Ignoring jdbc connection info [" + dataSource.getJdbcConnectionInfo() + "]"));
        }
        unit.nonJtaDataSource(dataSource.getJndiDataSource());
        unit.jtaDataSource(null);
        return unit;
    }

    @Override
    public TransactionType getTransactionType() {
        return TransactionType.RESOURCE_LOCAL;
    }
}

