/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.spec.javaee.servlet;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.facets.WebResourceFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.SetupCommand;
import org.jboss.forge.spec.javaee.ServletFacet;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.servlet.web.WebAppDescriptor;

@Alias(value="servlet")
@RequiresProject
public class ServletPlugin
implements Plugin {
    @Inject
    private Project project;
    @Inject
    private Event<InstallFacets> request;

    @DefaultCommand
    public void status(PipeOut out) {
        if (this.project.hasFacet(ServletFacet.class)) {
            ShellMessages.success((ShellPrintWriter)out, (String)"Servlet is installed.");
        } else {
            ShellMessages.warn((ShellPrintWriter)out, (String)"Servlet is NOT installed.");
        }
    }

    @SetupCommand
    public void setup(PipeOut out, @Option(name="quickstart") boolean quickstart) {
        if (!this.project.hasFacet(ServletFacet.class)) {
            this.request.fire((Object)new InstallFacets(ServletFacet.class));
        }
        if (quickstart) {
            DirectoryResource webRoot = ((WebResourceFacet)this.project.getFacet(WebResourceFacet.class)).getWebRootDirectory();
            this.installQuickstart(webRoot);
        }
        this.status(out);
    }

    private void installQuickstart(DirectoryResource webRoot) {
        ((FileResource)webRoot.getChild("404.html")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/404.html"));
        ((FileResource)webRoot.getChild("500.html")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/500.html"));
        ((FileResource)webRoot.getChild("index.html")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/index.html"));
        ((FileResource)webRoot.getChild("forge-logo.png")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/forge-logo.png"));
        ((FileResource)webRoot.getChild("forge-style.css")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/forge-style.css"));
        ((FileResource)webRoot.getChild("jboss-community.png")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/jboss-community.png"));
        ((FileResource)webRoot.getChild("bkg.gif")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/bkg.gif"));
        ((FileResource)webRoot.getChild("favicon.ico")).setContents(this.getClass().getResourceAsStream("/org/jboss/forge/web/favicon.ico"));
        FileResource descriptor = ((ServletFacet)this.project.getFacet(ServletFacet.class)).getConfigFile();
        WebAppDescriptor unit = ((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).welcomeFile("/index.html");
        unit.errorPage(404, "/404.html");
        unit.errorPage(500, "/500.html");
        descriptor.setContents(unit.exportAsString());
    }
}

