/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.command;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.editors.model.OrmShape;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramRuler;

public class DeleteGuideCommand
extends Command {
    private DiagramRuler parent;
    private DiagramGuide guide;
    private Map<OrmShape, Integer> oldParts;

    public DeleteGuideCommand(DiagramGuide guide, DiagramRuler parent) {
        super(DiagramViewerMessages.DeleteGuideCommand_Label);
        this.guide = guide;
        this.parent = parent;
    }

    public boolean canUndo() {
        return true;
    }

    public void execute() {
        this.oldParts = new HashMap<OrmShape, Integer>(this.guide.getMap());
        Iterator<OrmShape> iter = this.oldParts.keySet().iterator();
        while (iter.hasNext()) {
            this.guide.detachPart(iter.next());
        }
        this.parent.removeGuide(this.guide);
    }

    public void undo() {
        this.parent.addGuide(this.guide);
        for (OrmShape part : this.oldParts.keySet()) {
            this.guide.attachPart(part, this.oldParts.get(part));
        }
    }
}

