/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.cache.TemplateCache;
import freemarker.core.BugException;
import freemarker.core.Environment;
import freemarker.core.EvalUtil;
import freemarker.core.Expression;
import freemarker.core.NonBooleanException;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.StringLiteral;
import freemarker.core.TemplateElement;
import freemarker.core._DelayedGetMessage;
import freemarker.core._DelayedJQuote;
import freemarker.core._MiscTemplateException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

final class Include
extends TemplateElement {
    private final Expression includedTemplatePathExp;
    private final Expression encodingExp;
    private final Expression parseExp;
    private final Expression ignoreMissingExp;
    private final String encoding;
    private final Boolean parse;
    private final Boolean ignoreMissing;
    private final String baseDirectoryPath;

    Include(Template template, Expression includedTemplatePathExp, Expression encodingExp, Expression parseExp, Expression ignoreMissingExp) throws ParseException {
        block23: {
            this.baseDirectoryPath = this.getBaseDirectoryPath(template);
            this.includedTemplatePathExp = includedTemplatePathExp;
            this.encodingExp = encodingExp;
            if (encodingExp == null) {
                this.encoding = null;
            } else if (encodingExp.isLiteral()) {
                try {
                    TemplateModel tm = encodingExp.eval(null);
                    if (!(tm instanceof TemplateScalarModel)) {
                        throw new ParseException("Expected a string as the value of the \"encoding\" argument", encodingExp);
                    }
                    this.encoding = ((TemplateScalarModel)tm).getAsString();
                }
                catch (TemplateException e) {
                    throw new BugException(e);
                }
            } else {
                this.encoding = null;
            }
            this.parseExp = parseExp;
            if (parseExp == null) {
                this.parse = Boolean.TRUE;
            } else if (parseExp.isLiteral()) {
                try {
                    if (parseExp instanceof StringLiteral) {
                        this.parse = StringUtil.getYesNo(parseExp.evalAndCoerceToString(null));
                    }
                    try {
                        this.parse = parseExp.evalToBoolean(template.getConfiguration());
                    }
                    catch (NonBooleanException e) {
                        throw new ParseException("Expected a boolean or string as the value of the parse attribute", parseExp, e);
                    }
                }
                catch (TemplateException e) {
                    throw new BugException(e);
                }
            } else {
                this.parse = null;
            }
            this.ignoreMissingExp = ignoreMissingExp;
            if (ignoreMissingExp == null) {
                this.ignoreMissing = Boolean.FALSE;
            } else {
                if (ignoreMissingExp.isLiteral()) {
                    try {
                        try {
                            this.ignoreMissing = ignoreMissingExp.evalToBoolean(template.getConfiguration());
                            break block23;
                        }
                        catch (NonBooleanException e) {
                            throw new ParseException("Expected a boolean as the value of the \"ignore_missing\" attribute", ignoreMissingExp, e);
                        }
                    }
                    catch (TemplateException e) {
                        throw new BugException(e);
                    }
                }
                this.ignoreMissing = null;
            }
        }
    }

    private String getBaseDirectoryPath(Template template) {
        String s = template.getName();
        if (s == null) {
            return "";
        }
        int lastSlash = s.lastIndexOf(47);
        return lastSlash == -1 ? "" : s.substring(0, lastSlash + 1);
    }

    void accept(Environment env) throws TemplateException, IOException {
        Template includedTemplate;
        TemplateModel tm;
        String encoding;
        String includedTemplatePath = this.includedTemplatePathExp.evalAndCoerceToString(env);
        String string = this.encoding != null ? this.encoding : (encoding = this.encodingExp != null ? this.encodingExp.evalAndCoerceToString(env) : null);
        boolean parse = this.parse != null ? this.parse : ((tm = this.parseExp.eval(env)) instanceof TemplateScalarModel ? this.getYesNo(this.parseExp, EvalUtil.modelToString((TemplateScalarModel)tm, this.parseExp, env)) : this.parseExp.modelToBoolean(tm, env));
        boolean ignoreMissing = this.ignoreMissing != null ? this.ignoreMissing.booleanValue() : this.ignoreMissingExp.evalToBoolean(env);
        String fullIncludedTemplatePath = TemplateCache.getFullTemplatePath(env, this.baseDirectoryPath, includedTemplatePath);
        try {
            includedTemplate = env.getTemplateForInclusion(fullIncludedTemplatePath, encoding, parse, ignoreMissing);
        }
        catch (ParseException e) {
            throw new _MiscTemplateException((Throwable)e, env, new Object[]{"Error parsing included template ", new _DelayedJQuote(fullIncludedTemplatePath), ":\n", new _DelayedGetMessage(e)});
        }
        catch (IOException e) {
            throw new _MiscTemplateException((Throwable)e, env, new Object[]{"Error reading included file ", new _DelayedJQuote(fullIncludedTemplatePath), ":\n", new _DelayedGetMessage(e)});
        }
        if (includedTemplate != null) {
            env.include(includedTemplate);
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.includedTemplatePathExp.getCanonicalForm());
        if (this.encodingExp != null) {
            buf.append(" encoding=").append(this.encodingExp.getCanonicalForm());
        }
        if (this.parseExp != null) {
            buf.append(" parse=").append(this.parseExp.getCanonicalForm());
        }
        if (this.ignoreMissingExp != null) {
            buf.append(" ignore_missing=").append(this.ignoreMissingExp.getCanonicalForm());
        }
        if (canonical) {
            buf.append("/>");
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#include";
    }

    private boolean getYesNo(Expression exp, String s) throws TemplateException {
        try {
            return StringUtil.getYesNo(s);
        }
        catch (IllegalArgumentException iae) {
            throw new _MiscTemplateException(exp, new Object[]{"Value must be boolean (or one of these strings: \"n\", \"no\", \"f\", \"false\", \"y\", \"yes\", \"t\", \"true\"), but it was ", new _DelayedJQuote(s), "."});
        }
    }

    int getParameterCount() {
        return 3;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.includedTemplatePathExp;
            }
            case 1: {
                return this.parseExp;
            }
            case 2: {
                return this.encodingExp;
            }
            case 3: {
                return this.ignoreMissingExp;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.TEMPLATE_NAME;
            }
            case 1: {
                return ParameterRole.PARSE_PARAMETER;
            }
            case 2: {
                return ParameterRole.ENCODING_PARAMETER;
            }
            case 3: {
                return ParameterRole.IGNORE_MISSING_PARAMETER;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

