/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * A ApplicationServerInternalException is thrown to indicate error conditions
 * specific to the Applcation server. This could include such errors as
 * configuration related or implementation mechanism related errors.
 */
public class ApplicationServerInternalException extends ResourceException
{
   /**
    * Create an exception.
    */
   public ApplicationServerInternalException()
   {
      super();
   }
   
   /**
	 * Create an exception with a reason.
    * 
    * @param reason the reason
	 */
   public ApplicationServerInternalException(String reason)
   {
      super(reason);
   }

   /**
	 * Create an exception with a reason and an errorCode.
    * 
    * @param reason the reason
    * @param errorCode the error code
	 */
   public ApplicationServerInternalException(String reason, String errorCode)
   {
      super(reason, errorCode);
   }

   /**
    * Create an exception with a reason and cause.
    * 
    * @param reason the reason
    * @param cause the cause
    */
   public ApplicationServerInternalException(String reason, Throwable cause)
   {
      super(reason, cause);
   }

   /**
    * Create an exception with a cause.
    * 
    * @param cause the cause
    */
   public ApplicationServerInternalException(Throwable cause)
   {
      super(cause);
   }
}