/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Method;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.OptimisticLockException;
import javax.transaction.Synchronization;
import org.jboss.seam.Component;
import org.jboss.seam.Entity;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.persistence.EntityManagerProxy;
import org.jboss.seam.persistence.Filter;

@Name(value="org.jboss.seam.persistence.persistenceProvider")
@Scope(value=ScopeType.STATELESS)
@BypassInterceptors
@Install(precedence=0, classDependencies={"javax.persistence.EntityManager"})
public class PersistenceProvider {
    public void setFlushModeManual(EntityManager entityManager) {
        throw new UnsupportedOperationException("For use of FlushMode.MANUAL, please use Hibernate as the persistence provider or use a custom PersistenceProvider");
    }

    public boolean isDirty(EntityManager entityManager) {
        return true;
    }

    public Object getId(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getIdentifier(bean);
    }

    public String getName(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getName();
    }

    public Object getVersion(Object bean, EntityManager entityManager) {
        return Entity.forClass(bean.getClass()).getVersion(bean);
    }

    public void checkVersion(Object bean, EntityManager entityManager, Object oldVersion, Object version) {
        boolean equal = oldVersion instanceof Date ? ((Date)oldVersion).getTime() == ((Date)version).getTime() : oldVersion.equals(version);
        if (!equal) {
            throw new OptimisticLockException("current database version number does not match passivated version number");
        }
    }

    public void enableFilter(Filter filter, EntityManager entityManager) {
        throw new UnsupportedOperationException("For filters, please use Hibernate as the persistence provider");
    }

    public boolean registerSynchronization(Synchronization sync, EntityManager entityManager) {
        return false;
    }

    public static PersistenceProvider instance() {
        return (PersistenceProvider)Component.getInstance(PersistenceProvider.class, ScopeType.STATELESS);
    }

    public Object proxyDelegate(Object delegate) {
        return delegate;
    }

    public EntityManager proxyEntityManager(EntityManager entityManager) {
        return new EntityManagerProxy(entityManager);
    }

    public Class getBeanClass(Object bean) {
        return Entity.forClass(bean.getClass()).getBeanClass();
    }

    public Method getPostLoadMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPostLoadMethod();
    }

    public Method getPrePersistMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPrePersistMethod();
    }

    public Method getPreUpdateMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPreUpdateMethod();
    }

    public Method getPreRemoveMethod(Class beanClass) {
        return Entity.forClass(beanClass).getPreRemoveMethod();
    }
}

