/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.el.impl;

import com.sun.faces.el.impl.ElException;
import com.sun.faces.el.impl.ImplicitObjects;
import com.sun.faces.el.impl.VariableResolver;
import javax.servlet.jsp.PageContext;

public class JspVariableResolver
extends VariableResolver {
    private PageContext mCtx;

    public JspVariableResolver(PageContext pCtx) {
        this.mCtx = pCtx;
    }

    public Object resolveVariable(String pName) throws ElException {
        try {
            return this.resolve(pName);
        }
        catch (ElException e) {
            throw new ElException(e.getMessage());
        }
    }

    public Object resolve(String pName) throws ElException {
        if ("pageContext".equals(pName)) {
            return this.mCtx;
        }
        if ("pageScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getPageScopeMap();
        }
        if ("requestScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getRequestScopeMap();
        }
        if ("sessionScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getSessionScopeMap();
        }
        if ("applicationScope".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getApplicationScopeMap();
        }
        if ("param".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getParamMap();
        }
        if ("paramValues".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getParamsMap();
        }
        if ("header".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getHeaderMap();
        }
        if ("headerValues".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getHeadersMap();
        }
        if ("initParam".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getInitParamMap();
        }
        if ("cookie".equals(pName)) {
            return ImplicitObjects.getImplicitObjects(this.mCtx).getCookieMap();
        }
        return this.mCtx.findAttribute(pName);
    }
}

